/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.tomcat.util.res.StringManager;

public class ConfigFileLoader {
    private static final StringManager sm = StringManager.getManager(ConfigFileLoader.class.getPackage().getName());
    private static final File CATALINA_BASE_FILE;
    private static final URI CATALINA_BASE_URI;

    private ConfigFileLoader() {
    }

    public static InputStream getInputStream(String string) throws IOException {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(CATALINA_BASE_FILE, string);
        }
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        URI uRI = CATALINA_BASE_URI != null ? CATALINA_BASE_URI.resolve(string) : URI.create(string);
        try {
            return uRI.toURL().openStream();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(sm.getString("configFileLoader.cannotObtainURL", string), illegalArgumentException);
        }
    }

    static {
        String string = System.getProperty("catalina.base");
        if (string != null) {
            CATALINA_BASE_FILE = new File(string);
            CATALINA_BASE_URI = CATALINA_BASE_FILE.toURI();
        } else {
            CATALINA_BASE_FILE = null;
            CATALINA_BASE_URI = null;
        }
    }
}

