/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.file.Matcher;
import org.apache.tomcat.util.res.StringManager;

public class StandardJarScanner
implements JarScanner {
    private final Log log = LogFactory.getLog(StandardJarScanner.class);
    private static final Set<String> defaultJarsToSkip = new HashSet<String>();
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.scan");
    private boolean scanClassPath = true;
    private boolean scanAllFiles = false;
    private boolean scanAllDirectories = false;
    private boolean scanBootstrapClassPath = false;

    public boolean isScanClassPath() {
        return this.scanClassPath;
    }

    public void setScanClassPath(boolean bl) {
        this.scanClassPath = bl;
    }

    public boolean isScanAllFiles() {
        return this.scanAllFiles;
    }

    public void setScanAllFiles(boolean bl) {
        this.scanAllFiles = bl;
    }

    public boolean isScanAllDirectories() {
        return this.scanAllDirectories;
    }

    public void setScanAllDirectories(boolean bl) {
        this.scanAllDirectories = bl;
    }

    public boolean isScanBootstrapClassPath() {
        return this.scanBootstrapClassPath;
    }

    public void setScanBootstrapClassPath(boolean bl) {
        this.scanBootstrapClassPath = bl;
    }

    public void scan(ServletContext servletContext, ClassLoader classLoader, JarScannerCallback jarScannerCallback, Set<String> set) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        Set<String> set2 = set == null ? defaultJarsToSkip : set;
        Set set3 = servletContext.getResourcePaths("/WEB-INF/lib/");
        if (set3 != null) {
            for (String string : set3) {
                if (string.endsWith(".jar") && !Matcher.matchName(set2, string.substring(string.lastIndexOf(47) + 1))) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sm.getString("jarScan.webinflibJarScan", string));
                    }
                    URL uRL = null;
                    try {
                        String string2 = servletContext.getRealPath(string);
                        uRL = string2 == null ? servletContext.getResource(string) : new File(string2).toURI().toURL();
                        this.process(jarScannerCallback, uRL);
                    }
                    catch (IOException iOException) {
                        this.log.warn((Object)sm.getString("jarScan.webinflibFail", uRL), (Throwable)iOException);
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", string));
            }
        }
        if (this.scanClassPath && classLoader != null) {
            this.doScanClassPath(classLoader, jarScannerCallback, set2);
        }
    }

    protected void doScanClassPath(ClassLoader classLoader, JarScannerCallback jarScannerCallback, Set<String> set) {
        URL[] uRLArray;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.classloaderStart"));
        }
        ClassLoader classLoader2 = classLoader;
        ClassLoader classLoader3 = null;
        if (!this.scanBootstrapClassPath) {
            classLoader3 = ClassLoader.getSystemClassLoader().getParent();
        }
        HashSet<URL> hashSet = new HashSet<URL>();
        while (classLoader2 != null && classLoader2 != classLoader3) {
            if (classLoader2 instanceof URLClassLoader) {
                uRLArray = ((URLClassLoader)classLoader2).getURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    String string = this.getJarName(uRLArray[i]);
                    if (string != null && !Matcher.matchName(set, string) && !uRLArray[i].toString().contains("/WEB-INF/lib/" + (String)string)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)sm.getString("jarScan.classloaderJarScan", uRLArray[i]));
                        }
                        try {
                            this.process(jarScannerCallback, uRLArray[i]);
                            hashSet.add(uRLArray[i]);
                        }
                        catch (IOException iOException) {
                            this.log.warn((Object)sm.getString("jarScan.classloaderFail", uRLArray[i]), (Throwable)iOException);
                        }
                        continue;
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", uRLArray[i]));
                }
            }
            classLoader2 = classLoader2.getParent();
        }
        if (JreCompat.isJre9Available()) {
            uRLArray = this.getClassPath();
            LinkedList<URL> linkedList = new LinkedList<URL>();
            JreCompat.getInstance().addBootModulePath(linkedList);
            uRLArray.addAll(linkedList);
            for (URL uRL : uRLArray) {
                if (hashSet.contains(uRL)) continue;
                hashSet.add(uRL);
                String string = this.getJarName(uRL);
                if (string != null && Matcher.matchName(set, string)) continue;
                try {
                    this.process(jarScannerCallback, uRL);
                }
                catch (IOException iOException) {
                    this.log.warn((Object)sm.getString("jarScan.classloaderFail", uRL), (Throwable)iOException);
                }
            }
        }
    }

    protected List<URL> getClassPath() {
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return Collections.emptyList();
        }
        String[] stringArray = string.split(File.pathSeparator);
        ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
        for (String string2 : stringArray) {
            File file = new File(string2);
            try {
                arrayList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                this.log.warn((Object)sm.getString("jarScan.classPath.badEntry", string2), (Throwable)malformedURLException);
            }
        }
        return arrayList;
    }

    protected void process(JarScannerCallback jarScannerCallback, URL uRL) throws IOException {
        URLConnection uRLConnection;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.jarUrlStart", uRL));
        }
        if ((uRLConnection = uRL.openConnection()) instanceof JarURLConnection) {
            jarScannerCallback.scan((JarURLConnection)uRLConnection);
        } else {
            String string = uRL.toString();
            if (string.startsWith("file:") || string.startsWith("jndi:") || string.startsWith("http:") || string.startsWith("https:")) {
                if (string.endsWith(".jar")) {
                    URL uRL2 = UriUtil.buildJarUrl((String)string);
                    jarScannerCallback.scan((JarURLConnection)uRL2.openConnection());
                } else {
                    try {
                        File file;
                        File file2 = new File(uRL.toURI());
                        if (file2.isFile() && this.scanAllFiles) {
                            URL uRL3 = UriUtil.buildJarUrl((File)file2);
                            jarScannerCallback.scan((JarURLConnection)uRL3.openConnection());
                        } else if (file2.isDirectory() && this.scanAllDirectories && (file = new File(file2.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            jarScannerCallback.scan(file2);
                        }
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        IOException iOException = new IOException();
                        iOException.initCause(throwable);
                        throw iOException;
                    }
                }
            }
        }
    }

    private String getJarName(URL uRL) {
        String string = null;
        String string2 = uRL.getPath();
        int n = string2.indexOf(".jar");
        if (n != -1) {
            int n2 = string2.lastIndexOf(47, n);
            string = string2.substring(n2 + 1, n + 4);
        } else if (this.isScanAllDirectories()) {
            int n3 = string2.lastIndexOf(47);
            string = string2.substring(n3 + 1);
        }
        return string;
    }

    static {
        String string = System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                defaultJarsToSkip.add(string2);
            }
        }
    }
}

