/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.net.URI;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.spi.queries.VersioningQueryImplementation;
import org.openide.util.Lookup;

public final class VersioningQuery {
    private static final Logger LOG = Logger.getLogger(FileEncodingQuery.class.getName());
    private static final Lookup.Result<VersioningQueryImplementation> implementations = Lookup.getDefault().lookupResult(VersioningQueryImplementation.class);

    private VersioningQuery() {
    }

    public static boolean isManaged(URI uRI) {
        Object object;
        Objects.requireNonNull(uRI);
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl && !uRI.equals(object = uRI.normalize())) {
            throw new IllegalArgumentException("Must pass a normalized URI: " + uRI + " vs. " + object);
        }
        for (VersioningQueryImplementation versioningQueryImplementation : implementations.allInstances()) {
            if (!versioningQueryImplementation.isManaged(uRI)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0} is VCS managed", new Object[]{uRI});
            }
            return true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0} isn't managed by any VCS", new Object[]{uRI});
        }
        return false;
    }

    public static String getRemoteLocation(URI uRI) {
        Object object;
        Objects.requireNonNull(uRI);
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (bl && !uRI.equals(object = uRI.normalize())) {
            throw new IllegalArgumentException("Must pass a normalized URI: " + uRI + " vs. " + object);
        }
        for (VersioningQueryImplementation versioningQueryImplementation : implementations.allInstances()) {
            String string = versioningQueryImplementation.getRemoteLocation(uRI);
            if (string == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "{0}: received remote location {1}", new Object[]{uRI, string});
            }
            return string;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "{0}: received no remote location", new Object[]{uRI});
        }
        return null;
    }
}

