/*
 * Decompiled with CFR 0.152.
 */
package esmska.transfer;

import esmska.data.Tuple;
import esmska.transfer.ProxyManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class GatewayConnector {
    private static final Logger logger = Logger.getLogger(GatewayConnector.class.getName());
    private static final String USER_AGENT = "Mozilla/5.0 (X11; U; Linux x86_64; cs-CZ; rv:1.9.1.9) Gecko/20100402 Ubuntu/9.10 (karmic) Firefox/3.5.9";
    private static final Pattern metaRedirPattern = Pattern.compile("<meta\\s+http-equiv=[^>]*refresh[^>]*url=([^>]*)(\"|')[^>]*>", 2);
    private static final Pattern metaCharsetPattern = Pattern.compile("<meta\\s+http-equiv=[^>]*content-type[^>]*charset=([^>]*)(\"|')[^>]*>", 2);
    private static final Pattern xmlCharsetPattern = Pattern.compile("<\\?xml[^>]*encoding=(\"|')([^>]*)(\"|')[^>]*\\?>", 2);
    private final HttpClient client = new HttpClient();
    private String[] postData;
    private boolean doPost;
    private String textContent;
    private byte[] binaryContent;
    private String referer;
    private String fullURL;
    private Tuple<String, Integer> lastRedirect = new Tuple<Object, Integer>(null, 0);

    public GatewayConnector() {
        this.client.getParams().setCookiePolicy("compatibility");
        this.client.getParams().setParameter("http.protocol.single-cookie-header", true);
        this.client.getParams().setParameter("http.useragent", USER_AGENT);
        this.client.getParams().setParameter("http.protocol.allow-circular-redirects", true);
        this.client.getParams().setParameter("http.protocol.reject-relative-redirect", false);
        this.client.getParams().setParameter("http.protocol.max-redirects", 50);
        this.client.getParams().setParameter("http.protocol.content-charset", "UTF-8");
        this.client.getParams().setParameter("http.protocol.element-charset", "UTF-8");
        this.client.getParams().setParameter("http.protocol.uri-charset", "UTF-8");
    }

    public boolean isTextContent() {
        return this.textContent != null;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public byte[] getBinaryContent() {
        return this.binaryContent;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void setLanguage(String languageCode) {
        HashSet<Header> headerSet = (HashSet<Header>)this.client.getHostConfiguration().getParams().getParameter("http.default-headers");
        if (headerSet == null) {
            headerSet = new HashSet<Header>();
        }
        Header languageHeader = new Header("Accept-Language", languageCode);
        headerSet.add(languageHeader);
        this.client.getHostConfiguration().getParams().setParameter("http.default-headers", headerSet);
        logger.log(Level.FINER, "Preferred language set: {0}", languageCode);
    }

    private void setBinaryContent(byte[] binaryContent) {
        this.binaryContent = binaryContent;
        this.textContent = null;
    }

    private void setTextContent(String textContent) {
        this.textContent = textContent;
        this.binaryContent = null;
    }

    public void forgetCookie(String name, String domain, String path) {
        Cookie[] cookies = this.client.getState().getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (name != null && !name.equals(cookie.getName()) || domain != null && !domain.equals(cookie.getDomain()) || path != null && !path.equals(cookie.getPath())) continue;
            cookies[i] = null;
        }
        this.client.getState().clearCookies();
        this.client.getState().addCookies(cookies);
    }

    public void setConnection(String url, String[] params, boolean doPost, String[] postData) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("url");
        }
        this.doPost = doPost;
        this.postData = postData;
        this.fullURL = url;
        String param = GatewayConnector.convertParamsToString(params);
        if (param.length() > 0) {
            this.fullURL = this.fullURL + "?" + param;
        }
        URL address = new URL(this.fullURL);
        this.client.getHostConfiguration().setHost(address.getHost(), address.getPort(), address.getProtocol());
        if ("http".equals(address.getProtocol())) {
            this.client.getHostConfiguration().setProxyHost(ProxyManager.getProxyHost(ProxyManager.ProxyType.HTTP));
        } else if ("https".equals(address.getProtocol())) {
            this.client.getHostConfiguration().setProxyHost(ProxyManager.getProxyHost(ProxyManager.ProxyType.HTTPS));
        } else {
            this.client.getHostConfiguration().setProxyHost(ProxyManager.getProxyHost(ProxyManager.ProxyType.SOCKS));
        }
    }

    public boolean connect() throws IOException {
        this.textContent = null;
        this.binaryContent = null;
        if (this.doPost) {
            return this.doPost(this.fullURL, this.postData);
        }
        return this.doGet(this.fullURL);
    }

    private String findContentCharset(byte[] content) {
        Validate.notNull(content);
        try {
            String text = new String(content, "UTF-8");
            Matcher matcher = metaCharsetPattern.matcher(text);
            if (matcher.find()) {
                String charset = matcher.group(1);
                return charset;
            }
            matcher = xmlCharsetPattern.matcher(text);
            if (matcher.find()) {
                String charset = matcher.group(2);
                return charset;
            }
        }
        catch (Exception ex) {
            logger.log(Level.FINER, "Could not find encoding of reponse: ", ex);
        }
        return null;
    }

    private boolean doGet(String url) throws IOException {
        String redirect;
        int statusCode;
        logger.log(Level.FINE, "Getting url: {0}", url);
        GetMethod method = new GetMethod(url);
        if (this.referer != null) {
            method.setRequestHeader("Referer", this.referer);
        }
        if ((statusCode = this.client.executeMethod(method)) != 200) {
            logger.log(Level.WARNING, "Problem connecting to \"{0}\". Response: {1}", new Object[]{url, method.getStatusLine()});
            return false;
        }
        Header contentType = method.getResponseHeader("Content-Type");
        boolean text = contentType != null && contentType.getValue().startsWith("text");
        byte[] response = new byte[]{};
        InputStream responseStream = method.getResponseBodyAsStream();
        if (responseStream != null) {
            response = IOUtils.toByteArray(responseStream);
            responseStream.close();
        }
        method.releaseConnection();
        if (text) {
            String charset = this.findContentCharset(response);
            this.setTextContent(new String(response, StringUtils.defaultIfEmpty(charset, method.getResponseCharSet())));
            logger.log(Level.FINEST, "Retrieved text web content: {0}\n#### WEB CONTENT START ####\n{1}\n#### WEB CONTENT END ####", new Object[]{contentType, this.getTextContent()});
        } else {
            this.setBinaryContent(response);
            logger.log(Level.FINEST, "Retrieved binary web content: {0}", contentType);
        }
        if (text && (redirect = GatewayConnector.checkMetaRedirect(this.textContent)) != null) {
            logger.log(Level.FINE, "Following web redirect to: {0}", redirect);
            String redir = this.computeRedirect(redirect, method.getURI());
            return this.doGet(redir);
        }
        return true;
    }

    private boolean doPost(String url, String[] postData) throws IOException {
        String redirect;
        logger.log(Level.FINE, "Posting data to url: {0}", url);
        PostMethod method = new PostMethod(url);
        if (this.referer != null) {
            method.setRequestHeader("Referer", this.referer);
        }
        method.setRequestEntity(new StringRequestEntity(GatewayConnector.convertParamsToString(postData), "application/x-www-form-urlencoded", "UTF-8"));
        int statuscode = this.client.executeMethod(method);
        if (statuscode >= 400) {
            logger.log(Level.WARNING, "Problem connecting to \"{0}\". Response: {1}", new Object[]{url, method.getStatusLine()});
            return false;
        }
        Header contentType = method.getResponseHeader("Content-Type");
        boolean text = contentType != null && contentType.getValue().startsWith("text");
        byte[] response = new byte[]{};
        InputStream responseStream = method.getResponseBodyAsStream();
        if (responseStream != null) {
            response = IOUtils.toByteArray(responseStream);
            responseStream.close();
        }
        method.releaseConnection();
        if (text) {
            String charset = this.findContentCharset(response);
            this.setTextContent(new String(response, StringUtils.defaultIfEmpty(charset, method.getResponseCharSet())));
            logger.log(Level.FINEST, "Retrieved text web content: {0}\n#### WEB CONTENT START ####\n{1}\n#### WEB CONTENT END ####", new Object[]{contentType, this.getTextContent()});
        } else {
            this.setBinaryContent(response);
            logger.log(Level.FINEST, "Retrieved binary web content: {0}", contentType);
        }
        if (statuscode >= 300 && statuscode < 400) {
            Header header = method.getResponseHeader("Location");
            if (header == null) {
                throw new IOException("Invalid HTTP redirect, no Location header");
            }
            String newURL = header.getValue();
            if (StringUtils.isEmpty(newURL)) {
                throw new IOException("Invalid HTTP redirect, Location header is empty");
            }
            if (!GatewayConnector.isAbsoluteURL(newURL) && !newURL.startsWith("/")) {
                newURL = this.computeRedirect(newURL, method.getURI());
            }
            if (!StringUtils.isAsciiPrintable(newURL)) {
                logger.log(Level.FINE, "Received invalidly encoded redirect URL: {0}", newURL);
                String[] parts = StringUtils.split(newURL, "?", 2);
                newURL = parts[0] + "?" + URLEncoder.encode(parts[1], "UTF-8");
                logger.log(Level.FINE, "URL converted to: {0}", newURL);
            }
            if (newURL.contains("|")) {
                logger.log(Level.FINE, "URL contains invalid character `|`: {0}", newURL);
                newURL = newURL.replace("|", "%7C");
                logger.log(Level.FINE, "URL converted to: {0}", newURL);
            }
            logger.log(Level.FINE, "Following http redirect to: {0}", newURL);
            return this.doGet(newURL);
        }
        if (text && (redirect = GatewayConnector.checkMetaRedirect(this.textContent)) != null) {
            logger.log(Level.FINE, "Following web redirect to: {0}", redirect);
            String redir = this.computeRedirect(redirect, method.getURI());
            return this.doGet(redir);
        }
        return true;
    }

    private static String convertParamsToString(String[] params) throws UnsupportedEncodingException {
        if (params == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < params.length; ++i) {
            if (i % 2 == 0) continue;
            String value = params[i];
            String key = params[i - 1];
            if (StringUtils.isEmpty(key)) continue;
            string = string + key + "=";
            string = string + URLEncoder.encode(value, "UTF-8") + "&";
        }
        if (string.endsWith("&")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String checkMetaRedirect(String page) {
        Matcher matcher = metaRedirPattern.matcher(page);
        if (matcher.find()) {
            String redirect = matcher.group(1);
            return redirect;
        }
        return null;
    }

    private String computeRedirect(String redirectURL, URI currentURI) throws IOException {
        int slash;
        Object uri;
        if (redirectURL == null) {
            throw new IllegalArgumentException("redirectURL");
        }
        if (currentURI == null) {
            throw new IllegalArgumentException("currentURI");
        }
        if (redirectURL.startsWith("./") || redirectURL.startsWith("../")) {
            try {
                redirectURL = this.convertRelativeRedirectToAbsolute(currentURI.toString(), redirectURL);
            }
            catch (IOException ex) {
                throw new IOException("Invalid HTTP redirect, Location header must be an absolute path and is: '" + redirectURL + "'", ex);
            }
        }
        if (redirectURL.startsWith("/")) {
            if (GatewayConnector.isAbsoluteURL(currentURI.getEscapedURI())) {
                uri = currentURI.getEscapedURI();
                slash = ((String)uri).indexOf(47, "https://".length());
                if (slash > 0) {
                    uri = ((String)uri).substring(0, slash);
                }
                redirectURL = (String)uri + redirectURL;
            }
        } else if (!GatewayConnector.isAbsoluteURL(redirectURL)) {
            if (!GatewayConnector.isAbsoluteURL(currentURI.getEscapedURI())) {
                uri = currentURI.getEscapedURI();
                slash = ((String)uri).lastIndexOf(47);
                uri = slash > 0 ? ((String)uri).substring(0, slash + 1) : "";
                redirectURL = (String)uri + redirectURL;
            } else {
                uri = currentURI.getEscapedURI();
                slash = ((String)uri).lastIndexOf(47);
                if (slash > "https://".length()) {
                    uri = ((String)uri).substring(0, slash);
                }
                redirectURL = (String)uri + "/" + redirectURL;
            }
        }
        try {
            uri = new URI(redirectURL, true);
        }
        catch (URIException ex) {
            logger.log(Level.FINER, "The computed redirect URL has invalid syntax ({0}): {1}", new Object[]{ex.getMessage(), redirectURL});
            try {
                URI uri2 = new URI(redirectURL, false);
                redirectURL = uri2.getEscapedURI();
            }
            catch (Exception e) {
                throw new IOException("The computed redirect URL has invalid syntax and it can't be even fixed (" + e.getMessage() + "): " + redirectURL);
            }
        }
        if (ObjectUtils.equals(this.lastRedirect.get1(), redirectURL)) {
            this.lastRedirect.set2(this.lastRedirect.get2() + 1);
        } else {
            this.lastRedirect.set1(redirectURL);
            this.lastRedirect.set2(0);
        }
        if (this.lastRedirect.get2() > 5) {
            throw new IOException("HTTP meta redirection endless loop detected");
        }
        logger.log(Level.FINE, "Computed new redirect full URL is: {0}", redirectURL);
        return redirectURL;
    }

    private String convertRelativeRedirectToAbsolute(String oldUrl, String redirect) throws IOException {
        try {
            String protocol = oldUrl.substring(0, oldUrl.indexOf("//") + 2);
            String stub = oldUrl.substring(protocol.length());
            String redir = redirect;
            if (stub.contains("?")) {
                stub = stub.substring(0, stub.indexOf("?"));
            }
            if (stub.contains("/")) {
                stub = stub.substring(0, stub.lastIndexOf("/"));
            }
            while (redir.startsWith("./") || redir.startsWith("../")) {
                if (redir.startsWith("./")) {
                    redir = redir.substring(2);
                    continue;
                }
                if (!redir.startsWith("../")) continue;
                redir = redir.substring(3);
                stub = stub.substring(0, stub.lastIndexOf("/"));
            }
            return protocol + stub + "/" + redir;
        }
        catch (Exception ex) {
            throw new IOException("The redirect '" + redirect + "' is not valid redirect to URL '" + oldUrl + "'", ex);
        }
    }

    private static boolean isAbsoluteURL(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }
}

