/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections.debuginfo;

import jadx.api.plugins.input.data.ILocalVar;
import jadx.plugins.input.dex.sections.SectionReader;
import jadx.plugins.input.dex.sections.debuginfo.DebugInfo;
import jadx.plugins.input.dex.sections.debuginfo.LocalVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class DebugInfoParser {
    private static final int DBG_END_SEQUENCE = 0;
    private static final int DBG_ADVANCE_PC = 1;
    private static final int DBG_ADVANCE_LINE = 2;
    private static final int DBG_START_LOCAL = 3;
    private static final int DBG_START_LOCAL_EXTENDED = 4;
    private static final int DBG_END_LOCAL = 5;
    private static final int DBG_RESTART_LOCAL = 6;
    private static final int DBG_SET_PROLOGUE_END = 7;
    private static final int DBG_SET_EPILOGUE_BEGIN = 8;
    private static final int DBG_SET_FILE = 9;
    private static final int DBG_FIRST_SPECIAL = 10;
    private static final int DBG_LINE_BASE = -4;
    private static final int DBG_LINE_RANGE = 15;
    private final SectionReader in;
    private final SectionReader ext;
    private final LocalVar[] locals;
    private final int codeSize;
    private List<ILocalVar> resultList;
    private Map<Integer, Integer> linesMap;
    @Nullable
    private String sourceFile;
    private List<String> argTypes;
    private int[] argRegs;

    public DebugInfoParser(SectionReader in, int regsCount, int codeSize) {
        this.in = in;
        this.ext = in.copy();
        this.locals = new LocalVar[regsCount];
        this.codeSize = codeSize;
    }

    public void initMthArgs(int regsCount, List<String> argTypes) {
        if (argTypes.isEmpty()) {
            this.argTypes = Collections.emptyList();
            return;
        }
        int argsCount = argTypes.size();
        int[] argRegsArr = new int[argsCount];
        int regNum = regsCount;
        for (int i = argsCount - 1; i >= 0; --i) {
            argRegsArr[i] = regNum -= DebugInfoParser.getTypeLen(argTypes.get(i));
        }
        this.argRegs = argRegsArr;
        this.argTypes = argTypes;
    }

    public static int getTypeLen(String type) {
        switch (type.charAt(0)) {
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    public DebugInfo process(int debugOff) {
        this.in.absPos(debugOff);
        boolean varsInfoFound = false;
        this.resultList = new ArrayList<ILocalVar>();
        this.linesMap = new HashMap<Integer, Integer>();
        int addr = 0;
        int line = this.in.readUleb128();
        int paramsCount = this.in.readUleb128();
        int argsCount = this.argTypes.size();
        for (int i = 0; i < paramsCount; ++i) {
            int nameId = this.in.readUleb128p1();
            String name = this.ext.getString(nameId);
            if (name == null || i >= argsCount) continue;
            int regNum = this.argRegs[i];
            this.startVar(new LocalVar(regNum, name, this.argTypes.get(i)), -1);
            varsInfoFound = true;
        }
        this.addrChange(-1, 1, line);
        this.setLine(addr, line);
        int c = this.in.readUByte();
        while (c != 0) {
            switch (c) {
                case 1: {
                    int addrInc = this.in.readUleb128();
                    addr = this.addrChange(addr, addrInc, line);
                    this.setLine(addr, line);
                    break;
                }
                case 2: {
                    line += this.in.readSleb128();
                    break;
                }
                case 3: {
                    int regNum = this.in.readUleb128();
                    int nameId = this.in.readUleb128() - 1;
                    int type = this.in.readUleb128() - 1;
                    LocalVar var = new LocalVar(this.ext, regNum, nameId, type, -1);
                    this.startVar(var, addr);
                    varsInfoFound = true;
                    break;
                }
                case 4: {
                    int regNum = this.in.readUleb128();
                    int nameId = this.in.readUleb128p1();
                    int type = this.in.readUleb128p1();
                    int sign = this.in.readUleb128p1();
                    LocalVar var = new LocalVar(this.ext, regNum, nameId, type, sign);
                    this.startVar(var, addr);
                    varsInfoFound = true;
                    break;
                }
                case 6: {
                    int regNum = this.in.readUleb128();
                    this.restartVar(regNum, addr);
                    varsInfoFound = true;
                    break;
                }
                case 5: {
                    int regNum = this.in.readUleb128();
                    LocalVar var = this.locals[regNum];
                    if (var != null) {
                        this.endVar(var, addr);
                    }
                    varsInfoFound = true;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    int idx = this.in.readUleb128() - 1;
                    this.sourceFile = this.ext.getString(idx);
                    break;
                }
                default: {
                    int adjustedOpCode = c - 10;
                    int addrInc = adjustedOpCode / 15;
                    addr = this.addrChange(addr, addrInc, line);
                    this.setLine(addr, line += -4 + adjustedOpCode % 15);
                    break;
                }
            }
            c = this.in.readUByte();
        }
        if (varsInfoFound) {
            for (LocalVar var : this.locals) {
                if (var == null || var.isEnd()) continue;
                this.endVar(var, this.codeSize - 1);
            }
        }
        this.setSourceLines(addr, this.codeSize, line);
        return new DebugInfo(this.linesMap, this.resultList);
    }

    private int addrChange(int addr, int addrInc, int line) {
        int newAddr = addr + addrInc;
        int maxAddr = this.codeSize - 1;
        newAddr = Math.min(newAddr, maxAddr);
        this.setSourceLines(addr, newAddr, line);
        return newAddr;
    }

    private void setSourceLines(int start, int end, int line) {
        for (int offset = start + 1; offset < end; ++offset) {
            this.setLine(offset, line);
        }
    }

    private void setLine(int offset, int line) {
        this.linesMap.put(offset, line);
    }

    private void restartVar(int regNum, int addr) {
        LocalVar prev = this.locals[regNum];
        if (prev != null) {
            this.endVar(prev, addr);
            LocalVar newVar = new LocalVar(regNum, prev.getName(), prev.getType(), prev.getSignature());
            this.startVar(newVar, addr);
        }
    }

    private void startVar(LocalVar newVar, int addr) {
        int regNum = newVar.getRegNum();
        LocalVar prev = this.locals[regNum];
        if (prev != null) {
            this.endVar(prev, addr);
        }
        newVar.start(addr);
        this.locals[regNum] = newVar;
    }

    private void endVar(LocalVar var, int addr) {
        if (var.end(addr)) {
            this.resultList.add(var);
        }
    }
}

