/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.JumpPosition;
import java.util.Objects;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeLinkGenerator
implements LinkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CodeLinkGenerator.class);
    private final CodeArea codeArea;
    private final JNode jNode;

    public CodeLinkGenerator(CodeArea codeArea) {
        this.codeArea = codeArea;
        this.jNode = codeArea.getNode();
    }

    @Nullable
    public JumpPosition getJumpLinkAtOffset(RSyntaxTextArea textArea, int offset) {
        try {
            if (this.jNode.getCodeInfo() == null) {
                return null;
            }
            int sourceOffset = this.getLinkSourceOffset(textArea, offset);
            if (sourceOffset == -1) {
                return null;
            }
            return this.getJumpBySourceOffset(textArea, sourceOffset);
        }
        catch (Exception e) {
            LOG.error("getJumpLinkAtOffset error", (Throwable)e);
            return null;
        }
    }

    public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, int offset) {
        try {
            if (this.jNode.getCodeInfo() == null) {
                return null;
            }
            final int sourceOffset = this.getLinkSourceOffset(textArea, offset);
            if (sourceOffset == -1) {
                return null;
            }
            final JumpPosition defPos = this.getJumpBySourceOffset(textArea, sourceOffset);
            if (defPos == null) {
                return null;
            }
            return new LinkGeneratorResult(){

                public HyperlinkEvent execute() {
                    return new HyperlinkEvent(defPos, HyperlinkEvent.EventType.ACTIVATED, null, defPos.getNode().makeLongString());
                }

                public int getSourceOffset() {
                    return sourceOffset;
                }
            };
        }
        catch (Exception e) {
            LOG.error("isLinkAtOffset error", (Throwable)e);
            return null;
        }
    }

    private int getLinkSourceOffset(RSyntaxTextArea textArea, int offset) {
        Token token = textArea.modelToToken(offset);
        return this.codeArea.adjustOffsetForToken(token);
    }

    @Nullable
    private JumpPosition getJumpBySourceOffset(RSyntaxTextArea textArea, int sourceOffset) throws BadLocationException {
        JumpPosition defPos = this.codeArea.getDefPosForNodeAtOffset(sourceOffset);
        if (defPos == null) {
            return null;
        }
        if (Objects.equals(defPos.getNode().getRootClass(), this.jNode) && defPos.getLine() == textArea.getLineOfOffset(sourceOffset) + 1) {
            return null;
        }
        return defPos;
    }
}

