/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target.local;

import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalTargetEnvironmentRequest
implements TargetEnvironmentRequest {
    private static int nextSyntheticId = 0;
    private TargetEnvironmentRequest.Volume myDefaultVolume;
    private final Map<String, LocalDownloadVolume> myDownloadRoots = new LinkedHashMap();
    private final Map<String, LocalUploadVolume> myUploadRoots = new LinkedHashMap();
    @NotNull
    private GeneralCommandLine.ParentEnvironmentType myParentEnvironmentType = GeneralCommandLine.ParentEnvironmentType.CONSOLE;

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = TargetPlatform.CURRENT;
        if (targetPlatform == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(0);
        }
        return targetPlatform;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.Volume getDefaultVolume() {
        if (this.myDefaultVolume == null) {
            this.myDefaultVolume = this.createUploadRoot(null, true);
        }
        TargetEnvironmentRequest.Volume volume = this.myDefaultVolume;
        if (volume == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(1);
        }
        return volume;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.Volume createUploadRoot(@Nullable String remoteRootPath, boolean temporary) {
        String id = LocalTargetEnvironmentRequest.nextSyntheticId();
        if (remoteRootPath == null) {
            remoteRootPath = id;
        }
        TargetEnvironmentRequest.Volume volume = this.myUploadRoots.computeIfAbsent(remoteRootPath, path2 -> new LocalUploadVolume(this, id));
        if (volume == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(2);
        }
        return volume;
    }

    @Override
    @NotNull
    public TargetEnvironmentRequest.DownloadableVolume createDownloadRoot(@Nullable String remoteRootPath) {
        String id = LocalTargetEnvironmentRequest.nextSyntheticId();
        if (remoteRootPath == null) {
            remoteRootPath = "";
        }
        TargetEnvironmentRequest.DownloadableVolume downloadableVolume = this.myDownloadRoots.computeIfAbsent(remoteRootPath, path2 -> new LocalDownloadVolume(this, id, (String)path2));
        if (downloadableVolume == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(3);
        }
        return downloadableVolume;
    }

    @Override
    @NotNull
    public TargetValue<Integer> bindTargetPort(int targetPort) {
        TargetValue<Integer> targetValue = TargetValue.fixed(targetPort);
        if (targetValue == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(4);
        }
        return targetValue;
    }

    @Override
    @NotNull
    public TargetValue<HostPort> bindLocalPort(int localPort) {
        TargetValue<HostPort> targetValue = TargetValue.fixed(new HostPort("localhost", localPort));
        if (targetValue == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(5);
        }
        return targetValue;
    }

    @NotNull
    GeneralCommandLine.ParentEnvironmentType getParentEnvironmentType() {
        GeneralCommandLine.ParentEnvironmentType parentEnvironmentType = this.myParentEnvironmentType;
        if (parentEnvironmentType == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(6);
        }
        return parentEnvironmentType;
    }

    private static String nextSyntheticId() {
        return LocalTargetEnvironmentRequest.class.getSimpleName() + ":volume:" + nextSyntheticId++;
    }

    public void setParentEnvironmentType(@NotNull GeneralCommandLine.ParentEnvironmentType parentEnvironmentType) {
        if (parentEnvironmentType == null) {
            LocalTargetEnvironmentRequest.$$$reportNull$$$0(7);
        }
        this.myParentEnvironmentType = parentEnvironmentType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVolume";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUploadRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDownloadRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "bindTargetPort";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "bindLocalPort";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentEnvironmentType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setParentEnvironmentType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LocalDownloadVolume
    extends LocalUploadVolume
    implements TargetEnvironmentRequest.DownloadableVolume {
        private final String myRootPath;

        LocalDownloadVolume(@NotNull LocalTargetEnvironmentRequest request, @NotNull String volumeId, @NotNull String rootPath) {
            if (request == null) {
                LocalDownloadVolume.$$$reportNull$$$0(0);
            }
            if (volumeId == null) {
                LocalDownloadVolume.$$$reportNull$$$0(1);
            }
            if (rootPath == null) {
                LocalDownloadVolume.$$$reportNull$$$0(2);
            }
            super(request, volumeId);
            this.myRootPath = rootPath;
        }

        @Override
        @NotNull
        public String getRemoteRoot() {
            String string = this.myRootPath;
            if (string == null) {
                LocalDownloadVolume.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public TargetValue<String> createDownload(@NotNull String rootRelativePath) {
            if (rootRelativePath == null) {
                LocalDownloadVolume.$$$reportNull$$$0(4);
            }
            String fullPath = LocalDownloadVolume.concatPaths(this.myRootPath, rootRelativePath);
            TargetValue<String> targetValue = TargetValue.fixed(fullPath);
            if (targetValue == null) {
                LocalDownloadVolume.$$$reportNull$$$0(5);
            }
            return targetValue;
        }

        @NotNull
        private static String concatPaths(@NotNull String parent, @NotNull String child) {
            if (parent == null) {
                LocalDownloadVolume.$$$reportNull$$$0(6);
            }
            if (child == null) {
                LocalDownloadVolume.$$$reportNull$$$0(7);
            }
            String string = StringUtil.isEmptyOrSpaces((String)parent) ? child : parent + Platform.current().fileSeparator + child;
            if (string == null) {
                LocalDownloadVolume.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volumeId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest$LocalDownloadVolume";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootRelativePath";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest$LocalDownloadVolume";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDownload";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "concatPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDownload";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "concatPaths";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LocalUploadVolume
    implements TargetEnvironmentRequest.Volume {
        private final LocalTargetEnvironmentRequest myRequest;
        private final String myVolumeId;

        LocalUploadVolume(@NotNull LocalTargetEnvironmentRequest request, @NotNull String volumeId) {
            if (request == null) {
                LocalUploadVolume.$$$reportNull$$$0(0);
            }
            if (volumeId == null) {
                LocalUploadVolume.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
            this.myVolumeId = volumeId;
        }

        @Override
        @NotNull
        public String getVolumeId() {
            String string = this.myVolumeId;
            if (string == null) {
                LocalUploadVolume.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public Platform getPlatform() {
            Platform platform = this.myRequest.getTargetPlatform().getPlatform();
            if (platform == null) {
                LocalUploadVolume.$$$reportNull$$$0(3);
            }
            return platform;
        }

        @Override
        @NotNull
        public TargetValue<String> createUpload(@NotNull String localPath) {
            if (localPath == null) {
                LocalUploadVolume.$$$reportNull$$$0(4);
            }
            TargetValue<String> targetValue = TargetValue.fixed(localPath);
            if (targetValue == null) {
                LocalUploadVolume.$$$reportNull$$$0(5);
            }
            return targetValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "volumeId";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest$LocalUploadVolume";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/target/local/LocalTargetEnvironmentRequest$LocalUploadVolume";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVolumeId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPlatform";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createUpload";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createUpload";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

