/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class ProjectJdkTable {
    public static final Topic<Listener> JDK_TABLE_TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);

    public static ProjectJdkTable getInstance() {
        return (ProjectJdkTable)ApplicationManager.getApplication().getService(ProjectJdkTable.class);
    }

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1);

    @Nullable
    public abstract Sdk findJdk(@NotNull String var1, @NotNull String var2);

    public abstract Sdk @NotNull [] getAllJdks();

    @NotNull
    public abstract List<Sdk> getSdksOfType(@NotNull SdkTypeId var1);

    @Nullable
    public Sdk findMostRecentSdkOfType(@NotNull SdkTypeId type) {
        if (type == null) {
            ProjectJdkTable.$$$reportNull$$$0(0);
        }
        return this.getSdksOfType(type).stream().max(type.versionComparator()).orElse(null);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public Sdk findMostRecentSdk(@NotNull Condition<? super Sdk> condition) {
        if (condition == null) {
            ProjectJdkTable.$$$reportNull$$$0(1);
        }
        Sdk found = null;
        for (Sdk each : this.getAllJdks()) {
            if (!condition.value((Object)each) || found != null && Comparing.compare((Comparable)((Object)each.getVersionString()), (Comparable)((Object)found.getVersionString())) <= 0) continue;
            found = each;
        }
        return found;
    }

    public abstract void addJdk(@NotNull Sdk var1);

    public void addJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        if (jdk == null) {
            ProjectJdkTable.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            ProjectJdkTable.$$$reportNull$$$0(3);
        }
        this.addJdk(jdk);
        Disposer.register((Disposable)parentDisposable, () -> WriteAction.runAndWait(() -> this.removeJdk(jdk)));
    }

    public abstract void removeJdk(@NotNull Sdk var1);

    public abstract void updateJdk(@NotNull Sdk var1, @NotNull Sdk var2);

    @NotNull
    public abstract SdkTypeId getDefaultSdkType();

    @NotNull
    public abstract SdkTypeId getSdkTypeByName(@NotNull String var1);

    @NotNull
    public abstract Sdk createSdk(@NotNull String var1, @NotNull SdkTypeId var2);

    public void preconfigure() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/ProjectJdkTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMostRecentSdkOfType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findMostRecentSdk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addJdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Deprecated
    public static class Adapter
    implements Listener {
    }

    public static interface Listener
    extends EventListener {
        default public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (previousName == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/projectRoots/ProjectJdkTable$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkRemoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkNameChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

