/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.find.FindManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageDataUtil;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.ExporterToTextFile;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.PreviewUsageAction;
import com.intellij.usages.impl.UsageModelTracker;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageNodeTreeBuilder;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewElementsListener;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.usages.impl.UsageViewTreeCellRenderer;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.impl.actions.RuleAction;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageFilteringRule;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class UsageViewImpl
implements UsageViewEx {
    private static final Logger LOG = Logger.getInstance(UsageViewImpl.class);
    @NonNls
    public static final String SHOW_RECENT_FIND_USAGES_ACTION_ID = "UsageView.ShowRecentFindUsages";
    private final UsageNodeTreeBuilder myBuilder;
    private MyPanel myRootPanel;
    private JTree myTree;
    private final ScheduledFuture<?> myFireEventsFuture;
    private Content myContent;
    private final UsageViewPresentation myPresentation;
    private final UsageTarget[] myTargets;
    protected UsageGroupingRule[] myGroupingRules;
    protected UsageFilteringRule[] myFilteringRules;
    private final Factory<UsageSearcher> myUsageSearcherFactory;
    private final Project myProject;
    private volatile boolean mySearchInProgress;
    private final ExporterToTextFile myTextFileExporter;
    private final SingleAlarm myUpdateAlarm;
    private final ExclusionHandlerEx<DefaultMutableTreeNode> myExclusionHandler;
    private final Map<Usage, UsageNode> myUsageNodes;
    public static final UsageNode NULL_NODE = new UsageNode(null, NullUsage.INSTANCE);
    private final ButtonPanel myButtonPanel;
    private boolean myNeedUpdateButtons;
    private final JComponent myAdditionalComponent;
    private volatile boolean isDisposed;
    private volatile boolean myChangesDetected;
    public static final Comparator<Usage> USAGE_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == NullUsage.INSTANCE) {
            return -1;
        }
        if (o2 == NullUsage.INSTANCE) {
            return 1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass() == o2.getClass()) {
            int selfcompared = ((Comparable)((Object)o1)).compareTo(o2);
            if (selfcompared != 0) {
                return selfcompared;
            }
            if (o1 instanceof UsageInFile && o2 instanceof UsageInFile) {
                UsageInFile u1 = (UsageInFile)o1;
                UsageInFile u2 = (UsageInFile)o2;
                VirtualFile f1 = u1.getFile();
                VirtualFile f2 = u2.getFile();
                if (f1 != null && f1.isValid() && f2 != null && f2.isValid()) {
                    return f1.getPresentableUrl().compareTo(f2.getPresentableUrl());
                }
            }
            return 0;
        }
        return o1.toString().compareTo(o2.toString());
    };
    @NonNls
    public static final String HELP_ID = "ideaInterface.find";
    private UsageContextPanel myCurrentUsageContextPanel;
    private List<UsageContextPanel.Provider> myUsageContextPanelProviders;
    private UsageContextPanel.Provider myCurrentUsageContextProvider;
    private JPanel myCentralPanel;
    private final GroupNode myRoot;
    private final UsageViewTreeModelBuilder myModel;
    private final Object lock;
    private Splitter myPreviewSplitter;
    private volatile ProgressIndicator associatedProgress;
    private boolean myExpandingCollapsing;
    private final UsageViewTreeCellRenderer myUsageViewTreeCellRenderer;
    private Usage myOriginUsage;
    @Nullable
    private Action myRerunAction;
    private boolean myDisposeSmartPointersOnClose;
    private final ExecutorService updateRequests;
    private final List<UsageView.ExcludeListener> myExcludeListeners;
    private Set<Pair<Class<? extends PsiReference>, Language>> myReportedReferenceClasses;
    private final MultiMap<Node, Node> changedNodesToFire;
    private final Consumer<Node> edtNodeChangedQueue;
    private final Set<Node> nodesInsertedUnder;
    private final Consumer<Node> edtNodeInsertedUnderQueue;
    protected final TreeExpander treeExpander;
    private boolean rulesChanged;

    public UsageViewImpl(@NotNull Project project, @NotNull UsageViewPresentation presentation, UsageTarget @NotNull [] targets, Factory<UsageSearcher> usageSearcherFactory) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            UsageViewImpl.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(2);
        }
        this.mySearchInProgress = true;
        this.myTextFileExporter = new ExporterToTextFile(this, this.getUsageViewSettings());
        this.myUpdateAlarm = new SingleAlarm(() -> {
            if (this.isDisposed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.getProject());
            documentManager.cancelAndRunWhenAllCommitted((Object)"UpdateUsageView", this::updateImmediately);
        }, 300);
        this.myUsageNodes = new ConcurrentHashMap<Usage, UsageNode>();
        this.myAdditionalComponent = new JPanel(new BorderLayout());
        this.lock = new Object();
        this.myDisposeSmartPointersOnClose = true;
        this.updateRequests = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Usage View Update Requests", (Executor)PooledThreadExecutor.INSTANCE, (int)JobSchedulerImpl.getJobPoolParallelism(), (Disposable)this);
        this.myExcludeListeners = ContainerUtil.createConcurrentList();
        this.myReportedReferenceClasses = new HashSet<Pair<Class<? extends PsiReference>, Language>>();
        this.changedNodesToFire = MultiMap.createLinked();
        this.edtNodeChangedQueue = node -> {
            if (!this.getPresentation().isDetachedMode()) {
                MultiMap<Node, Node> multiMap = this.changedNodesToFire;
                synchronized (multiMap) {
                    Node parent = (Node)node.getParent();
                    if (parent != null) {
                        this.changedNodesToFire.putValue((Object)parent, node);
                    }
                }
            }
        };
        this.nodesInsertedUnder = new LinkedHashSet<Node>();
        this.edtNodeInsertedUnderQueue = parent -> {
            if (parent == null) {
                UsageViewImpl.$$$reportNull$$$0(82);
            }
            if (!this.getPresentation().isDetachedMode()) {
                Set<Node> set = this.nodesInsertedUnder;
                synchronized (set) {
                    this.nodesInsertedUnder.add((Node)parent);
                }
            }
        };
        this.treeExpander = new TreeExpander(){

            @Override
            public void expandAll() {
                UsageViewImpl.this.expandAll();
                UsageViewImpl.this.getUsageViewSettings().setExpanded(true);
            }

            @Override
            public boolean canExpand() {
                return true;
            }

            @Override
            public void collapseAll() {
                UsageViewImpl.this.collapseAll();
                UsageViewImpl.this.getUsageViewSettings().setExpanded(false);
            }

            @Override
            public boolean canCollapse() {
                return true;
            }
        };
        this.myFireEventsFuture = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(this::fireEvents, 50L, 50L, TimeUnit.MILLISECONDS);
        Disposer.register((Disposable)this, () -> this.myFireEventsFuture.cancel(false));
        this.myPresentation = presentation;
        this.myTargets = targets;
        this.myUsageSearcherFactory = usageSearcherFactory;
        this.myProject = project;
        this.myButtonPanel = new ButtonPanel();
        this.myModel = new UsageViewTreeModelBuilder(this.myPresentation, targets);
        this.myRoot = (GroupNode)this.myModel.getRoot();
        UsageModelTracker myModelTracker = new UsageModelTracker(project);
        Disposer.register((Disposable)this, (Disposable)myModelTracker);
        this.myGroupingRules = UsageViewImpl.getActiveGroupingRules(project, this.getUsageViewSettings());
        this.myFilteringRules = this.getActiveFilteringRules(project);
        this.myBuilder = new UsageNodeTreeBuilder(this.myTargets, this.myGroupingRules, this.myFilteringRules, this.myRoot, this.myProject);
        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, this::rulesChanged);
        messageBusConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                UsageViewImpl.this.rulesChanged();
            }

            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                UsageViewImpl.this.rulesChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myUsageViewTreeCellRenderer = new UsageViewTreeCellRenderer(this);
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.isDisposed()) {
                        return;
                    }
                    this.myTree = new Tree(this.myModel){
                        {
                            ToolTipManager.sharedInstance().registerComponent(this);
                        }

                        @Override
                        public boolean isRootVisible() {
                            return false;
                        }

                        @Override
                        public String getToolTipText(MouseEvent e) {
                            TreePath path2 = this.getPathForLocation(e.getX(), e.getY());
                            if (path2 != null && this.getCellRenderer() instanceof UsageViewTreeCellRenderer) {
                                return UsageViewTreeCellRenderer.getTooltipFromPresentation(path2.getLastPathComponent());
                            }
                            return null;
                        }

                        @Override
                        public boolean isPathEditable(TreePath path2) {
                            return path2.getLastPathComponent() instanceof UsageViewTreeModelBuilder.TargetsRootNode;
                        }

                        @Override
                        public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
                            return UsageViewImpl.this.myExpandingCollapsing ? Collections.emptyEnumeration() : super.getExpandedDescendants(parent);
                        }
                    };
                    this.myTree.setName("UsageViewTree");
                    this.myRootPanel = new MyPanel(this.myTree);
                    Disposer.register((Disposable)this, (Disposable)this.myRootPanel);
                    this.myTree.setModel(this.myModel);
                    this.myRootPanel.setLayout(new BorderLayout());
                    SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
                    this.myRootPanel.add((Component)((Object)toolWindowPanel), "Center");
                    toolWindowPanel.setToolbar(this.createActionsToolbar());
                    this.myCentralPanel = new JPanel(new BorderLayout());
                    this.setupCentralPanel();
                    this.initTree();
                    toolWindowPanel.setContent(this.myCentralPanel);
                    this.myTree.setCellRenderer(this.myUsageViewTreeCellRenderer);
                    SwingUtilities.invokeLater(() -> {
                        if (!this.isDisposed()) {
                            this.collapseAll();
                        }
                    });
                    myModelTracker.addListener(isPropertyChange -> {
                        if (!isPropertyChange) {
                            this.myChangesDetected = true;
                        }
                        this.updateLater();
                    }, this);
                    if (this.myPresentation.isShowCancelButton()) {
                        this.addButtonToLowerPane(this::close, UsageViewBundle.message("usage.view.cancel.button", new Object[0]));
                    }
                    this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                        @Override
                        public void valueChanged(TreeSelectionEvent e) {
                            SwingUtilities.invokeLater(() -> {
                                if (!UsageViewImpl.this.isDisposed()) {
                                    UsageViewImpl.this.updateOnSelectionChanged();
                                    UsageViewImpl.this.myNeedUpdateButtons = true;
                                }
                            });
                        }
                    });
                    this.myModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                        protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                            if (event == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            if (type == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            UsageViewImpl.this.myNeedUpdateButtons = true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "type";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/usages/impl/UsageViewImpl$4";
                            objectArray[2] = "process";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    this.myTree.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            if (UsageViewImpl.this.rulesChanged) {
                                UsageViewImpl.this.rulesChanged = false;
                                UsageViewImpl.this.rulesChanged();
                            }
                        }
                    });
                }
            });
        }
        this.myExclusionHandler = new ExclusionHandlerEx<DefaultMutableTreeNode>(){

            @Override
            public boolean isNodeExclusionAvailable(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    6.$$$reportNull$$$0(0);
                }
                return node instanceof UsageNode;
            }

            @Override
            public boolean isNodeExcluded(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    6.$$$reportNull$$$0(1);
                }
                return ((UsageNode)node).isDataExcluded();
            }

            @Override
            public void excludeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    6.$$$reportNull$$$0(2);
                }
                HashSet nodes = new HashSet();
                UsageViewImpl.collectAllChildNodes(node, nodes);
                this.collectParentNodes(node, true, nodes);
                this.setExcludeNodes(nodes, true, true);
            }

            @Override
            public void excludeNodeSilently(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    6.$$$reportNull$$$0(3);
                }
                HashSet nodes = new HashSet();
                UsageViewImpl.collectAllChildNodes(node, nodes);
                this.collectParentNodes(node, true, nodes);
                this.setExcludeNodes(nodes, true, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void collectParentNodes(@NotNull DefaultMutableTreeNode node, boolean almostAllChildrenExcluded, @NotNull Set<? super Node> nodes) {
                List otherNodes;
                GroupNode parentNode;
                TreeNode parent;
                if (node == null) {
                    6.$$$reportNull$$$0(4);
                }
                if (nodes == null) {
                    6.$$$reportNull$$$0(5);
                }
                if ((parent = node.getParent()) == UsageViewImpl.this.myRoot || !(parent instanceof GroupNode)) {
                    return;
                }
                GroupNode groupNode = parentNode = (GroupNode)parent;
                synchronized (groupNode) {
                    otherNodes = ContainerUtil.filter(parentNode.getChildren(), n -> n.isExcluded() != almostAllChildrenExcluded);
                }
                if (otherNodes.size() == 1 && otherNodes.get(0) == node) {
                    nodes.add(parentNode);
                    this.collectParentNodes(parentNode, almostAllChildrenExcluded, nodes);
                }
            }

            private void setExcludeNodes(@NotNull Set<? extends Node> nodes, boolean excluded, boolean updateImmediately) {
                if (nodes == null) {
                    6.$$$reportNull$$$0(6);
                }
                LinkedHashSet<Usage> affectedUsages = new LinkedHashSet<Usage>();
                for (Node node : nodes) {
                    Object userObject = node.getUserObject();
                    if (userObject instanceof Usage) {
                        affectedUsages.add((Usage)userObject);
                    }
                    node.setExcluded(excluded, (Consumer<? super Node>)UsageViewImpl.this.edtNodeChangedQueue);
                }
                if (updateImmediately) {
                    UsageViewImpl.this.updateImmediatelyNodesUpToRoot(nodes);
                    for (UsageView.ExcludeListener excludeListener : UsageViewImpl.this.myExcludeListeners) {
                        excludeListener.fireExcluded(affectedUsages, excluded);
                    }
                }
            }

            @Override
            public void includeNode(@NotNull DefaultMutableTreeNode node) {
                if (node == null) {
                    6.$$$reportNull$$$0(7);
                }
                HashSet nodes = new HashSet();
                UsageViewImpl.collectAllChildNodes(node, nodes);
                this.collectParentNodes(node, false, nodes);
                this.setExcludeNodes(nodes, false, true);
            }

            @Override
            public boolean isActionEnabled(boolean isExcludeAction) {
                return UsageViewImpl.this.getPresentation().isExcludeAvailable();
            }

            @Override
            public void onDone(boolean isExcludeAction) {
                EDT.assertIsEdt();
                if (UsageViewImpl.this.myRootPanel.hasNextOccurence()) {
                    UsageViewImpl.this.myRootPanel.goNextOccurence();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nodes";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExclusionAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNodeExcluded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNode";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "excludeNodeSilently";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "collectParentNodes";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setExcludeNodes";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "includeNode";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public UsageViewSettings getUsageViewSettings() {
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        if (usageViewSettings == null) {
            UsageViewImpl.$$$reportNull$$$0(3);
        }
        return usageViewSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvents() {
        ArrayList changed;
        ArrayList<Node> insertedUnder;
        EDT.assertIsEdt();
        Set<Node> set = this.nodesInsertedUnder;
        synchronized (set) {
            insertedUnder = new ArrayList<Node>(this.nodesInsertedUnder);
            this.nodesInsertedUnder.clear();
        }
        TIntArrayList indicesToFire = new TIntArrayList();
        ArrayList<Node> nodesToFire = new ArrayList<Node>();
        for (Node parentNode : insertedUnder) {
            List<Node> swingChildren = ((GroupNode)parentNode).getSwingChildren();
            Node node = parentNode;
            synchronized (node) {
                List<Node> modelChildren = ((GroupNode)parentNode).getChildren();
                assert (modelChildren.size() >= swingChildren.size());
                int k = 0;
                for (int i = 0; i < modelChildren.size(); ++i) {
                    Node parent;
                    Node swingNode;
                    Node modelNode = modelChildren.get(i);
                    Node node2 = swingNode = k >= swingChildren.size() ? null : swingChildren.get(k);
                    if (swingNode == modelNode) {
                        ++k;
                        continue;
                    }
                    parentNode.insertNewNode(modelNode, i);
                    indicesToFire.add(i);
                    nodesToFire.add(modelNode);
                    if (k == i) {
                        ++k;
                    }
                    if (!(modelNode instanceof UsageNode) || !((parent = (Node)modelNode.getParent()) instanceof GroupNode)) continue;
                    ((GroupNode)parent).incrementUsageCount();
                }
            }
            this.myModel.fireTreeNodesInserted(parentNode, this.myModel.getPathToRoot(parentNode), indicesToFire.toNativeArray(), nodesToFire.toArray(new Node[0]));
            nodesToFire.clear();
            indicesToFire.clear();
        }
        MultiMap<Node, Node> multiMap = this.changedNodesToFire;
        synchronized (multiMap) {
            changed = new ArrayList(this.changedNodesToFire.entrySet());
            this.changedNodesToFire.clear();
        }
        for (Map.Entry entry : changed) {
            Node parentNode = (Node)entry.getKey();
            HashSet childrenToUpdate = new HashSet((Collection)entry.getValue());
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                Node childNode = (Node)parentNode.getChildAt(i);
                if (!childrenToUpdate.contains(childNode)) continue;
                nodesToFire.add(childNode);
                indicesToFire.add(i);
            }
            this.myModel.fireTreeNodesChanged(parentNode, this.myModel.getPathToRoot(parentNode), indicesToFire.toNativeArray(), nodesToFire.toArray(new Node[0]));
            nodesToFire.clear();
            indicesToFire.clear();
        }
    }

    @Override
    public void searchFinished() {
        this.drainQueuedUsageNodes();
        this.setSearchInProgress(false);
    }

    @Override
    public boolean searchHasBeenCancelled() {
        ProgressIndicator progress = this.associatedProgress;
        return progress != null && progress.isCanceled();
    }

    @Override
    public void cancelCurrentSearch() {
        ProgressIndicator progress = this.associatedProgress;
        if (progress != null) {
            ProgressWrapper.unwrapAll((ProgressIndicator)progress).cancel();
        }
    }

    private void clearRendererCache() {
        EDT.assertIsEdt();
        if (this.myExpandingCollapsing) {
            return;
        }
        TreeUI ui = this.myTree.getUI();
        if (ui instanceof BasicTreeUI) {
            AbstractLayoutCache treeState = (AbstractLayoutCache)ReflectionUtil.getField(BasicTreeUI.class, (Object)ui, AbstractLayoutCache.class, (String)"treeState");
            Rectangle visibleRect = this.myTree.getVisibleRect();
            int rowForLocation = this.myTree.getClosestRowForLocation(0, visibleRect.y);
            int visibleRowCount = this.getVisibleRowCount();
            ArrayList<Node> toUpdate = new ArrayList<Node>();
            for (int i = rowForLocation + visibleRowCount + 1; i >= rowForLocation; --i) {
                TreePath eachPath = this.myTree.getPathForRow(i);
                if (eachPath == null) continue;
                treeState.invalidatePathBounds(eachPath);
                Object node = eachPath.getLastPathComponent();
                if (!(node instanceof UsageNode)) continue;
                toUpdate.add((Node)node);
            }
            this.queueUpdateBulk(toUpdate, () -> {
                if (!this.isDisposed()) {
                    this.myTree.repaint(visibleRect);
                }
            });
        } else {
            this.myTree.setCellRenderer(this.myUsageViewTreeCellRenderer);
        }
    }

    private int getVisibleRowCount() {
        EDT.assertIsEdt();
        return TreeUtil.getVisibleRowCount(this.myTree);
    }

    private void setupCentralPanel() {
        EDT.assertIsEdt();
        JScrollPane treePane = ScrollPaneFactory.createScrollPane(this.myTree);
        treePane.getViewport().addChangeListener(__ -> this.clearRendererCache());
        this.myPreviewSplitter = new OnePixelSplitter(false, 0.5f, 0.1f, 0.9f);
        this.myPreviewSplitter.setFirstComponent((JComponent)treePane);
        this.myCentralPanel.add((Component)this.myPreviewSplitter, "Center");
        this.updateUsagesContextPanels();
        this.myCentralPanel.add((Component)this.myAdditionalComponent, "South");
        this.myAdditionalComponent.add((Component)this.myButtonPanel, "South");
    }

    /*
     * WARNING - void declaration
     */
    private void updateUsagesContextPanels() {
        EDT.assertIsEdt();
        this.disposeUsageContextPanels();
        if (this.isPreviewUsages()) {
            this.myPreviewSplitter.setProportion(this.getUsageViewSettings().getPreviewUsagesSplitterProportion());
            JBTabbedPane tabbedPane = new JBTabbedPane(3);
            tabbedPane.setTabComponentInsets(null);
            Object[] extensions = (UsageContextPanel.Provider[])UsageContextPanel.Provider.EP_NAME.getExtensions((AreaInstance)this.myProject);
            this.myUsageContextPanelProviders = ContainerUtil.filter((Object[])extensions, provider -> provider.isAvailableFor(this));
            LinkedHashMap<String, void> components = new LinkedHashMap<String, void>();
            for (UsageContextPanel.Provider provider2 : this.myUsageContextPanelProviders) {
                void var6_8;
                if (this.myCurrentUsageContextProvider == null || this.myCurrentUsageContextProvider == provider2) {
                    this.myCurrentUsageContextProvider = provider2;
                    this.myCurrentUsageContextPanel = provider2.create(this);
                    JComponent jComponent = this.myCurrentUsageContextPanel.createComponent();
                } else {
                    JLabel jLabel = new JLabel();
                }
                components.put(provider2.getTabTitle(), var6_8);
            }
            JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText(new BorderLayout());
            if (components.size() == 1) {
                panel2.add((Component)components.values().iterator().next(), "Center");
            } else {
                for (Map.Entry entry : components.entrySet()) {
                    tabbedPane.addTab((String)entry.getKey(), (Component)entry.getValue());
                }
                int n = this.myUsageContextPanelProviders.indexOf(this.myCurrentUsageContextProvider);
                tabbedPane.setSelectedIndex(n);
                tabbedPane.addChangeListener(e -> {
                    int currentIndex = tabbedPane.getSelectedIndex();
                    UsageContextPanel.Provider selectedProvider = this.myUsageContextPanelProviders.get(currentIndex);
                    if (selectedProvider != this.myCurrentUsageContextProvider) {
                        this.tabSelected(selectedProvider);
                    }
                });
                panel2.add(tabbedPane, "Center");
            }
            this.myPreviewSplitter.setSecondComponent((JComponent)((Object)panel2));
        } else {
            this.myPreviewSplitter.setSecondComponent(null);
            this.myPreviewSplitter.setProportion(1.0f);
        }
        this.myRootPanel.revalidate();
        this.myRootPanel.repaint();
    }

    private void tabSelected(@NotNull UsageContextPanel.Provider provider) {
        if (provider == null) {
            UsageViewImpl.$$$reportNull$$$0(4);
        }
        EDT.assertIsEdt();
        this.myCurrentUsageContextProvider = provider;
        this.updateUsagesContextPanels();
        this.updateOnSelectionChanged();
    }

    private void disposeUsageContextPanels() {
        EDT.assertIsEdt();
        if (this.myCurrentUsageContextPanel != null) {
            this.saveSplitterProportions();
            Disposer.dispose((Disposable)this.myCurrentUsageContextPanel);
            this.myCurrentUsageContextPanel = null;
        }
    }

    public boolean isPreviewUsages() {
        return this.myPresentation.isReplaceMode() ? this.getUsageViewSettings().isReplacePreviewUsages() : this.getUsageViewSettings().isPreviewUsages();
    }

    public void setPreviewUsages(boolean state) {
        if (this.myPresentation.isReplaceMode()) {
            this.getUsageViewSettings().setReplacePreviewUsages(state);
        } else {
            this.getUsageViewSettings().setPreviewUsages(state);
        }
    }

    protected UsageFilteringRule @NotNull [] getActiveFilteringRules(Project project) {
        List providers = UsageFilteringRuleProvider.EP_NAME.getExtensionList();
        ArrayList list = new ArrayList(providers.size());
        for (UsageFilteringRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.getActiveRules(project));
        }
        UsageFilteringRule[] usageFilteringRuleArray = list.toArray(UsageFilteringRule.EMPTY_ARRAY);
        if (usageFilteringRuleArray == null) {
            UsageViewImpl.$$$reportNull$$$0(5);
        }
        return usageFilteringRuleArray;
    }

    protected static UsageGroupingRule @NotNull [] getActiveGroupingRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings) {
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(6);
        }
        if (usageViewSettings == null) {
            UsageViewImpl.$$$reportNull$$$0(7);
        }
        List providers = UsageGroupingRuleProvider.EP_NAME.getExtensionList();
        ArrayList<UsageGroupingRule> list = new ArrayList<UsageGroupingRule>(providers.size());
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.getActiveRules(project, usageViewSettings));
        }
        list.sort(Comparator.comparingInt(UsageGroupingRule::getRank));
        UsageGroupingRule[] usageGroupingRuleArray = list.toArray(UsageGroupingRule.EMPTY_ARRAY);
        if (usageGroupingRuleArray == null) {
            UsageViewImpl.$$$reportNull$$$0(8);
        }
        return usageGroupingRuleArray;
    }

    private void initTree() {
        EDT.assertIsEdt();
        this.myTree.setShowsRootHandles(true);
        SmartExpander.installOn((JTree)this.myTree);
        TreeUtil.installActions(this.myTree);
        EditSourceOnDoubleClickHandler.install(this.myTree);
        EditSourceOnEnterKeyHandler.install(this.myTree);
        TreeUtil.promiseSelectFirst(this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, "UsageView.Popup", "UsageViewPopup");
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                UsageViewImpl.this.clearRendererCache();
                TreePath path2 = event.getPath();
                Object component = path2.getLastPathComponent();
                if (component instanceof Node) {
                    Node node = (Node)component;
                    if (!UsageViewImpl.this.myExpandingCollapsing && node.needsUpdate()) {
                        ArrayList toUpdate = new ArrayList();
                        UsageViewImpl.this.checkNodeValidity(node, path2, toUpdate);
                        UsageViewImpl.this.queueUpdateBulk(toUpdate, EmptyRunnable.getInstance());
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                UsageViewImpl.this.clearRendererCache();
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch(this.myTree, o -> {
            Object value = o.getLastPathComponent();
            TreeCellRenderer renderer = this.myTree.getCellRenderer();
            if (renderer instanceof UsageViewTreeCellRenderer) {
                UsageViewTreeCellRenderer coloredRenderer = (UsageViewTreeCellRenderer)renderer;
                return coloredRenderer.getPlainTextForNode(value);
            }
            return value == null ? null : value.toString();
        }, true);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        AnAction[] actions;
        EDT.assertIsEdt();
        DefaultActionGroup group = new DefaultActionGroup(){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                super.update(e);
                UsageViewImpl.this.myButtonPanel.update();
            }

            @Override
            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/usages/impl/UsageViewImpl$8", "update"));
            }
        };
        for (AnAction action : actions = this.createActions()) {
            if (action == null) continue;
            group.add(action);
        }
        return this.toUsageViewToolbar(group);
    }

    @NotNull
    private JComponent toUsageViewToolbar(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(9);
        }
        EDT.assertIsEdt();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", group, false);
        actionToolbar.setTargetComponent(this.myRootPanel);
        JComponent jComponent = actionToolbar.getComponent();
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    protected boolean isPreviewUsageActionEnabled() {
        return true;
    }

    public void addFilteringActions(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(11);
        }
        EDT.assertIsEdt();
        this.addFilteringActions(group, true);
    }

    protected void addFilteringActions(@NotNull DefaultActionGroup group, boolean includeExtensionPoints) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(12);
        }
        if (this.getPresentation().isMergeDupLinesAvailable()) {
            MergeDupLines mergeDupLines = new MergeDupLines();
            MyPanel component = this.myRootPanel;
            if (component != null) {
                mergeDupLines.registerCustomShortcutSet(mergeDupLines.getShortcutSet(), component, this);
            }
            group.add(mergeDupLines);
        }
        if (includeExtensionPoints) {
            this.addFilteringFromExtensionPoints(group);
        }
    }

    protected void addFilteringFromExtensionPoints(@NotNull DefaultActionGroup group) {
        if (group == null) {
            UsageViewImpl.$$$reportNull$$$0(13);
        }
        for (UsageFilteringRuleProvider provider : UsageFilteringRuleProvider.EP_NAME.getExtensionList()) {
            AnAction[] actions;
            for (AnAction action : actions = provider.createFilteringActions(this)) {
                group.add(action);
            }
        }
    }

    protected AnAction @NotNull [] createActions() {
        AnAction[] groupingActions;
        EDT.assertIsEdt();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        JComponent component = this.getComponent();
        AnAction expandAllAction = actionsManager.createExpandAllAction(this.treeExpander, component);
        AnAction collapseAllAction = actionsManager.createCollapseAllAction(this.treeExpander, component);
        Disposer.register((Disposable)this, () -> {
            expandAllAction.unregisterCustomShortcutSet(component);
            collapseAllAction.unregisterCustomShortcutSet(component);
        });
        DefaultActionGroup group = new DefaultActionGroup();
        group.setPopup(true);
        group.getTemplatePresentation().setIcon(AllIcons.Actions.GroupBy);
        group.getTemplatePresentation().setText(UsageViewBundle.messagePointer("action.group.by.title", new Object[0]));
        group.getTemplatePresentation().setDescription(UsageViewBundle.messagePointer("action.group.by.title", new Object[0]));
        group.getTemplatePresentation().setMultipleChoice(true);
        for (AnAction a : groupingActions = this.createGroupingActions()) {
            a.getTemplatePresentation().setMultipleChoice(true);
        }
        if (groupingActions.length > 0) {
            group.add(new Separator(UsageViewBundle.message("action.group.by.title", new Object[0])));
            group.addAll(groupingActions);
            group.add(new Separator());
        }
        this.addFilteringActions(group, false);
        DefaultActionGroup filteringSubgroup = new DefaultActionGroup();
        this.addFilteringFromExtensionPoints(filteringSubgroup);
        AnAction[] anActionArray = new AnAction[12];
        anActionArray[0] = ActionManager.getInstance().getAction("UsageView.Rerun");
        anActionArray[1] = actionsManager.createPrevOccurenceAction(this.myRootPanel);
        anActionArray[2] = actionsManager.createNextOccurenceAction(this.myRootPanel);
        anActionArray[3] = new Separator();
        anActionArray[4] = group;
        anActionArray[5] = filteringSubgroup;
        anActionArray[6] = expandAllAction;
        anActionArray[7] = collapseAllAction;
        anActionArray[8] = new Separator();
        anActionArray[9] = this.isPreviewUsageActionEnabled() ? new PreviewUsageAction(this) : null;
        anActionArray[10] = new Separator();
        AnAction anAction = anActionArray[11] = this.canShowSettings() ? new ShowSettings() : null;
        if (anActionArray == null) {
            UsageViewImpl.$$$reportNull$$$0(14);
        }
        return anActionArray;
    }

    protected boolean canShowSettings() {
        if (this.myTargets.length == 0) {
            return false;
        }
        UsageTarget target = this.myTargets[0];
        return target instanceof ConfigurableUsageTarget;
    }

    private static ConfigurableUsageTarget getConfigurableTarget(UsageTarget @NotNull [] targets) {
        UsageTarget target;
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(15);
        }
        ConfigurableUsageTarget configurableUsageTarget = null;
        if (targets.length != 0 && (target = targets[0]) instanceof ConfigurableUsageTarget) {
            configurableUsageTarget = (ConfigurableUsageTarget)target;
        }
        return configurableUsageTarget;
    }

    protected AnAction @NotNull [] createGroupingActions() {
        List providers = UsageGroupingRuleProvider.EP_NAME.getExtensionList();
        ArrayList<AnAction> list = new ArrayList<AnAction>(providers.size());
        for (UsageGroupingRuleProvider provider : providers) {
            ContainerUtil.addAll(list, (Object[])provider.createGroupingActions(this));
        }
        this.sortGroupingActions(list);
        ActionUtil.moveActionTo(list, "Module", "Flatten Modules", true);
        AnAction[] anActionArray = list.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            UsageViewImpl.$$$reportNull$$$0(16);
        }
        return anActionArray;
    }

    protected AnAction createPreviewAction() {
        return new PreviewUsageAction(this);
    }

    protected AnAction createSettingsAction() {
        return new ShowSettings();
    }

    protected AnAction createPreviousOccurrenceAction() {
        return CommonActionsManager.getInstance().createPrevOccurenceAction(this.myRootPanel);
    }

    protected AnAction createNextOccurrenceAction() {
        return CommonActionsManager.getInstance().createNextOccurenceAction(this.myRootPanel);
    }

    protected void sortGroupingActions(ArrayList<AnAction> actions) {
        ActionUtil.sortAlphabetically(actions);
    }

    private boolean shouldTreeReactNowToRuleChanges() {
        EDT.assertIsEdt();
        return this.myPresentation.isDetachedMode() || this.myTree.isShowing();
    }

    private void rulesChanged() {
        EDT.assertIsEdt();
        if (!this.shouldTreeReactNowToRuleChanges()) {
            this.rulesChanged = true;
            return;
        }
        ArrayList states = new ArrayList();
        if (this.myTree != null) {
            this.captureUsagesExpandState(new TreePath(this.myTree.getModel().getRoot()), states);
        }
        ArrayList<Usage> allUsages = new ArrayList<Usage>(this.myUsageNodes.keySet());
        allUsages.sort(USAGE_COMPARATOR);
        Set<Usage> excludedUsages = this.getExcludedUsages();
        this.reset();
        this.myGroupingRules = UsageViewImpl.getActiveGroupingRules(this.myProject, this.getUsageViewSettings());
        this.myFilteringRules = this.getActiveFilteringRules(this.myProject);
        this.myBuilder.setGroupingRules(this.myGroupingRules);
        this.myBuilder.setFilteringRules(this.myFilteringRules);
        for (int i = allUsages.size() - 1; i >= 0; --i) {
            Usage usage = (Usage)allUsages.get(i);
            if (!usage.isValid()) {
                allUsages.remove(i);
                continue;
            }
            if (!(usage instanceof MergeableUsage)) continue;
            ((MergeableUsage)((Object)usage)).reset();
        }
        this.appendUsagesInBulk(allUsages).thenRun(() -> SwingUtilities.invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.myTree != null) {
                this.excludeUsages(excludedUsages.toArray(Usage.EMPTY_ARRAY));
                this.restoreUsageExpandState(states);
                this.updateImmediately();
                if (this.myCentralPanel != null) {
                    this.updateUsagesContextPanels();
                }
            }
        }));
    }

    private void captureUsagesExpandState(@NotNull TreePath pathFrom, @NotNull Collection<? super UsageState> states) {
        if (pathFrom == null) {
            UsageViewImpl.$$$reportNull$$$0(17);
        }
        if (states == null) {
            UsageViewImpl.$$$reportNull$$$0(18);
        }
        EDT.assertIsEdt();
        if (!this.myTree.isExpanded(pathFrom)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathFrom.getLastPathComponent();
        int childCount = node.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = node.getChildAt(idx);
            if (child instanceof UsageNode) {
                Usage usage = ((UsageNode)child).getUsage();
                states.add(new UsageState(usage, this.myTree.getSelectionModel().isPathSelected(pathFrom.pathByAddingChild(child))));
                continue;
            }
            this.captureUsagesExpandState(pathFrom.pathByAddingChild(child), states);
        }
    }

    private void restoreUsageExpandState(@NotNull Collection<? extends UsageState> states) {
        if (states == null) {
            UsageViewImpl.$$$reportNull$$$0(19);
        }
        EDT.assertIsEdt();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!(defaultMutableTreeNode instanceof GroupNode)) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.myTree.expandPath(treePath);
        }
        this.myTree.getSelectionModel().clearSelection();
        for (UsageState usageState : states) {
            usageState.restore();
        }
    }

    public void expandAll() {
        this.doExpandingCollapsing(() -> TreeUtil.expandAll(this.myTree));
    }

    private void expandTree(int levels) {
        this.doExpandingCollapsing(() -> TreeUtil.expand(this.myTree, levels));
    }

    private void doExpandingCollapsing(@NotNull Runnable task) {
        if (task == null) {
            UsageViewImpl.$$$reportNull$$$0(20);
        }
        if (this.isDisposed()) {
            return;
        }
        EDT.assertIsEdt();
        this.fireEvents();
        this.myExpandingCollapsing = true;
        try {
            task.run();
        }
        finally {
            this.myExpandingCollapsing = false;
        }
        this.clearRendererCache();
    }

    private void collapseAll() {
        this.doExpandingCollapsing(() -> {
            TreeUtil.collapseAll(this.myTree, 3);
            this.myTree.expandRow(0);
        });
    }

    public void expandRoot() {
        this.expandTree(1);
    }

    @NotNull
    DefaultMutableTreeNode getModelRoot() {
        EDT.assertIsEdt();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            UsageViewImpl.$$$reportNull$$$0(21);
        }
        return defaultMutableTreeNode;
    }

    public void select() {
        EDT.assertIsEdt();
        if (this.myTree != null) {
            this.myTree.requestFocusInWindow();
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            UsageViewImpl.$$$reportNull$$$0(22);
        }
        return project;
    }

    @Nullable
    public static KeyboardShortcut getShowUsagesWithSettingsShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut("ShowSettingsAndFindUsages");
    }

    static KeyboardShortcut getShowUsagesWithSettingsShortcut(UsageTarget @NotNull [] targets) {
        ConfigurableUsageTarget configurableTarget;
        if (targets == null) {
            UsageViewImpl.$$$reportNull$$$0(23);
        }
        return (configurableTarget = UsageViewImpl.getConfigurableTarget(targets)) == null ? UsageViewImpl.getShowUsagesWithSettingsShortcut() : configurableTarget.getShortcut();
    }

    @Override
    public void associateProgress(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            UsageViewImpl.$$$reportNull$$$0(24);
        }
        this.associatedProgress = indicator;
    }

    public void refreshUsages() {
        this.reset();
        this.doReRun();
    }

    protected UsageView doReRun() {
        this.myChangesDetected = false;
        if (this.myRerunAction == null) {
            UsageViewPresentation rerunPresentation = this.myPresentation.copy();
            rerunPresentation.setOpenInNewTab(false);
            return UsageViewManager.getInstance(this.getProject()).searchAndShowUsages(this.myTargets, this.myUsageSearcherFactory, true, false, rerunPresentation, null);
        }
        this.myRerunAction.actionPerformed(null);
        return this;
    }

    private void reset() {
        EDT.assertIsEdt();
        this.myUsageNodes.clear();
        this.myModel.reset();
        if (!this.myPresentation.isDetachedMode()) {
            SwingUtilities.invokeLater(() -> this.expandTree(2));
        }
    }

    void drainQueuedUsageNodes() {
        assert (!ApplicationManager.getApplication().isDispatchThread()) : Thread.currentThread();
        UIUtil.invokeAndWaitIfNeeded(this::fireEvents);
    }

    @Override
    public void appendUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.addUpdateRequest(() -> ReadAction.run(() -> this.doAppendUsage(usage)));
        } else {
            this.doAppendUsage(usage);
        }
    }

    protected void addUpdateRequest(@NotNull Runnable request) {
        if (request == null) {
            UsageViewImpl.$$$reportNull$$$0(26);
        }
        this.updateRequests.execute(request);
    }

    @Override
    public void waitForUpdateRequestsCompletion() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        try {
            ((BoundedTaskExecutor)this.updateRequests).waitAllTasksExecuted(10L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    @NotNull
    public CompletableFuture<?> appendUsagesInBulk(@NotNull Collection<? extends Usage> usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(27);
        }
        CompletableFuture result = new CompletableFuture();
        this.addUpdateRequest(() -> ReadAction.run(() -> {
            try {
                for (Usage usage : usages) {
                    this.doAppendUsage(usage);
                }
                result.complete(null);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
                throw e;
            }
        }));
        CompletableFuture completableFuture = result;
        if (completableFuture == null) {
            UsageViewImpl.$$$reportNull$$$0(28);
        }
        return completableFuture;
    }

    public UsageNode doAppendUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(29);
        }
        assert (!ApplicationManager.getApplication().isDispatchThread());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!usage.isValid()) {
            return null;
        }
        for (Object listener2 : UsageViewElementsListener.EP_NAME.getExtensionList()) {
            listener2.beforeUsageAdded(this, usage);
        }
        this.reportToFUS(usage);
        UsageNode child = this.myBuilder.appendOrGet(usage, this.isFilterDuplicateLines(), this.edtNodeInsertedUnderQueue);
        this.myUsageNodes.put(usage, child == null ? NULL_NODE : child);
        if (child != null && this.getPresentation().isExcludeAvailable()) {
            for (UsageViewElementsListener listener3 : UsageViewElementsListener.EP_NAME.getExtensionList()) {
                if (!listener3.isExcludedByDefault(this, usage)) continue;
                this.myExclusionHandler.excludeNodeSilently(child);
            }
        }
        for (Node node = child; node != this.myRoot && node != null; node = (Node)node.getParent()) {
            node.update(this, this.edtNodeChangedQueue);
        }
        return child;
    }

    private void reportToFUS(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(30);
        }
        if (usage instanceof PsiElementUsage) {
            Pair pair;
            PsiElementUsage elementUsage = (PsiElementUsage)usage;
            Class<? extends PsiReference> referenceClass = elementUsage.getReferenceClass();
            PsiElement element = elementUsage.getElement();
            if ((referenceClass != null || element != null) && this.myReportedReferenceClasses.add((Pair<Class<? extends PsiReference>, Language>)(pair = new Pair(referenceClass, (Object)(element != null ? element.getLanguage() : null))))) {
                UsageViewStatisticsCollector.logUsageShown(this.myProject, (Class)pair.first, (Language)((Object)pair.second));
            }
        }
    }

    @Override
    public void removeUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(31);
        }
        this.removeUsagesBulk(Collections.singleton(usage));
    }

    @Override
    public void removeUsagesBulk(@NotNull Collection<? extends Usage> usages) {
        Set mergedInfos;
        Usage toSelect;
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(32);
        }
        UsageNode nodeToSelect = (toSelect = this.getNextToSelect(usages)) != null ? this.myUsageNodes.get(toSelect) : null;
        Set nodes = this.usagesToNodes(usages.stream()).collect(Collectors.toSet());
        usages.forEach(this.myUsageNodes::remove);
        if (!this.myUsageNodes.isEmpty() && !(mergedInfos = usages.stream().filter(usage -> usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getMergedInfos().length > 1).flatMap(usage -> Arrays.stream(((UsageInfo2UsageAdapter)usage).getMergedInfos())).collect(Collectors.toSet())).isEmpty()) {
            this.myUsageNodes.keySet().removeIf(usage -> usage instanceof UsageInfo2UsageAdapter && mergedInfos.contains(((UsageInfo2UsageAdapter)usage).getUsageInfo()));
        }
        if (!nodes.isEmpty() && !this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed()) {
                    return;
                }
                DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
                ((GroupNode)treeModel.getRoot()).removeUsagesBulk(nodes, treeModel);
                if (nodeToSelect != null) {
                    TreePath path2 = new TreePath(nodeToSelect.getPath());
                    this.myTree.addSelectionPath(path2);
                }
            });
        }
    }

    @Override
    public void includeUsages(Usage @NotNull [] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(33);
        }
        this.usagesToNodes(Arrays.stream(usages)).forEach(this.myExclusionHandler::includeNode);
    }

    @Override
    public void excludeUsages(Usage @NotNull [] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(34);
        }
        this.usagesToNodes(Arrays.stream(usages)).forEach(this.myExclusionHandler::excludeNode);
    }

    @NotNull
    private Stream<UsageNode> usagesToNodes(@NotNull Stream<? extends Usage> usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(35);
        }
        Stream<UsageNode> stream = usages.map(this.myUsageNodes::get).filter(node -> node != NULL_NODE && node != null);
        if (stream == null) {
            UsageViewImpl.$$$reportNull$$$0(36);
        }
        return stream;
    }

    @Override
    public void selectUsages(Usage @NotNull [] usages) {
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(37);
        }
        EDT.assertIsEdt();
        TreePath[] paths = (TreePath[])this.usagesToNodes(Arrays.stream(usages)).map(node -> new TreePath(node.getPath())).toArray(TreePath[]::new);
        this.myTree.setSelectionPaths(paths);
        if (paths.length != 0) {
            this.myTree.scrollPathToVisible(paths[0]);
        }
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        EDT.assertIsEdt();
        JComponent jComponent = this.myTree != null ? this.myTree : this.getComponent();
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(38);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        EDT.assertIsEdt();
        JComponent jComponent = this.myRootPanel == null ? new JLabel() : this.myRootPanel;
        if (jComponent == null) {
            UsageViewImpl.$$$reportNull$$$0(39);
        }
        return jComponent;
    }

    @Override
    public int getUsagesCount() {
        return this.myUsageNodes.size();
    }

    @Override
    public void addExcludeListener(@NotNull Disposable disposable, @NotNull UsageView.ExcludeListener listener2) {
        if (disposable == null) {
            UsageViewImpl.$$$reportNull$$$0(40);
        }
        if (listener2 == null) {
            UsageViewImpl.$$$reportNull$$$0(41);
        }
        this.myExcludeListeners.add(listener2);
        Disposer.register((Disposable)disposable, () -> this.myExcludeListeners.remove(listener2));
    }

    void setContent(@NotNull Content content) {
        if (content == null) {
            UsageViewImpl.$$$reportNull$$$0(42);
        }
        this.myContent = content;
        content.setDisposer(this);
    }

    private void updateImmediately() {
        EDT.assertIsEdt();
        if (this.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        ArrayList toUpdate = new ArrayList();
        this.checkNodeValidity(root, new TreePath(root), toUpdate);
        this.queueUpdateBulk(toUpdate, EmptyRunnable.getInstance());
        this.updateOnSelectionChanged();
    }

    private void queueUpdateBulk(@NotNull List<? extends Node> toUpdate, @NotNull Runnable onCompletedInEdt) {
        if (toUpdate == null) {
            UsageViewImpl.$$$reportNull$$$0(43);
        }
        if (onCompletedInEdt == null) {
            UsageViewImpl.$$$reportNull$$$0(44);
        }
        if (toUpdate.isEmpty() || this.isDisposed()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            for (Node node : toUpdate) {
                try {
                    node.update(this, this.edtNodeChangedQueue);
                }
                catch (IndexNotReadyException indexNotReadyException) {}
            }
        }).expireWith(this).finishOnUiThread(ModalityState.defaultModalityState(), __ -> onCompletedInEdt.run()).submit(this.updateRequests);
    }

    private void updateImmediatelyNodesUpToRoot(@NotNull Collection<? extends Node> nodes) {
        if (nodes == null) {
            UsageViewImpl.$$$reportNull$$$0(45);
        }
        EDT.assertIsEdt();
        if (this.isDisposed()) {
            return;
        }
        TreeNode root = (TreeNode)this.myTree.getModel().getRoot();
        HashSet<Node> queued = new HashSet<Node>();
        ArrayList<Node> toUpdate = new ArrayList<Node>();
        while (true) {
            HashSet<? extends Node> parents = new HashSet<Node>();
            for (Node node : nodes) {
                toUpdate.add(node);
                TreeNode parent = node.getParent();
                if (parent == root || !(parent instanceof Node) || !queued.add((Node)parent)) continue;
                parents.add((Node)parent);
            }
            if (parents.isEmpty()) break;
            nodes = parents;
        }
        this.queueUpdateBulk(toUpdate, EmptyRunnable.getInstance());
        this.updateImmediately();
    }

    private void updateOnSelectionChanged() {
        EDT.assertIsEdt();
        if (this.myCurrentUsageContextPanel != null) {
            try {
                this.myCurrentUsageContextPanel.updateLayout(this.getSelectedUsageInfos());
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    private void checkNodeValidity(@NotNull TreeNode node, @NotNull TreePath path2, @NotNull List<? super Node> result) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(46);
        }
        if (path2 == null) {
            UsageViewImpl.$$$reportNull$$$0(47);
        }
        if (result == null) {
            UsageViewImpl.$$$reportNull$$$0(48);
        }
        EDT.assertIsEdt();
        boolean shouldCheckChildren = true;
        if (this.myTree.isCollapsed(path2)) {
            if (node instanceof Node) {
                ((Node)node).markNeedUpdate();
            }
            shouldCheckChildren = false;
        }
        UsageViewTreeCellRenderer.RowLocation isVisible = this.myUsageViewTreeCellRenderer.isRowVisible(this.myTree.getRowForPath(new TreePath(((DefaultMutableTreeNode)node).getPath())), this.myTree.getVisibleRect());
        if (shouldCheckChildren && isVisible != UsageViewTreeCellRenderer.RowLocation.AFTER_VISIBLE_RECT) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                TreeNode child = node.getChildAt(i);
                this.checkNodeValidity(child, path2.pathByAddingChild(child), result);
            }
        }
        if (node instanceof Node && node != this.getModelRoot() && isVisible == UsageViewTreeCellRenderer.RowLocation.INSIDE_VISIBLE_RECT) {
            result.add((Node)node);
        }
    }

    void updateLater() {
        this.myUpdateAlarm.cancelAndRequest();
    }

    @Override
    public void close() {
        this.cancelCurrentSearch();
        if (this.myContent != null) {
            UsageViewContentManager.getInstance(this.myProject).closeContent(this.myContent);
        }
    }

    private void saveSplitterProportions() {
        EDT.assertIsEdt();
        this.getUsageViewSettings().setPreviewUsagesSplitterProportion(this.myPreviewSplitter.getProportion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EDT.assertIsEdt();
        this.disposeUsageContextPanels();
        Object object = this.lock;
        synchronized (object) {
            this.isDisposed = true;
            this.myUpdateAlarm.cancelAllRequests();
            this.cancelCurrentSearch();
            this.myRerunAction = null;
            if (this.myTree != null) {
                ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
            }
        }
        if (this.myDisposeSmartPointersOnClose) {
            this.disposeSmartPointers();
        }
    }

    private void disposeSmartPointers() {
        ArrayList smartPointers = new ArrayList();
        for (Usage usage : this.myUsageNodes.keySet()) {
            if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
            SmartPsiElementPointer<?> pointer = ((UsageInfo2UsageAdapter)usage).getUsageInfo().getSmartPointer();
            smartPointers.add(pointer);
        }
        if (!smartPointers.isEmpty()) {
            for (SmartPsiElementPointer smartPsiElementPointer : smartPointers) {
                Project project = smartPsiElementPointer.getProject();
                if (project.isDisposed()) continue;
                SmartPointerManager.getInstance(project).removePointer(smartPsiElementPointer);
            }
        }
        this.myUsageNodes.clear();
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchInProgress;
    }

    @Override
    public void setSearchInProgress(boolean searchInProgress) {
        this.mySearchInProgress = searchInProgress;
        if (!this.myPresentation.isDetachedMode()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.isDisposed()) {
                    return;
                }
                UsageNode firstUsageNode = this.myModel.getFirstUsageNode();
                if (firstUsageNode == null) {
                    return;
                }
                Node node = this.getSelectedNode();
                if (node != null && !Comparing.equal((Object)new TreePath(node.getPath()), (Object)TreeUtil.getFirstNodePath(this.myTree))) {
                    return;
                }
                this.showNode(firstUsageNode);
                if (this.getUsageViewSettings().isExpanded() && this.myUsageNodes.size() < 10000) {
                    this.expandAll();
                }
            });
        }
    }

    public boolean isDisposed() {
        return this.isDisposed || this.myProject.isDisposed();
    }

    private void showNode(@NotNull UsageNode node) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(49);
        }
        EDT.assertIsEdt();
        if (!this.isDisposed() && !this.myPresentation.isDetachedMode()) {
            this.fireEvents();
            TreePath usagePath = new TreePath(node.getPath());
            this.myTree.expandPath(usagePath.getParentPath());
            TreeUtil.selectPath(this.myTree, usagePath);
        }
    }

    @Override
    public void setRerunAction(@NotNull Action rerunAction) {
        if (rerunAction == null) {
            UsageViewImpl.$$$reportNull$$$0(50);
        }
        this.myRerunAction = rerunAction;
    }

    @Override
    public void addButtonToLowerPane(@NotNull Action action) {
        if (action == null) {
            UsageViewImpl.$$$reportNull$$$0(51);
        }
        EDT.assertIsEdt();
        int index = this.myButtonPanel.getComponentCount();
        if (!SystemInfo.isMac && index > 0 && this.myPresentation.isShowCancelButton()) {
            --index;
        }
        this.myButtonPanel.addButtonAction(index, action);
        Object o = action.getValue("AcceleratorKey");
        if (o instanceof KeyStroke) {
            this.myTree.registerKeyboardAction(action, (KeyStroke)o, 0);
        }
    }

    @Override
    public void addButtonToLowerPane(final @NotNull Runnable runnable, @NotNull String text) {
        if (runnable == null) {
            UsageViewImpl.$$$reportNull$$$0(52);
        }
        if (text == null) {
            UsageViewImpl.$$$reportNull$$$0(53);
        }
        this.addButtonToLowerPane(new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)text)){

            @Override
            public void actionPerformed(ActionEvent e) {
                runnable.run();
            }
        });
    }

    @Override
    public void setAdditionalComponent(@Nullable JComponent comp) {
        BorderLayout layout = (BorderLayout)this.myAdditionalComponent.getLayout();
        Component prev = layout.getLayoutComponent(this.myAdditionalComponent, "Center");
        if (prev == comp) {
            return;
        }
        if (prev != null) {
            this.myAdditionalComponent.remove(prev);
        }
        if (comp != null) {
            this.myAdditionalComponent.add((Component)comp, "Center");
        }
        this.myAdditionalComponent.revalidate();
    }

    @Override
    public void addButtonToLowerPane(@NotNull Runnable runnable, @NotNull String text, char mnemonic) {
        if (runnable == null) {
            UsageViewImpl.$$$reportNull$$$0(54);
        }
        if (text == null) {
            UsageViewImpl.$$$reportNull$$$0(55);
        }
        this.addButtonToLowerPane(runnable, text);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, @NotNull String commandName, String cannotMakeString, @NotNull String shortDescription) {
        if (processRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(56);
        }
        if (commandName == null) {
            UsageViewImpl.$$$reportNull$$$0(57);
        }
        if (shortDescription == null) {
            UsageViewImpl.$$$reportNull$$$0(58);
        }
        this.addPerformOperationAction(processRunnable, commandName, cannotMakeString, shortDescription, true);
    }

    @Override
    public void addPerformOperationAction(@NotNull Runnable processRunnable, @NotNull String commandName, String cannotMakeString, @NotNull String shortDescription, boolean checkReadOnlyStatus) {
        if (processRunnable == null) {
            UsageViewImpl.$$$reportNull$$$0(59);
        }
        if (commandName == null) {
            UsageViewImpl.$$$reportNull$$$0(60);
        }
        if (shortDescription == null) {
            UsageViewImpl.$$$reportNull$$$0(61);
        }
        MyPerformOperationRunnable runnable = new MyPerformOperationRunnable(processRunnable, commandName, cannotMakeString, checkReadOnlyStatus);
        this.addButtonToLowerPane(runnable, shortDescription);
    }

    private boolean allTargetsAreValid() {
        for (UsageTarget target : this.myTargets) {
            if (target.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public UsageViewPresentation getPresentation() {
        UsageViewPresentation usageViewPresentation = this.myPresentation;
        if (usageViewPresentation == null) {
            UsageViewImpl.$$$reportNull$$$0(62);
        }
        return usageViewPresentation;
    }

    public boolean canPerformReRun() {
        if (this.myRerunAction != null && this.myRerunAction.isEnabled()) {
            return this.allTargetsAreValid();
        }
        try {
            return this.myUsageSearcherFactory != null && this.allTargetsAreValid() && this.myUsageSearcherFactory.create() != null;
        }
        catch (PsiInvalidElementAccessException e) {
            return false;
        }
    }

    private boolean checkReadonlyUsages() {
        Set<VirtualFile> readOnlyUsages = this.getReadOnlyUsagesFiles();
        return readOnlyUsages.isEmpty() || !ReadonlyStatusHandler.getInstance(this.myProject).ensureFilesWritable(readOnlyUsages).hasReadonlyFiles();
    }

    @NotNull
    private Set<Usage> getReadOnlyUsages() {
        THashSet result = new THashSet();
        Set<Map.Entry<Usage, UsageNode>> usages = this.myUsageNodes.entrySet();
        for (Map.Entry<Usage, UsageNode> entry : usages) {
            Usage usage = entry.getKey();
            UsageNode node = entry.getValue();
            if (node == null || node == NULL_NODE || node.isExcluded() || !usage.isReadOnly()) continue;
            result.add(usage);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(63);
        }
        return tHashSet;
    }

    @NotNull
    private Set<VirtualFile> getReadOnlyUsagesFiles() {
        Set<Usage> usages = this.getReadOnlyUsages();
        THashSet result = new THashSet();
        for (Usage usage : usages) {
            UsageInFile usageInFile;
            VirtualFile file;
            if (usage instanceof UsageInFile && (file = (usageInFile = (UsageInFile)usage).getFile()) != null && file.isValid()) {
                result.add(file);
            }
            if (!(usage instanceof UsageInFiles)) continue;
            UsageInFiles usageInFiles = (UsageInFiles)((Object)usage);
            ContainerUtil.addAll((Collection)result, (Object[])usageInFiles.getFiles());
        }
        for (UsageTarget target : this.myTargets) {
            Object[] files = target.getFiles();
            if (files == null) continue;
            ContainerUtil.addAll((Collection)result, (Object[])files);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(64);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<Usage> getExcludedUsages() {
        THashSet result = new THashSet();
        for (Map.Entry<Usage, UsageNode> entry : this.myUsageNodes.entrySet()) {
            UsageNode node = entry.getValue();
            Usage usage = entry.getKey();
            if (node == NULL_NODE || node == null || !node.isExcluded()) continue;
            result.add(usage);
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(65);
        }
        return tHashSet;
    }

    @Nullable
    private Node getSelectedNode() {
        EDT.assertIsEdt();
        TreePath leadSelectionPath = this.myTree.getLeadSelectionPath();
        if (leadSelectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)leadSelectionPath.getLastPathComponent();
        return node instanceof Node ? (Node)node : null;
    }

    private Node @Nullable [] getSelectedNodes() {
        EDT.assertIsEdt();
        TreePath[] leadSelectionPath = this.myTree.getSelectionPaths();
        if (leadSelectionPath == null || leadSelectionPath.length == 0) {
            return null;
        }
        ArrayList<Node> result = new ArrayList<Node>();
        for (TreePath comp : leadSelectionPath) {
            Object lastPathComponent = comp.getLastPathComponent();
            if (!(lastPathComponent instanceof Node)) continue;
            Node node = (Node)lastPathComponent;
            result.add(node);
        }
        return result.isEmpty() ? null : result.toArray(new Node[0]);
    }

    @Override
    @NotNull
    public Set<Usage> getSelectedUsages() {
        EDT.assertIsEdt();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            Set<Usage> set = Collections.emptySet();
            if (set == null) {
                UsageViewImpl.$$$reportNull$$$0(66);
            }
            return set;
        }
        THashSet usages = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            UsageViewImpl.collectUsages(node, (Set<? super Usage>)usages);
        }
        THashSet tHashSet = usages;
        if (tHashSet == null) {
            UsageViewImpl.$$$reportNull$$$0(67);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    public Set<Usage> getUsages() {
        Set<Usage> set = this.myUsageNodes.keySet();
        if (set == null) {
            UsageViewImpl.$$$reportNull$$$0(68);
        }
        return set;
    }

    @Override
    @NotNull
    public List<Usage> getSortedUsages() {
        ArrayList<Usage> usages = new ArrayList<Usage>(this.getUsages());
        usages.sort(USAGE_COMPARATOR);
        ArrayList<Usage> arrayList = usages;
        if (arrayList == null) {
            UsageViewImpl.$$$reportNull$$$0(69);
        }
        return arrayList;
    }

    private static void collectUsages(@NotNull DefaultMutableTreeNode node, @NotNull Set<? super Usage> usages) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(70);
        }
        if (usages == null) {
            UsageViewImpl.$$$reportNull$$$0(71);
        }
        if (node instanceof UsageNode) {
            UsageNode usageNode = (UsageNode)node;
            Usage usage = usageNode.getUsage();
            usages.add(usage);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            UsageViewImpl.collectUsages(child, usages);
        }
    }

    private static void collectAllChildNodes(@NotNull DefaultMutableTreeNode node, @NotNull Set<? super Node> nodes) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(72);
        }
        if (nodes == null) {
            UsageViewImpl.$$$reportNull$$$0(73);
        }
        if (node instanceof Node) {
            nodes.add((Node)node);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            UsageViewImpl.collectAllChildNodes(child, nodes);
        }
    }

    private UsageTarget @Nullable [] getSelectedUsageTargets() {
        EDT.assertIsEdt();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            return null;
        }
        THashSet targets = new THashSet();
        for (TreePath selectionPath : selectionPaths) {
            UsageTargetNode usageTargetNode;
            UsageTarget target;
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof UsageTargetNode) || !(target = (usageTargetNode = (UsageTargetNode)lastPathComponent).getTarget()).isValid()) continue;
            targets.add(target);
        }
        return targets.isEmpty() ? null : targets.toArray(UsageTarget.EMPTY_ARRAY);
    }

    @Nullable
    private static Navigatable getNavigatableForNode(@NotNull DefaultMutableTreeNode node, final boolean allowRequestFocus) {
        Object userObject;
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(74);
        }
        if ((userObject = node.getUserObject()) instanceof Navigatable) {
            final Navigatable navigatable = (Navigatable)userObject;
            return navigatable.canNavigate() ? new Navigatable(){

                @Override
                public void navigate(boolean requestFocus) {
                    navigatable.navigate(allowRequestFocus && requestFocus);
                }

                @Override
                public boolean canNavigate() {
                    return navigatable.canNavigate();
                }

                @Override
                public boolean canNavigateToSource() {
                    return navigatable.canNavigateToSource();
                }
            } : null;
        }
        return null;
    }

    private static Navigatable[] getNavigatablesForNodes(Node[] nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Navigatable> result = new ArrayList<Navigatable>();
        for (Node node : nodes) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof Navigatable)) continue;
            result.add((Navigatable)userObject);
        }
        return result.toArray(new Navigatable[0]);
    }

    boolean areTargetsValid() {
        return this.myModel.areTargetsValid();
    }

    private List<UsageInfo> getSelectedUsageInfos() {
        EDT.assertIsEdt();
        return (List)USAGE_INFO_LIST_KEY.getData(DataManager.getInstance().getDataContext(this.myRootPanel));
    }

    public GroupNode getRoot() {
        return this.myRoot;
    }

    public String getNodeText(@NotNull TreeNode node) {
        if (node == null) {
            UsageViewImpl.$$$reportNull$$$0(75);
        }
        return this.myUsageViewTreeCellRenderer.getPlainTextForNode(node);
    }

    public boolean isVisible(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(76);
        }
        return this.myBuilder != null && this.myBuilder.isVisible(usage);
    }

    public UsageTarget @NotNull [] getTargets() {
        if (this.myTargets == null) {
            UsageViewImpl.$$$reportNull$$$0(77);
        }
        return this.myTargets;
    }

    public void setOriginUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(78);
        }
        this.myOriginUsage = usage;
    }

    public boolean isOriginUsage(@NotNull Usage usage) {
        if (usage == null) {
            UsageViewImpl.$$$reportNull$$$0(79);
        }
        return this.myOriginUsage instanceof UsageInfo2UsageAdapter && usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getUsageInfo().equals(((UsageInfo2UsageAdapter)this.myOriginUsage).getUsageInfo());
    }

    private boolean isFilterDuplicateLines() {
        return this.myPresentation.isMergeDupLinesAvailable() && this.getUsageViewSettings().isFilterDuplicatedLine();
    }

    public Usage getNextToSelect(@NotNull Usage toDelete) {
        if (toDelete == null) {
            UsageViewImpl.$$$reportNull$$$0(80);
        }
        EDT.assertIsEdt();
        UsageNode usageNode = this.myUsageNodes.get(toDelete);
        if (usageNode == null) {
            return null;
        }
        DefaultMutableTreeNode node = this.myRootPanel.mySupport.findNextNodeAfter(this.myTree, usageNode, true);
        if (node == null) {
            node = this.myRootPanel.mySupport.findNextNodeAfter(this.myTree, usageNode, false);
        }
        return node == null ? null : (node.getUserObject() instanceof Usage ? (Usage)node.getUserObject() : null);
    }

    public Usage getNextToSelect(@NotNull Collection<? extends Usage> toDelete) {
        if (toDelete == null) {
            UsageViewImpl.$$$reportNull$$$0(81);
        }
        EDT.assertIsEdt();
        Usage toSelect = null;
        for (Usage usage : toDelete) {
            Usage next = this.getNextToSelect(usage);
            if (toDelete.contains(next)) continue;
            toSelect = next;
            break;
        }
        return toSelect;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 36: 
            case 38: 
            case 39: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 77: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 36: 
            case 38: 
            case 39: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 77: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 36: 
            case 38: 
            case 39: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFrom";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 76: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 27: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toUpdate";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCompletedInEdt";
                break;
            }
            case 45: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 46: 
            case 49: 
            case 70: 
            case 72: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rerunAction";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processRunnable";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortDescription";
                break;
            }
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDelete";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageViewSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveFilteringRules";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveGroupingRules";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toUsageViewToolbar";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingActions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoot";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "appendUsagesInBulk";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "usagesToNodes";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyUsages";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadOnlyUsagesFiles";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedUsages";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUsages";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedUsages";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 36: 
            case 38: 
            case 39: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 77: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tabSelected";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActiveGroupingRules";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toUsageViewToolbar";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFilteringActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addFilteringFromExtensionPoints";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurableTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "captureUsagesExpandState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "restoreUsageExpandState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doExpandingCollapsing";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getShowUsagesWithSettingsShortcut";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "associateProgress";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendUsage";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendUsagesInBulk";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doAppendUsage";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "reportToFUS";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeUsage";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeUsagesBulk";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "includeUsages";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "excludeUsages";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "usagesToNodes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "selectUsages";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeListener";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateBulk";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateImmediatelyNodesUpToRoot";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeValidity";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "showNode";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setRerunAction";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addButtonToLowerPane";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addPerformOperationAction";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "collectUsages";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "collectAllChildNodes";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableForNode";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setOriginUsage";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isOriginUsage";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getNextToSelect";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 28: 
            case 36: 
            case 38: 
            case 39: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 77: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface ExclusionHandlerEx<Node>
    extends ExclusionHandler<Node> {
        public void excludeNodeSilently(@NotNull Node var1);
    }

    private class MyPerformOperationRunnable
    implements Runnable {
        private final String myCannotMakeString;
        private final Runnable myProcessRunnable;
        private final String myCommandName;
        private final boolean myCheckReadOnlyStatus;

        private MyPerformOperationRunnable(@NotNull Runnable processRunnable, String commandName, String cannotMakeString, boolean checkReadOnlyStatus) {
            if (processRunnable == null) {
                MyPerformOperationRunnable.$$$reportNull$$$0(0);
            }
            if (commandName == null) {
                MyPerformOperationRunnable.$$$reportNull$$$0(1);
            }
            this.myCannotMakeString = cannotMakeString;
            this.myProcessRunnable = processRunnable;
            this.myCommandName = commandName;
            this.myCheckReadOnlyStatus = checkReadOnlyStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.myCheckReadOnlyStatus && !UsageViewImpl.this.checkReadonlyUsages()) {
                return;
            }
            PsiDocumentManager.getInstance(UsageViewImpl.this.myProject).commitAllDocuments();
            if (this.myCannotMakeString != null && UsageViewImpl.this.myChangesDetected) {
                String title = UsageViewBundle.message("changes.detected.error.title", new Object[0]);
                if (UsageViewImpl.this.canPerformReRun()) {
                    String[] options = new String[]{UsageViewBundle.message("action.description.rerun", new Object[0]), UsageViewBundle.message("usage.view.cancel.button", new Object[0])};
                    String message = this.myCannotMakeString + "\n\n" + UsageViewBundle.message("dialog.rerun.search", new Object[0]);
                    int answer = Messages.showOkCancelDialog(UsageViewImpl.this.myProject, message, title, options[0], options[1], Messages.getErrorIcon());
                    if (answer == 0) {
                        UsageViewImpl.this.refreshUsages();
                    }
                } else {
                    Messages.showMessageDialog(UsageViewImpl.this.myProject, this.myCannotMakeString, title, Messages.getErrorIcon());
                }
                return;
            }
            UsageViewImpl.this.myDisposeSmartPointersOnClose = false;
            UsageViewImpl.this.close();
            try {
                CommandProcessor.getInstance().executeCommand(UsageViewImpl.this.myProject, this.myProcessRunnable, this.myCommandName, null);
            }
            finally {
                UsageViewImpl.this.disposeSmartPointers();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processRunnable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commandName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/usages/impl/UsageViewImpl$MyPerformOperationRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class UsageState {
        private final Usage myUsage;
        private final boolean mySelected;

        private UsageState(Usage usage, boolean isSelected) {
            if (usage == null) {
                UsageState.$$$reportNull$$$0(0);
            }
            this.myUsage = usage;
            this.mySelected = isSelected;
        }

        private void restore() {
            EDT.assertIsEdt();
            UsageNode node = (UsageNode)UsageViewImpl.this.myUsageNodes.get(this.myUsage);
            if (node == NULL_NODE || node == null) {
                return;
            }
            DefaultMutableTreeNode parentGroupingNode = (DefaultMutableTreeNode)node.getParent();
            if (parentGroupingNode != null) {
                TreePath treePath = new TreePath(parentGroupingNode.getPath());
                UsageViewImpl.this.myTree.expandPath(treePath);
                if (this.mySelected) {
                    UsageViewImpl.this.myTree.addSelectionPath(treePath.pathByAddingChild(node));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/UsageViewImpl$UsageState", "<init>"));
        }
    }

    private final class ButtonPanel
    extends JPanel {
        private ButtonPanel() {
            this.setLayout(new FlowLayout(0, 6, 0));
            UsageViewImpl.this.getProject().getMessageBus().connect((Disposable)UsageViewImpl.this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                @Override
                public void enteredDumbMode() {
                    ButtonPanel.this.update();
                }

                @Override
                public void exitDumbMode() {
                    ButtonPanel.this.update();
                }
            });
        }

        private void addButtonAction(int index, @NotNull Action action) {
            if (action == null) {
                ButtonPanel.$$$reportNull$$$0(0);
            }
            JButton button = new JButton(action);
            this.add((Component)button, index);
            DialogUtil.registerMnemonic(button);
            if (this.getBorder() == null) {
                this.setBorder(IdeBorderFactory.createBorder(2));
            }
            this.update();
            Object s = action.getValue("LongDescription");
            if (s instanceof String) {
                JBLabel label = new JBLabel((String)s);
                label.setEnabled(false);
                label.setFont((Font)JBUI.Fonts.smallFont());
                this.add(JBUI.Borders.emptyLeft((int)-1).wrap((JComponent)label));
            }
            if ((s = action.getValue("ShortDescription")) instanceof String) {
                button.setToolTipText((String)s);
            }
            this.invalidate();
            if (this.getParent() != null) {
                this.getParent().validate();
            }
        }

        void update() {
            boolean globallyEnabled = !UsageViewImpl.this.isSearchInProgress() && !DumbService.isDumb(UsageViewImpl.this.myProject);
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof JButton)) continue;
                JButton button = (JButton)component;
                Action action = button.getAction();
                if (action != null) {
                    Object name;
                    if (UsageViewImpl.this.myNeedUpdateButtons) {
                        button.setEnabled(globallyEnabled && action.isEnabled());
                    }
                    if (!((name = action.getValue("Name")) instanceof String)) continue;
                    DialogUtil.setTextWithMnemonic(button, (String)name);
                    continue;
                }
                button.setEnabled(globallyEnabled);
            }
            UsageViewImpl.this.myNeedUpdateButtons = false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/usages/impl/UsageViewImpl$ButtonPanel", "addButtonAction"));
        }
    }

    private final class MyPanel
    extends JPanel
    implements TypeSafeDataProvider,
    OccurenceNavigator,
    Disposable {
        @Nullable
        private OccurenceNavigatorSupport mySupport;
        private final CopyProvider myCopyProvider;

        private MyPanel(JTree tree) {
            if (tree == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            this.mySupport = new OccurenceNavigatorSupport(tree){

                @Override
                protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (node.getChildCount() > 0) {
                        return null;
                    }
                    if (node instanceof Node && ((Node)node).isExcluded()) {
                        return null;
                    }
                    return UsageViewImpl.getNavigatableForNode(node, !UsageViewImpl.this.myPresentation.isReplaceMode());
                }

                @Override
                @NotNull
                public String getNextOccurenceActionName() {
                    String string = UsageViewBundle.message("action.next.occurrence", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                @Override
                @NotNull
                public String getPreviousOccurenceActionName() {
                    String string = UsageViewBundle.message("action.previous.occurrence", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/usages/impl/UsageViewImpl$MyPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$MyPanel$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNextOccurenceActionName";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPreviousOccurenceActionName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createDescriptorForNode";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            this.myCopyProvider = new TextCopyProvider(){

                @Override
                @Nullable
                public Collection<String> getTextLinesToCopy() {
                    Node[] selectedNodes = UsageViewImpl.this.getSelectedNodes();
                    if (selectedNodes != null && selectedNodes.length > 0) {
                        ArrayList<String> lines = new ArrayList<String>();
                        for (Node node : selectedNodes) {
                            lines.add(node.getText(UsageViewImpl.this));
                        }
                        return lines;
                    }
                    return null;
                }
            };
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.transferFocus();
            }
        }

        public void dispose() {
            this.mySupport = null;
        }

        @Override
        public boolean hasNextOccurence() {
            return this.mySupport != null && this.mySupport.hasNextOccurence();
        }

        @Override
        public boolean hasPreviousOccurence() {
            return this.mySupport != null && this.mySupport.hasPreviousOccurence();
        }

        @Override
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.mySupport != null ? this.mySupport.goNextOccurence() : null;
        }

        @Override
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.mySupport != null ? this.mySupport.goPreviousOccurence() : null;
        }

        @Override
        @NotNull
        public String getNextOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getNextOccurenceActionName() : "";
        }

        @Override
        @NotNull
        public String getPreviousOccurenceActionName() {
            return this.mySupport != null ? this.mySupport.getPreviousOccurenceActionName() : "";
        }

        @Override
        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(2);
            }
            if (key == CommonDataKeys.PROJECT) {
                sink.put(CommonDataKeys.PROJECT, UsageViewImpl.this.myProject);
            } else if (key == UsageView.USAGE_VIEW_KEY) {
                sink.put(UsageView.USAGE_VIEW_KEY, UsageViewImpl.this);
            } else if (key == ExclusionHandler.EXCLUSION_HANDLER) {
                sink.put(ExclusionHandler.EXCLUSION_HANDLER, UsageViewImpl.this.myExclusionHandler);
            } else if (key == CommonDataKeys.NAVIGATABLE_ARRAY) {
                Node[] nodes = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedNodes() : null;
                sink.put(CommonDataKeys.NAVIGATABLE_ARRAY, UsageViewImpl.getNavigatablesForNodes(nodes));
            } else if (key == PlatformDataKeys.EXPORTER_TO_TEXT_FILE) {
                sink.put(PlatformDataKeys.EXPORTER_TO_TEXT_FILE, UsageViewImpl.this.myTextFileExporter);
            } else if (key == UsageView.USAGES_KEY) {
                Set<Usage> selectedUsages = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedUsages() : null;
                sink.put(UsageView.USAGES_KEY, selectedUsages == null ? null : selectedUsages.toArray(Usage.EMPTY_ARRAY));
            } else if (key == UsageView.USAGE_TARGETS_KEY) {
                UsageTarget[] targets = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedUsageTargets() : null;
                sink.put(UsageView.USAGE_TARGETS_KEY, targets);
            } else if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
                Set<Usage> usages = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedUsages() : null;
                Usage[] ua = usages == null ? null : usages.toArray(Usage.EMPTY_ARRAY);
                UsageTarget[] usageTargets = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedUsageTargets() : null;
                VirtualFile[] data = UsageDataUtil.provideVirtualFileArray(ua, usageTargets);
                sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, data);
            } else if (key == PlatformDataKeys.HELP_ID) {
                sink.put(PlatformDataKeys.HELP_ID, UsageViewImpl.HELP_ID);
            } else if (key == PlatformDataKeys.COPY_PROVIDER) {
                sink.put(PlatformDataKeys.COPY_PROVIDER, this.myCopyProvider);
            } else if (key == LangDataKeys.PSI_ELEMENT_ARRAY) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    sink.put(LangDataKeys.PSI_ELEMENT_ARRAY, (PsiElement[])UsageViewImpl.this.getSelectedUsages().stream().filter(u -> u instanceof PsiElementUsage).map(u -> ((PsiElementUsage)u).getElement()).filter(Objects::nonNull).toArray(arg_0 -> PsiElement.ARRAY_FACTORY.create(arg_0)));
                }
            } else {
                Node node;
                Node node2 = node = ApplicationManager.getApplication().isDispatchThread() ? UsageViewImpl.this.getSelectedNode() : null;
                if (node != null) {
                    DataProvider dataProvider;
                    Object data;
                    Object userObject = node.getUserObject();
                    if (userObject instanceof TypeSafeDataProvider) {
                        ((TypeSafeDataProvider)userObject).calcData(key, sink);
                    } else if (userObject instanceof DataProvider && (data = (dataProvider = (DataProvider)userObject).getData(key.getName())) != null) {
                        sink.put(key, data);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$MyPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowSettings
    extends AnAction {
        private ShowSettings() {
            KeyboardShortcut shortcut;
            super(UsageViewBundle.message("action.text.usage.view.settings", new Object[0]), null, AllIcons.General.GearPlain);
            ConfigurableUsageTarget configurableUsageTarget = UsageViewImpl.getConfigurableTarget(UsageViewImpl.this.myTargets);
            String description = null;
            try {
                description = configurableUsageTarget == null ? null : UsageViewBundle.message("action.ShowSettings.show.settings.for.description", configurableUsageTarget.getLongDescriptiveName());
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (description == null) {
                description = UsageViewBundle.message("action.ShowSettings.show.find.usages.settings.dialog.description", new Object[0]);
            }
            this.getTemplatePresentation().setDescription(description);
            KeyboardShortcut keyboardShortcut = shortcut = configurableUsageTarget == null ? UsageViewImpl.getShowUsagesWithSettingsShortcut() : configurableUsageTarget.getShortcut();
            if (shortcut != null) {
                this.registerCustomShortcutSet(new CustomShortcutSet(shortcut), UsageViewImpl.this.getComponent());
            }
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettings.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(CommonDataKeys.EDITOR) == null);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettings.$$$reportNull$$$0(1);
            }
            FindManager.getInstance(UsageViewImpl.this.getProject()).showSettingsAndFindUsages(UsageViewImpl.this.myTargets);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$ShowSettings";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergeDupLines
    extends RuleAction {
        private MergeDupLines() {
            super(UsageViewBundle.message("action.merge.same.line", new Object[0]), AllIcons.Toolbar.Filterdups);
            this.setShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(70, 128)));
        }

        @Override
        protected boolean getOptionValue(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeDupLines.$$$reportNull$$$0(0);
            }
            return this.getUsageViewSettings(e).isFilterDuplicatedLine();
        }

        @Override
        protected void setOptionValue(@NotNull AnActionEvent e, boolean value) {
            if (e == null) {
                MergeDupLines.$$$reportNull$$$0(1);
            }
            this.getUsageViewSettings(e).setFilterDuplicatedLine(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/usages/impl/UsageViewImpl$MergeDupLines";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOptionValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOptionValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

