/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ComponentStoreWithExtraComponents;
import com.intellij.configurationStore.DefaultProjectElementNormalizerKt;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.ProjectIdManager;
import com.intellij.configurationStore.ProjectIdState;
import com.intellij.configurationStore.ProjectStoreBase;
import com.intellij.configurationStore.ProjectStoreBaseKt;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.Ksuid;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ#\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$J\b\u0010%\u001a\u0004\u0018\u00010\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020&H\u0016J\u0006\u0010)\u001a\u00020\u0007J\n\u0010*\u001a\u0004\u0018\u00010&H\u0016J\u0006\u0010+\u001a\u00020&J\n\u0010,\u001a\u0004\u0018\u00010&H\u0016J\u0006\u0010-\u001a\u00020\u0014J2\u0010.\u001a\b\u0012\u0004\u0012\u0002000/\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0014J\u0006\u00108\u001a\u00020&J\u0006\u00109\u001a\u00020\tJ\u0010\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u0004H\u0002J\u000e\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\tJ\"\u0010A\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\t2\b\u0010C\u001a\u0004\u0018\u00010\u0004H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006D"}, d2={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreWithExtraComponents;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dirOrFile", "Ljava/nio/file/Path;", "isDirectoryBased", "", "()Z", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "getScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "setScheme", "(Lcom/intellij/openapi/components/StorageScheme;)V", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "doSave", "result", "Lcom/intellij/configurationStore/SaveResult;", "forceSavingAllSettings", "doSave$intellij_platform_configurationStore_impl", "(Lcom/intellij/configurationStore/SaveResult;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDirectoryStorePath", "", "ignoreProjectStorageScheme", "getDirectoryStorePathOrBase", "getProjectBasePath", "getProjectConfigDir", "getProjectFilePath", "getProjectWorkspaceId", "getStorageScheme", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getWorkspaceFilePath", "isOptimiseTestLoadSpeed", "isProjectFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadProjectFromTemplate", "defaultProject", "setOptimiseTestLoadSpeed", "value", "setPath", "isRefreshVfsNeeded", "template", "intellij.platform.configurationStore.impl"})
public abstract class ProjectStoreBase
extends ComponentStoreWithExtraComponents
implements IProjectStore {
    private Path dirOrFile;
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final Project project;

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    public final boolean isOptimiseTestLoadSpeed() {
        return this.loadPolicy != StateLoadPolicy.LOAD;
    }

    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    protected final boolean isDirectoryBased() {
        return this.scheme == StorageScheme.DIRECTORY_BASED;
    }

    public final void setOptimiseTestLoadSpeed(boolean value2) {
        this.loadPolicy = value2 ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @NotNull
    public final String getProjectFilePath() {
        return this.getStorageManager().expandMacro("$PROJECT_FILE$");
    }

    @Nullable
    public String getProjectConfigDir() {
        return this.isDirectoryBased() ? this.getStorageManager().expandMacro("$PROJECT_CONFIG_DIR$") : null;
    }

    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    private final void loadProjectFromTemplate(Project defaultProject) {
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)defaultProject));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element == null) {
            return;
        }
        Element element2 = element;
        Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
        boolean $i$f$runAndLogException = false;
        try {
            boolean bl = false;
            if (this.isDirectoryBased()) {
                Path path = Paths.get(this.getStorageManager().expandMacro("$PROJECT_CONFIG_DIR$"), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(storageManager\u2026acro(PROJECT_CONFIG_DIR))");
                DefaultProjectElementNormalizerKt.normalizeDefaultProjectElement(defaultProject, element2, path);
            } else {
                DefaultProjectElementNormalizerKt.moveComponentConfiguration(defaultProject, element2, (Function1<? super String, String>)((Function1)loadProjectFromTemplate.1.1.INSTANCE), (Function1<? super String, ? extends Path>)((Function1)new Function1<String, Path>(this, defaultProject, element2){
                    final /* synthetic */ ProjectStoreBase this$0;
                    final /* synthetic */ Project $defaultProject$inlined;
                    final /* synthetic */ Element $element$inlined;
                    {
                        this.this$0 = projectStoreBase;
                        this.$defaultProject$inlined = project;
                        this.$element$inlined = element;
                        super(1);
                    }

                    @NotNull
                    public final Path invoke(@NotNull String it) {
                        Path path;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if (Intrinsics.areEqual((Object)it, (Object)"workspace.xml")) {
                            Path path2 = Paths.get(this.this$0.getWorkspaceFilePath(), new String[0]);
                            path = path2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(workspaceFilePath)");
                        } else {
                            Path path3 = Paths.get(this.this$0.getProjectFilePath(), new String[0]);
                            path = path3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(projectFilePath)");
                        }
                        return path;
                    }
                }));
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (CancellationException e$iv) {
            throw (Throwable)e$iv;
        }
        catch (Throwable e$iv) {
            $this$runAndLogException$iv.error(e$iv);
        }
    }

    @NotNull
    public final Path getProjectBasePath() {
        Path path = this.dirOrFile;
        if (path == null) {
            throw (Throwable)new IllegalStateException("setPath was not yet called");
        }
        Path path2 = path;
        if (this.isDirectoryBased()) {
            Path path3;
            boolean useParent;
            Object object;
            boolean bl = Registry.is((String)"store.basedir.parent.detection", (boolean)true) && ((object = path2.getFileName()) != null && (object = object.toString()) != null ? StringsKt.startsWith$default((String)object, (String)".idea.", (boolean)false, (int)2, null) : false) ? true : (useParent = false);
            if (useParent) {
                Path path4 = path2.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"path.parent");
                Path path5 = path4.getParent();
                path3 = path5;
                Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"path.parent.parent");
            } else {
                path3 = path2;
            }
            return path3;
        }
        Path path6 = path2.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path6, (String)"path.parent");
        return path6;
    }

    @Nullable
    public String getProjectWorkspaceId() {
        return ((ProjectIdState)ProjectIdManager.Companion.getInstance(this.project).getState()).getId();
    }

    public void setPath(@NotNull Path file, boolean isRefreshVfsNeeded, @Nullable Project template) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.dirOrFile = file;
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        boolean isUnitTestMode = application.isUnitTestMode();
        String filePath = PathKt.getSystemIndependentPath((Path)file);
        if (StringsKt.endsWith$default((String)filePath, (String)".ipr", (boolean)false, (int)2, null)) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro("$PROJECT_FILE$", filePath);
            String workspacePath = ProjectStoreBaseKt.access$composeFileBasedProjectWorkSpacePath(filePath);
            storageManager2.addMacro("$WORKSPACE_FILE$", workspacePath);
            if (isRefreshVfsNeeded) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{fs.refreshAndFindFileByPath(filePath), fs.refreshAndFindFileByPath(workspacePath)});
            }
            if (isUnitTestMode) {
                this.setOptimiseTestLoadSpeed(!PathKt.exists((Path)file));
                storageManager2.addMacro("$PRODUCT_WORKSPACE_FILE$", workspacePath);
            }
        } else {
            this.scheme = StorageScheme.DIRECTORY_BASED;
            String configDir = filePath + "/.idea";
            storageManager2.addMacro("$PROJECT_CONFIG_DIR$", configDir);
            storageManager2.addMacro("$PROJECT_FILE$", configDir + "/misc.xml");
            storageManager2.addMacro("$WORKSPACE_FILE$", configDir + "/workspace.xml");
            if (isUnitTestMode) {
                this.setOptimiseTestLoadSpeed(!PathKt.exists((Path)file));
                storageManager2.addMacro("$PRODUCT_WORKSPACE_FILE$", configDir + "/product-workspace.xml");
            }
            if (isRefreshVfsNeeded) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{fs.refreshAndFindFileByPath(configDir)});
            }
        }
        if (template != null) {
            this.loadProjectFromTemplate(template);
        }
        String cacheFileName = ProjectUtil.getProjectCacheFileName$default((Project)this.project, (boolean)false, null, (String)".xml", (int)3, null);
        Path path = PathManagerEx.getAppSystemDir().resolve("workspace").resolve(cacheFileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"appSystemDir.resolve(\"wo\u2026\").resolve(cacheFileName)");
        storageManager2.addMacro("$CACHE_FILE$", PathKt.getSystemIndependentPath((Path)path));
        if (isUnitTestMode) {
            return;
        }
        String productSpecificWorkspaceParentDir = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath()) + "/workspace";
        ProjectIdManager projectIdManager = ProjectIdManager.Companion.getInstance(this.project);
        String projectId = ((ProjectIdState)projectIdManager.getState()).getId();
        if (projectId == null) {
            projectId = Ksuid.generate();
            ((ProjectIdState)projectIdManager.getState()).setId(projectId);
            try {
                Path oldFile;
                Path path2 = oldFile = Paths.get(productSpecificWorkspaceParentDir + '/' + cacheFileName, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"oldFile");
                if (PathKt.exists((Path)path2)) {
                    Path path3 = Paths.get(productSpecificWorkspaceParentDir + '/' + projectId + ".xml", new String[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(\"$productSpeci\u2026arentDir/$projectId.xml\")");
                    PathKt.move((Path)oldFile, (Path)path3);
                }
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
            }
        }
        storageManager2.addMacro("$PRODUCT_WORKSPACE_FILE$", productSpecificWorkspaceParentDir + '/' + projectId + ".xml");
    }

    @Override
    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        List result;
        Ref.ObjectRef storages;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Ref.ObjectRef objectRef = storages = stateSpec.storages();
        boolean bl = false;
        if (((Storage[])objectRef).length == 0) {
            return CollectionsKt.listOf((Object)ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        if (this.isDirectoryBased()) {
            objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            if (((Ref.ObjectRef)storages).length == 2) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode() && ProjectStoreBaseKt.access$isSpecialStorage((Storage)ArraysKt.first((Object[])storages)) && Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storages[1]), (Object)"$WORKSPACE_FILE$")) {
                    return CollectionsKt.listOf((Object)ArraysKt.first((Object[])storages));
                }
            }
            for (Ref.ObjectRef storage2 : storages) {
                if (!(Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage2), (Object)"$PROJECT_FILE$") ^ true)) continue;
                if ((List)((Ref.ObjectRef)result).element == null) {
                    ((Ref.ObjectRef)result).element = (List)new SmartList();
                }
                ((List)((Ref.ObjectRef)result).element).add(storage2);
            }
            if (UtilKt.isNullOrEmpty((Collection)((List)((Ref.ObjectRef)result).element))) {
                return CollectionsKt.listOf((Object)ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
            }
            List list = (List)((Ref.ObjectRef)result).element;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
            if (this.isDirectoryBased()) {
                Object v3;
                int n;
                Object storage2;
                block18: {
                    Stream stream = StreamProviderFactory.Companion.getEP_NAME().extensions((AreaInstance)this.project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"StreamProviderFactory.EP_NAME.extensions(project)");
                    storage2 = SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<StreamProviderFactory, List<? extends Storage>>(this, component, stateSpec, (Ref.ObjectRef)result, operation){
                        final /* synthetic */ ProjectStoreBase this$0;
                        final /* synthetic */ PersistentStateComponent $component;
                        final /* synthetic */ State $stateSpec;
                        final /* synthetic */ Ref.ObjectRef $result;
                        final /* synthetic */ StateStorageOperation $operation;

                        @Nullable
                        public final List<Storage> invoke(StreamProviderFactory it) {
                            List list;
                            Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
                            boolean $i$f$runAndLogException = false;
                            try {
                                boolean bl = false;
                                StateStorageManager stateStorageManager = this.this$0.getStorageManager();
                                List list2 = (List)this.$result.element;
                                if (list2 == null) {
                                    Intrinsics.throwNpe();
                                }
                                list = it.customizeStorageSpecs(this.$component, stateStorageManager, this.$stateSpec, list2, this.$operation);
                            }
                            catch (ProcessCanceledException e$iv) {
                                throw (Throwable)e$iv;
                            }
                            catch (CancellationException e$iv) {
                                throw (Throwable)e$iv;
                            }
                            catch (Throwable e$iv) {
                                $this$runAndLogException$iv.error(e$iv);
                                list = null;
                            }
                            return list;
                        }
                        {
                            this.this$0 = projectStoreBase;
                            this.$component = persistentStateComponent;
                            this.$stateSpec = state;
                            this.$result = objectRef;
                            this.$operation = stateStorageOperation;
                            super(1);
                        }
                    }));
                    n = 0;
                    Ref.ObjectRef objectRef2 = storage2;
                    int n2 = 0;
                    for (Object e : objectRef2) {
                        List it = (List)e;
                        boolean bl2 = false;
                        if (!(it != null)) continue;
                        v3 = e;
                        break block18;
                    }
                    v3 = null;
                }
                List list2 = v3;
                if (list2 != null) {
                    storage2 = list2;
                    n = 0;
                    boolean bl3 = false;
                    Object it = storage2;
                    boolean bl4 = false;
                    return it;
                }
            }
            if (!ProjectStoreBaseKt.access$isSpecialStorage((Storage)CollectionsKt.first((List)((List)((Ref.ObjectRef)result).element)))) {
                ((List)((Ref.ObjectRef)result).element).add(ProjectStoreBaseKt.access$getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION$p());
            }
            return (List)((Ref.ObjectRef)result).element;
        }
        result = null;
        boolean hasOnlyDeprecatedStorages = true;
        for (Ref.ObjectRef storage3 : storages) {
            if (!Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage3), (Object)"$PROJECT_FILE$") && !Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)storage3), (Object)"$WORKSPACE_FILE$") && !ProjectStoreBaseKt.access$isSpecialStorage((Storage)storage3)) continue;
            if (result == null) {
                result = (List)new SmartList();
            }
            result.add(storage3);
            if (storage3.deprecated()) continue;
            hasOnlyDeprecatedStorages = false;
        }
        if (UtilKt.isNullOrEmpty((Collection)result)) {
            return CollectionsKt.listOf((Object)ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        if (hasOnlyDeprecatedStorages) {
            List list = result;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(ProjectStoreBaseKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        List list = result;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        CollectionsKt.sortWith((List)list, ComponentStoreImplKt.getDeprecatedComparator());
        return result;
    }

    public boolean isProjectFile(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!file.isInLocalFileSystem() || !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
            return false;
        }
        String string = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        String filePath = string;
        if (!this.isDirectoryBased()) {
            return Intrinsics.areEqual((Object)filePath, (Object)this.getProjectFilePath()) || Intrinsics.areEqual((Object)filePath, (Object)this.getWorkspaceFilePath());
        }
        return FileUtil.isAncestor((String)PathUtil.getParentPath((String)this.getProjectFilePath()), (String)filePath, (boolean)false);
    }

    @Nullable
    public String getDirectoryStorePath(boolean ignoreProjectStorageScheme) {
        return !ignoreProjectStorageScheme && !this.isDirectoryBased() ? null : StringKt.nullize$default((String)PathUtil.getParentPath((String)this.getProjectFilePath()), (boolean)false, (int)1, null);
    }

    @Nullable
    public final Path getDirectoryStorePath() {
        Path path;
        if (this.isDirectoryBased()) {
            Path path2 = this.dirOrFile;
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            path = path2.resolve(".idea");
        } else {
            path = null;
        }
        return path;
    }

    @NotNull
    public String getDirectoryStorePathOrBase() {
        String string = PathUtil.getParentPath((String)this.getProjectFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtil.getParentPath(projectFilePath)");
        return string;
    }

    @Override
    @Nullable
    public Object doSave$intellij_platform_configurationStore_impl(@NotNull SaveResult saveResult, boolean bl, @NotNull Continuation<? super Unit> $completion) {
        return ProjectStoreBase.doSave$intellij_platform_configurationStore_impl$suspendImpl(this, saveResult, bl, $completion);
    }

    static /* synthetic */ Object doSave$intellij_platform_configurationStore_impl$suspendImpl(ProjectStoreBase this_, SaveResult result, boolean forceSavingAllSettings, Continuation $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

