/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.MasterKey;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.awt.Container;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u001a\u0010!\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0004J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010'\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014JM\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00122\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2#\u0010,\u001a\u001f\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u00120-H\u0014J\u0006\u00100\u001a\u00020\u001bJ\u000e\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u0003J\u0006\u00103\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "", "file", "Ljava/nio/file/Path;", "masterKeyFile", "masterKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/credentialStore/EncryptionSpec;Lkotlin/Lazy;)V", "masterKeyFileStorage", "Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;", "askAndSetMasterKey", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "topNote", "", "checkIsEmpty", "", "field", "Ljavax/swing/JPasswordField;", "errors", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "clear", "", "createMasterKey", "Lcom/intellij/credentialStore/keePass/MasterKey;", "value", "", "isAutoGenerated", "doImportOrUseExisting", "doSetNewMasterPassword", "current", "new", "import", "fromFile", "requestCurrentAndNewKeys", "contextComponent", "Ljava/awt/Component;", "requestMasterPassword", "title", "ok", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "saveMasterKeyToApplyNewEncryptionSpec", "setCustomMasterPasswordIfNeeded", "defaultDbFile", "useExisting", "intellij.platform.credentialStore"})
public class KeePassFileManager {
    private final MasterKeyFileStorage masterKeyFileStorage;
    private final Path file;
    private final EncryptionSpec masterKeyEncryptionSpec;
    private final Lazy<SecureRandom> secureRandom;

    public final void clear() {
        block4: {
            if (!PathKt.exists((Path)this.file)) {
                return;
            }
            try {
                byte[] masterPassword = this.masterKeyFileStorage.load();
                if (masterPassword != null) {
                    KeePassDatabase db = KdbxKt.loadKdbx(this.file, KdbxPassword.Companion.createAndClear(masterPassword));
                    KeePassCredentialStore store = new KeePassCredentialStore(this.file, this.masterKeyFileStorage, db);
                    store.clear();
                    store.save(this.masterKeyEncryptionSpec);
                    return;
                }
            }
            catch (Exception e) {
                if (e instanceof IncorrectMasterPasswordException) break block4;
                Application application = ApplicationManager.getApplication();
                if (application == null) break block4;
                if (application.isUnitTestMode()) break block4;
                CredentialStoreKt.getLOG().error((Throwable)e);
            }
        }
        PathKt.delete$default((Path)this.file, (boolean)false, (int)1, null);
    }

    public final void import(@NotNull Path fromFile, @Nullable AnActionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)fromFile, (String)"fromFile");
        if (Intrinsics.areEqual((Object)this.file, (Object)fromFile)) {
            return;
        }
        try {
            this.doImportOrUseExisting(fromFile, event);
        }
        catch (IncorrectMasterPasswordException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().warn((Throwable)e);
            AnActionEvent anActionEvent = event;
            Component component = anActionEvent != null ? (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT) : null;
            if (component == null) {
                Intrinsics.throwNpe();
            }
            Messages.showMessageDialog((Component)component, (String)CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.message", new Object[0]), (String)CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.title.cannot.import", new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    public final void useExisting() throws IncorrectMasterPasswordException {
        if (PathKt.exists((Path)this.file)) {
            if (!this.doImportOrUseExisting(this.file, null)) {
                throw (Throwable)new IncorrectMasterPasswordException(false, 1, null);
            }
        } else {
            KeePassCredentialStoreKt.saveDatabase(this.file, new KeePassDatabase(null, 1, null), KeePassCredentialStoreKt.generateRandomMasterKey(this.masterKeyEncryptionSpec, (SecureRandom)this.secureRandom.getValue()), this.masterKeyFileStorage, (SecureRandom)this.secureRandom.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doImportOrUseExisting(Path file, AnActionEvent event) {
        void masterPassword;
        AnActionEvent anActionEvent = event;
        Component contextComponent = anActionEvent != null ? (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT) : null;
        Path possibleMasterKeyFile = file.getParent().resolve("c.pwd");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Path path = possibleMasterKeyFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"possibleMasterKeyFile");
        objectRef.element = new MasterKeyFileStorage(path).load();
        if ((byte[])masterPassword.element != null) {
            try {
                KdbxKt.loadKdbx(file, new KdbxPassword((byte[])masterPassword.element));
            }
            catch (IncorrectMasterPasswordException e) {
                CredentialStoreKt.getLOG().warn("On import \"" + file + "\" found existing master key file \"" + possibleMasterKeyFile + "\" but key is not correct");
                masterPassword.element = null;
            }
        }
        if ((byte[])masterPassword.element == null && !KeePassFileManager.requestMasterPassword$default(this, CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.request.master.title", new Object[0]), null, contextComponent, (Function1)new Function1<byte[], String>(file, (Ref.ObjectRef)masterPassword){
            final /* synthetic */ Path $file;
            final /* synthetic */ Ref.ObjectRef $masterPassword;

            @Nullable
            public final String invoke(@NotNull byte[] it) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                try {
                    KdbxKt.loadKdbx(this.$file, new KdbxPassword(it));
                    this.$masterPassword.element = it;
                    string = null;
                }
                catch (IncorrectMasterPasswordException e) {
                    string = "Master password not correct.";
                }
                return string;
            }
            {
                this.$file = path;
                this.$masterPassword = objectRef;
                super(1);
            }
        }, 2, null)) {
            return false;
        }
        if (file != this.file) {
            Files.copy(file, this.file, StandardCopyOption.REPLACE_EXISTING);
        }
        byte[] byArray = (byte[])masterPassword.element;
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        this.masterKeyFileStorage.save(KeePassFileManager.createMasterKey$default(this, byArray, false, 2, null));
        return true;
    }

    public final boolean askAndSetMasterKey(@Nullable AnActionEvent event, @Nullable String topNote) {
        KeePassDatabase keePassDatabase;
        AnActionEvent anActionEvent = event;
        Component contextComponent = anActionEvent != null ? (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT) : null;
        try {
            KeePassDatabase keePassDatabase2;
            if (PathKt.exists((Path)this.file)) {
                byte[] byArray = this.masterKeyFileStorage.load();
                if (byArray == null) {
                    throw (Throwable)new IncorrectMasterPasswordException(true);
                }
                keePassDatabase2 = KdbxKt.loadKdbx(this.file, new KdbxPassword(byArray));
            } else {
                keePassDatabase2 = new KeePassDatabase(null, 1, null);
            }
            keePassDatabase = keePassDatabase2;
        }
        catch (IncorrectMasterPasswordException e) {
            return this.requestCurrentAndNewKeys(contextComponent);
        }
        KeePassDatabase db = keePassDatabase;
        return this.requestMasterPassword(CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.title.set.master.password", new Object[0]), topNote, contextComponent, (Function1<? super byte[], String>)new Function1(this, db){
            final /* synthetic */ KeePassFileManager this$0;
            final /* synthetic */ KeePassDatabase $db;

            @Nullable
            public final Void invoke(@NotNull byte[] it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                KeePassCredentialStoreKt.saveDatabase(KeePassFileManager.access$getFile$p(this.this$0), this.$db, KeePassFileManager.createMasterKey$default(this.this$0, it, false, 2, null), KeePassFileManager.access$getMasterKeyFileStorage$p(this.this$0), (SecureRandom)KeePassFileManager.access$getSecureRandom$p(this.this$0).getValue());
                return null;
            }
            {
                this.this$0 = keePassFileManager;
                this.$db = keePassDatabase;
                super(1);
            }
        });
    }

    public static /* synthetic */ boolean askAndSetMasterKey$default(KeePassFileManager keePassFileManager, AnActionEvent anActionEvent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: askAndSetMasterKey");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return keePassFileManager.askAndSetMasterKey(anActionEvent, string);
    }

    protected boolean requestCurrentAndNewKeys(@Nullable Component contextComponent) {
        LayoutBuilder builder$iv;
        JPasswordField currentPasswordField = new JPasswordField();
        JPasswordField newPasswordField = new JPasswordField();
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)CredentialStoreBundle.INSTANCE.message("kee.pass.row.current.password", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(currentPasswordField, newPasswordField){
            final /* synthetic */ JPasswordField $currentPasswordField$inlined;
            final /* synthetic */ JPasswordField $newPasswordField$inlined;
            {
                this.$currentPasswordField$inlined = jPasswordField;
                this.$newPasswordField$inlined = jPasswordField2;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)$this$row, (JComponent)this.$currentPasswordField$inlined, (CCFlags[])new CCFlags[0], null, null, (int)6, null).focused();
            }
        }), (int)2, null);
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)CredentialStoreBundle.INSTANCE.message("kee.pass.row.new.password", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(currentPasswordField, newPasswordField){
            final /* synthetic */ JPasswordField $currentPasswordField$inlined;
            final /* synthetic */ JPasswordField $newPasswordField$inlined;
            {
                this.$currentPasswordField$inlined = jPasswordField;
                this.$newPasswordField$inlined = jPasswordField2;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)$this$row, (JComponent)this.$newPasswordField$inlined, (CCFlags[])new CCFlags[0], null, null, (int)6, null);
            }
        }), (int)2, null);
        $this$panel.commentRow(CredentialStoreBundle.INSTANCE.message("kee.pass.row.comment", new Object[0]));
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        DialogPanel panel2 = panel$iv;
        return ComponentsKt.dialog$default((String)CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.default.title", new Object[0]), (JComponent)((JComponent)panel2), (boolean)false, null, (boolean)false, null, (Component)contextComponent, null, null, null, (Function0)((Function0)new Function0<SmartList<ValidationInfo>>(this, currentPasswordField, newPasswordField){
            final /* synthetic */ KeePassFileManager this$0;
            final /* synthetic */ JPasswordField $currentPasswordField;
            final /* synthetic */ JPasswordField $newPasswordField;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SmartList<ValidationInfo> invoke() {
                void var1_1;
                block7: {
                    SmartList errors = new SmartList();
                    char[] current = KeePassFileManager.access$checkIsEmpty(this.this$0, this.$currentPasswordField, (List)errors);
                    char[] cArray = KeePassFileManager.access$checkIsEmpty(this.this$0, this.$newPasswordField, (List)errors);
                    if (errors.isEmpty()) {
                        try {
                            if (current == null) {
                                Intrinsics.throwNpe();
                            }
                            if (cArray == null) {
                                Intrinsics.throwNpe();
                            }
                            if (this.this$0.doSetNewMasterPassword(current, cArray)) {
                                return errors;
                            }
                            break block7;
                        }
                        catch (IncorrectMasterPasswordException e) {
                            errors.add((Object)new ValidationInfo(CredentialStoreBundle.INSTANCE.message("kee.pass.validation.info.current.password.incorrect", new Object[0]), (JComponent)this.$currentPasswordField));
                            if (cArray == null) break block7;
                            ArraysKt.fill$default((char[])cArray, (char)((char)0), (int)0, (int)0, (int)6, null);
                            break block7;
                        }
                    }
                    if (current != null) {
                        ArraysKt.fill$default((char[])current, (char)((char)0), (int)0, (int)0, (int)6, null);
                    }
                    if (cArray == null) break block7;
                    ArraysKt.fill$default((char[])cArray, (char)((char)0), (int)0, (int)0, (int)6, null);
                }
                return var1_1;
            }
            {
                this.this$0 = keePassFileManager;
                this.$currentPasswordField = jPasswordField;
                this.$newPasswordField = jPasswordField2;
                super(0);
            }
        }), (int)956, null).showAndGet();
    }

    protected final boolean doSetNewMasterPassword(@NotNull char[] current, @NotNull char[] cArray) {
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        Intrinsics.checkParameterIsNotNull((Object)cArray, (String)"new");
        KeePassDatabase db = KdbxKt.loadKdbx(this.file, KdbxPassword.Companion.createAndClear(EncryptionSupportKt.toByteArrayAndClear(current)));
        KeePassCredentialStoreKt.saveDatabase(this.file, db, this.createMasterKey(cArray), this.masterKeyFileStorage, (SecureRandom)this.secureRandom.getValue());
        return false;
    }

    private final MasterKey createMasterKey(char[] value) {
        return KeePassFileManager.createMasterKey$default(this, EncryptionSupportKt.toByteArrayAndClear(value), false, 2, null);
    }

    private final MasterKey createMasterKey(byte[] value, boolean isAutoGenerated) {
        return new MasterKey(value, isAutoGenerated, this.masterKeyEncryptionSpec);
    }

    static /* synthetic */ MasterKey createMasterKey$default(KeePassFileManager keePassFileManager, byte[] byArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createMasterKey");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return keePassFileManager.createMasterKey(byArray, bl);
    }

    private final char[] checkIsEmpty(JPasswordField field, List<ValidationInfo> errors) {
        char[] chars = CredentialPromptDialog.getTrimmedChars((JPasswordField)field);
        if (chars == null) {
            errors.add(new ValidationInfo(CredentialStoreBundle.INSTANCE.message("kee.pass.validation.info.current.password.incorrect.current.empty", new Object[0]), (JComponent)field));
        }
        return chars;
    }

    protected boolean requestMasterPassword(@NotNull String title, @Nullable String topNote, @Nullable Component contextComponent, @NotNull Function1<? super byte[], String> ok) {
        LayoutBuilder builder$iv;
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull(ok, (String)"ok");
        JPasswordField passwordField = new JPasswordField();
        LCFlags[] constraints$iv = new LCFlags[]{};
        String title$iv = null;
        boolean $i$f$panel = false;
        LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
        boolean bl = false;
        String string = topNote;
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            RowBuilder.DefaultImpls.noteRow$default((RowBuilder)$this$panel, (String)it, null, (int)2, null);
        }
        RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)CredentialStoreBundle.INSTANCE.message("kee.pass.row.master.password", new Object[0]), (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(topNote, passwordField){
            final /* synthetic */ String $topNote$inlined;
            final /* synthetic */ JPasswordField $passwordField$inlined;
            {
                this.$topNote$inlined = string;
                this.$passwordField$inlined = jPasswordField;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                Cell.invoke$default((Cell)$this$row, (JComponent)this.$passwordField$inlined, (CCFlags[])new CCFlags[0], null, null, (int)6, null).focused();
            }
        }), (int)2, null);
        DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
        builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
        LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
        DialogPanel panel2 = panel$iv;
        return ComponentsKt.dialog$default((String)title, (JComponent)((JComponent)panel2), (boolean)false, null, (boolean)false, null, (Component)contextComponent, null, null, null, (Function0)((Function0)new Function0<SmartList<ValidationInfo>>(this, passwordField, ok){
            final /* synthetic */ KeePassFileManager this$0;
            final /* synthetic */ JPasswordField $passwordField;
            final /* synthetic */ Function1 $ok;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SmartList<ValidationInfo> invoke() {
                void var1_1;
                SmartList errors = new SmartList();
                char[] value = KeePassFileManager.access$checkIsEmpty(this.this$0, this.$passwordField, (List)errors);
                if (errors.isEmpty()) {
                    if (value == null) {
                        Intrinsics.throwNpe();
                    }
                    byte[] result = EncryptionSupportKt.toByteArrayAndClear(value);
                    String string = (String)this.$ok.invoke((Object)result);
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        errors.add((Object)new ValidationInfo(it, (JComponent)this.$passwordField));
                    }
                    if (!errors.isEmpty()) {
                        ArraysKt.fill$default((byte[])result, (byte)0, (int)0, (int)0, (int)6, null);
                    }
                }
                return var1_1;
            }
            {
                this.this$0 = keePassFileManager;
                this.$passwordField = jPasswordField;
                this.$ok = function1;
                super(0);
            }
        }), (int)956, null).showAndGet();
    }

    public static /* synthetic */ boolean requestMasterPassword$default(KeePassFileManager keePassFileManager, String string, String string2, Component component, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestMasterPassword");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            component = null;
        }
        return keePassFileManager.requestMasterPassword(string, string2, component, (Function1<? super byte[], String>)function1);
    }

    public final void saveMasterKeyToApplyNewEncryptionSpec() {
        byte[] byArray = this.masterKeyFileStorage.load();
        if (byArray == null) {
            return;
        }
        byte[] existing = byArray;
        this.masterKeyFileStorage.save(this.createMasterKey(existing, this.masterKeyFileStorage.isAutoGenerated()));
    }

    public final void setCustomMasterPasswordIfNeeded(@NotNull Path defaultDbFile) {
        Intrinsics.checkParameterIsNotNull((Object)defaultDbFile, (String)"defaultDbFile");
        if (Intrinsics.areEqual((Object)this.file, (Object)defaultDbFile)) {
            return;
        }
        if (!this.masterKeyFileStorage.isAutoGenerated()) {
            return;
        }
        this.askAndSetMasterKey(null, CredentialStoreBundle.INSTANCE.message("kee.pass.top.note", new Object[0]));
    }

    public KeePassFileManager(@NotNull Path file, @NotNull Path masterKeyFile, @NotNull EncryptionSpec masterKeyEncryptionSpec, @NotNull Lazy<? extends SecureRandom> secureRandom2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)masterKeyFile, (String)"masterKeyFile");
        Intrinsics.checkParameterIsNotNull((Object)masterKeyEncryptionSpec, (String)"masterKeyEncryptionSpec");
        Intrinsics.checkParameterIsNotNull(secureRandom2, (String)"secureRandom");
        this.file = file;
        this.masterKeyEncryptionSpec = masterKeyEncryptionSpec;
        this.secureRandom = secureRandom2;
        this.masterKeyFileStorage = new MasterKeyFileStorage(masterKeyFile);
    }

    public static final /* synthetic */ Path access$getFile$p(KeePassFileManager $this) {
        return $this.file;
    }

    public static final /* synthetic */ MasterKeyFileStorage access$getMasterKeyFileStorage$p(KeePassFileManager $this) {
        return $this.masterKeyFileStorage;
    }

    public static final /* synthetic */ Lazy access$getSecureRandom$p(KeePassFileManager $this) {
        return $this.secureRandom;
    }

    public static final /* synthetic */ char[] access$checkIsEmpty(KeePassFileManager $this, JPasswordField field, List errors) {
        return $this.checkIsEmpty(field, errors);
    }
}

