/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsPushDialog
extends DialogWrapper
implements VcsPushUi,
DataProvider {
    @NonNls
    private static final String DIMENSION_KEY = "Vcs.Push.Dialog.v2";
    @NonNls
    private static final String HELP_ID = "Vcs.Push.Dialog";
    private static final Logger LOG = Logger.getInstance(VcsPushDialog.class);
    private static final int CENTER_PANEL_HEIGHT = 450;
    private static final int CENTER_PANEL_WIDTH = 800;
    protected final Project myProject;
    private final PushLog myListPanel;
    protected final PushController myController;
    private final Map<PushSupport<?, ?, ?>, VcsPushOptionsPanel> myAdditionalPanels;
    private Action myMainAction;
    @NotNull
    private final List<ActionWrapper> myPushActions;

    public VcsPushDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project == null) {
            VcsPushDialog.$$$reportNull$$$0(0);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(1);
        }
        this(project, VcsRepositoryManager.getInstance(project).getRepositories(), selectedRepositories, currentRepo, null);
    }

    public VcsPushDialog(@NotNull Project project, Collection<? extends Repository> allRepos, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo, @Nullable PushSource pushSource) {
        if (project == null) {
            VcsPushDialog.$$$reportNull$$$0(2);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(3);
        }
        super(project, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.myController = new PushController(project, this, allRepos, selectedRepositories, currentRepo, pushSource);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myListPanel = this.myController.getPushPanelLog();
        this.myPushActions = this.collectPushActions();
        this.init();
        this.updateOkActions();
        this.setOKButtonText(DvcsBundle.getString("action.push"));
        this.setOKButtonMnemonic(80);
        String title2 = allRepos.size() == 1 ? DvcsBundle.message("push.dialog.push.commits.to.title", DvcsUtil.getShortRepositoryName((Repository)ContainerUtil.getFirstItem(allRepos))) : DvcsBundle.getString("push.dialog.push.commits.title");
        this.setTitle(title2);
    }

    @NotNull
    private List<ActionWrapper> collectPushActions() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.Push.Actions");
        List additionalActions = ContainerUtil.findAll((Object[])group.getChildren(null), PushActionBase.class);
        SimplePushAction simplePushAction = new SimplePushAction();
        PushActionBase.DefaultPushAction defaultPushAction = this.findDefaultPushAction(additionalActions);
        ArrayList<PushActionBase> pushActions = new ArrayList<PushActionBase>();
        pushActions.add(simplePushAction);
        pushActions.addAll(additionalActions);
        if (defaultPushAction != null) {
            pushActions.remove(defaultPushAction);
            defaultPushAction.customize(pushActions);
        }
        List list = ContainerUtil.map(pushActions, action -> new ActionWrapper(this.myProject, this, (PushActionBase)((Object)action)));
        if (list == null) {
            VcsPushDialog.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    private PushActionBase.DefaultPushAction findDefaultPushAction(@NotNull List<PushActionBase> additionalActions) {
        List defaultPushActions;
        if (additionalActions == null) {
            VcsPushDialog.$$$reportNull$$$0(5);
        }
        if ((defaultPushActions = ContainerUtil.findAll(additionalActions, action -> action instanceof PushActionBase.DefaultPushAction && action.isEnabled(this))).isEmpty()) {
            return null;
        }
        if (defaultPushActions.size() == 1) {
            return (PushActionBase.DefaultPushAction)defaultPushActions.get(0);
        }
        LOG.warn("There can be only one default push action, found: " + defaultPushActions);
        return null;
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return this.createSouthOptionsPanel();
    }

    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        southPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return southPanel;
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((int)0, (int)2).addToCenter((Component)this.myListPanel).addToBottom((Component)this.createOptionsPanel());
        this.myListPanel.setPreferredSize((Dimension)new JBDimension(800, 450));
        return panel2;
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 0, flowy")){

            @Override
            public Component add(Component comp) {
                BorderLayoutPanel wrapperPanel = new BorderLayoutPanel().addToCenter(comp);
                wrapperPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)15, (int)0, (int)0));
                return super.add((Component)wrapperPanel);
            }
        };
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            if (panel2.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.DEFAULT) continue;
            optionsPanel.add((Component)panel2);
        }
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            VcsPushDialog.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createSouthOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout(String.format("ins 0 %spx 0 0, flowx, gapx %spx", JBUI.scale((int)20), JBUI.scale((int)16))));
        for (VcsPushOptionsPanel panel2 : this.myAdditionalPanels.values()) {
            if (panel2.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.SOUTH) continue;
            optionsPanel.add((Component)panel2);
        }
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            VcsPushDialog.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.myMainAction = new ComplexPushAction(this.myPushActions.get(0), this.myPushActions.subList(1, this.myPushActions.size()));
        this.myMainAction.putValue("DefaultAction", Boolean.TRUE);
        actions.add(this.myMainAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            VcsPushDialog.$$$reportNull$$$0(8);
        }
        return actionArray;
    }

    @Override
    public boolean canPush() {
        return this.myController.isPushAllowed();
    }

    @Override
    @NotNull
    public Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> getSelectedPushSpecs() {
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> map2 = this.myController.getSelectedPushSpecs();
        if (map2 == null) {
            VcsPushDialog.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myMainAction;
        if (action == null) {
            VcsPushDialog.$$$reportNull$$$0(10);
        }
        return action;
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    public void push(final boolean forcePush) {
        this.executeAfterRunningPrePushHandlers(new Task.Backgroundable(this.myProject, DvcsBundle.getString("push.process.pushing"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                VcsPushDialog.this.myController.push(forcePush);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/ui/VcsPushDialog$2", "run"));
            }
        });
    }

    @Override
    public void executeAfterRunningPrePushHandlers(@NotNull Task.Backgroundable activity) {
        PrePushHandler.Result result2;
        if (activity == null) {
            VcsPushDialog.$$$reportNull$$$0(11);
        }
        if ((result2 = this.runPrePushHandlersInModalTask()) == PrePushHandler.Result.OK) {
            activity.queue();
            this.close(0);
        } else if (result2 == PrePushHandler.Result.ABORT_AND_CLOSE) {
            this.doCancelAction();
        } else if (result2 == PrePushHandler.Result.ABORT) {
            // empty if block
        }
    }

    public PrePushHandler.Result runPrePushHandlersInModalTask() {
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result2 = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), DvcsBundle.getString("push.process.checking.commits"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                result2.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (error instanceof PushController.HandlerException) {
                    String suggestionMessageProblem;
                    PushController.HandlerException handlerException = (PushController.HandlerException)error;
                    Throwable cause = handlerException.getCause();
                    String failedHandler = handlerException.getFailedHandlerName();
                    List<String> skippedHandlers = handlerException.getSkippedHandlers();
                    if (cause instanceof ProcessCanceledException) {
                        suggestionMessageProblem = DvcsBundle.message("push.dialog.push.cancelled.message", failedHandler);
                    } else {
                        super.onThrowable(cause);
                        suggestionMessageProblem = DvcsBundle.message("push.dialog.push.failed.message", failedHandler);
                    }
                    @Nls String suggestionMessageQuestion = skippedHandlers.isEmpty() ? DvcsBundle.message("push.dialog.push.anyway.confirmation", new Object[0]) : DvcsBundle.message("push.dialog.skip.all.remaining.steps.confirmation", new Object[0]);
                    this.suggestToSkipOrPush(suggestionMessageProblem + "\n" + suggestionMessageQuestion);
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush(DvcsBundle.getString("push.dialog.skip.all.steps.confirmation"));
            }

            private void suggestToSkipOrPush(@Nls @NotNull String message) {
                if (message == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)DvcsBundle.getString("action.push"), (String)DvcsBundle.getString("action.push.anyway"), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                    result2.set(PrePushHandler.Result.OK);
                } else {
                    result2.set(PrePushHandler.Result.ABORT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestToSkipOrPush";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
        return result2.get();
    }

    public void updateOkActions() {
        this.myMainAction.setEnabled(this.canPush());
        for (ActionWrapper wrapper : this.myPushActions) {
            wrapper.update();
        }
    }

    public void enableOkActions(boolean value) {
        this.myMainAction.setEnabled(value);
    }

    @Override
    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel2;
        if (support == null) {
            VcsPushDialog.$$$reportNull$$$0(12);
        }
        return (panel2 = this.myAdditionalPanels.get(support)) == null ? null : panel2.getValue();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            VcsPushDialog.$$$reportNull$$$0(13);
        }
        if (VcsPushUi.VCS_PUSH_DIALOG.is(dataId)) {
            return this;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepositories";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalActions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPushActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthOptionsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPushSpecs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultPushAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAfterRunningPrePushHandlers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptionValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ActionWrapper
    extends AbstractAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsPushUi myDialog;
        @NotNull
        private final PushActionBase myRealAction;

        ActionWrapper(@NotNull Project project, @NotNull VcsPushUi dialog, @NotNull PushActionBase realAction) {
            if (project == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (dialog == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            if (realAction == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            super(realAction.getTemplatePresentation().getTextWithMnemonic());
            this.myProject = project;
            this.myDialog = dialog;
            this.myRealAction = realAction;
            this.putValue("AnAction", (Object)realAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.actionPerformed(this.myProject, this.myDialog);
        }

        public void update() {
            boolean enabled = this.myRealAction.isEnabled(this.myDialog);
            this.setEnabled(enabled);
            this.putValue("ShortDescription", this.myRealAction.getDescription(this.myDialog, enabled));
        }

        @NotNull
        public String getName() {
            String string = Objects.requireNonNull(this.myRealAction.getTemplatePresentation().getTextWithMnemonic());
            if (string == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public final class SimplePushAction
    extends PushActionBase {
        private SimplePushAction() {
            super(DvcsBundle.getString("action.complex.push"));
        }

        @Override
        protected boolean isEnabled(@NotNull VcsPushUi dialog) {
            if (dialog == null) {
                SimplePushAction.$$$reportNull$$$0(0);
            }
            return dialog.canPush();
        }

        @Override
        @Nls
        @Nullable
        protected String getDescription(@NotNull VcsPushUi dialog, boolean enabled) {
            if (dialog == null) {
                SimplePushAction.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        protected void actionPerformed(@NotNull Project project, @NotNull VcsPushUi dialog) {
            if (project == null) {
                SimplePushAction.$$$reportNull$$$0(2);
            }
            if (dialog == null) {
                SimplePushAction.$$$reportNull$$$0(3);
            }
            VcsPushDialog.this.push(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$SimplePushAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDescription";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final ActionWrapper myDefaultAction;
        private final List<? extends ActionWrapper> myOptions;

        private ComplexPushAction(@NotNull ActionWrapper defaultAction, @NotNull List<? extends ActionWrapper> additionalActions) {
            if (defaultAction == null) {
                ComplexPushAction.$$$reportNull$$$0(0);
            }
            if (additionalActions == null) {
                ComplexPushAction.$$$reportNull$$$0(1);
            }
            super(defaultAction.getName());
            this.myDefaultAction = defaultAction;
            this.myOptions = additionalActions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDefaultAction.actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action action : this.myOptions) {
                action.setEnabled(isEnabled);
            }
        }

        public Action @NotNull [] getOptions() {
            Action[] actionArray = this.myOptions.toArray(new ActionWrapper[0]);
            if (actionArray == null) {
                ComplexPushAction.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalActions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

