/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitPatchWriter {
    @NonNls
    static final String GIT_DIFF_HEADER = "diff --git %s %s";
    @NonNls
    private static final String FILE_MODE_HEADER = "%s file mode %s";
    @NonNls
    private static final String INDEX_SHA1_HEADER = "index %s..%s";
    @NonNls
    private static final String FILE_RENAME_FROM_HEADER = "rename from %s";
    @NonNls
    private static final String FILE_RENAME_TO_HEADER = "rename to %s";

    @NotNull
    static String getFileModeHeader(@NotNull FileStatus fileStatus, int mode) {
        if (fileStatus == null) {
            GitPatchWriter.$$$reportNull$$$0(0);
        }
        String string = String.format(FILE_MODE_HEADER, fileStatus == FileStatus.DELETED ? "deleted" : "new", mode);
        if (string == null) {
            GitPatchWriter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static String getIndexHeader(@NotNull String beforeHash, @NotNull String afterHash) {
        if (beforeHash == null) {
            GitPatchWriter.$$$reportNull$$$0(2);
        }
        if (afterHash == null) {
            GitPatchWriter.$$$reportNull$$$0(3);
        }
        String string = String.format(INDEX_SHA1_HEADER, beforeHash, afterHash);
        if (string == null) {
            GitPatchWriter.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void writeGitHeader(@NotNull Writer writer, @Nullable String basePath, @NotNull FilePatch filePatch) throws IOException {
        if (writer == null) {
            GitPatchWriter.$$$reportNull$$$0(5);
        }
        if (filePatch == null) {
            GitPatchWriter.$$$reportNull$$$0(6);
        }
        String lineSeparator = "\n";
        writer.write(String.format(GIT_DIFF_HEADER, filePatch.getBeforeName(), filePatch.getAfterName()));
        writer.write(lineSeparator);
        File afterFile = new File(basePath, filePatch.getAfterName());
        if (filePatch.isDeletedFile()) {
            writer.write(GitPatchWriter.getFileModeHeader(FileStatus.DELETED, 100644));
            writer.write(lineSeparator);
        } else if (filePatch.isNewFile()) {
            writer.write(GitPatchWriter.getFileModeHeader(FileStatus.ADDED, !SystemInfo.isWindows && afterFile.canExecute() ? 100755 : 100644));
            writer.write(lineSeparator);
        } else if (!StringUtil.equals((CharSequence)filePatch.getBeforeName(), (CharSequence)filePatch.getAfterName())) {
            writer.write(String.format(FILE_RENAME_FROM_HEADER, filePatch.getBeforeName()));
            writer.write(lineSeparator);
            writer.write(String.format(FILE_RENAME_TO_HEADER, filePatch.getAfterName()));
            writer.write(lineSeparator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/GitPatchWriter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeHash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/GitPatchWriter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileModeHeader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileModeHeader";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndexHeader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeGitHeader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

