/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j;

import com.pty4j.PtyProcessBuilder;
import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public abstract class PtyProcess
extends Process {
    public abstract boolean isRunning();

    public abstract void setWinSize(WinSize var1);

    public abstract WinSize getWinSize() throws IOException;

    public abstract int getPid();

    public static PtyProcess exec(String[] command) throws IOException {
        return PtyProcess.exec(command, (Map<String, String>)null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment) throws IOException {
        return PtyProcess.exec(command, environment, null, false, false, null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment, String workingDirectory) throws IOException {
        return PtyProcess.exec(command, environment, workingDirectory, false, false, null);
    }

    @Deprecated
    public static PtyProcess exec(String[] command, String[] environment) throws IOException {
        return PtyProcess.exec(command, environment, null, false);
    }

    @Deprecated
    public static PtyProcess exec(String[] command, String[] environment, String workingDirectory, boolean console) throws IOException {
        if (Platform.isWindows()) {
            return new WinPtyProcess(command, environment, workingDirectory, console);
        }
        return new UnixPtyProcess(command, environment, workingDirectory, new Pty(console), console ? new Pty() : null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment, String workingDirectory, boolean console) throws IOException {
        return PtyProcess.exec(command, environment, workingDirectory, console, false, null);
    }

    public static PtyProcess exec(String[] command, Map<String, String> environment, String workingDirectory, boolean console, boolean cygwin, File logFile) throws IOException {
        PtyProcessBuilder builder = new PtyProcessBuilder(command).setEnvironment(environment).setDirectory(workingDirectory).setConsole(console).setCygwin(cygwin).setLogFile(logFile);
        return builder.start();
    }
}

