/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.rules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\bJ\u001c\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0007J\b\u0010 \u001a\u00020\u0004H\u0007J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\bH\u0007J\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\bJ\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0002\u0010\u001e\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/intellij/testFramework/rules/TempDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "myRoot", "Ljava/io/File;", "myVirtualFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "name", "", "nextDirNameSuffix", "Ljava/util/concurrent/atomic/AtomicInteger;", "root", "getRoot", "()Ljava/io/File;", "virtualFileRoot", "getVirtualFileRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "makeDirectories", "path", "Ljava/nio/file/Path;", "newDirectory", "relativePath", "newFile", "content", "", "newFolder", "newVirtualDirectory", "newVirtualFile", "intellij.platform.testFramework"})
public final class TempDirectory
extends ExternalResource {
    private String name;
    private final AtomicInteger nextDirNameSuffix = new AtomicInteger();
    private File myRoot;
    private VirtualFile myVirtualFileRoot;

    @NotNull
    public final File getRoot() {
        if (this.myRoot == null) {
            String string = this.name;
            boolean bl = false;
            boolean bl2 = false;
            if (string == null) {
                boolean bl3 = false;
                String string2 = "apply() was not called";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            this.myRoot = Files.createTempDirectory("unitTest_" + this.name + '_', new FileAttribute[0]).toRealPath(new LinkOption[0]).toFile();
        }
        File file2 = this.myRoot;
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        return file2;
    }

    private final VirtualFile getVirtualFileRoot() {
        if (this.myVirtualFileRoot == null) {
            VirtualFile virtualFile = this.myVirtualFileRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.getRoot());
            boolean bl = false;
            boolean bl2 = false;
            if (virtualFile == null) {
                boolean bl3 = false;
                String string = "Cannot find virtual file by " + this.getRoot();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.myVirtualFileRoot});
        }
        VirtualFile virtualFile = this.myVirtualFileRoot;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        this.name = PlatformTestUtil.lowercaseFirstLetter(FileUtil.sanitizeFileName((String)description.getMethodName(), (boolean)false), true);
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkExpressionValueIsNotNull((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    protected void after() {
        if (this.myRoot != null) {
            File file2 = this.myRoot;
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            Path path = file2.toPath();
            this.myVirtualFileRoot = null;
            this.myRoot = null;
            this.name = null;
            FileUtil.delete((Path)path);
        }
    }

    @NotNull
    public final File newDirectory(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Path dir = Paths.get(this.getRoot().getPath(), relativePath);
        boolean bl = !Files.exists(dir, new LinkOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already exists: " + dir;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path path = dir;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir");
        this.makeDirectories(path);
        File file2 = dir.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"dir.toFile()");
        return file2;
    }

    @NotNull
    public final File newDirectory() {
        File file2 = FileUtil.createTempDirectory((File)this.getRoot(), (String)("dir" + this.nextDirNameSuffix.incrementAndGet()), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtil.createTempDirec\u2026.incrementAndGet(), null)");
        return file2;
    }

    @JvmOverloads
    @NotNull
    public final File newFile(@NotNull String relativePath, @Nullable byte[] content) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Path file2 = Paths.get(this.getRoot().getPath(), relativePath);
        boolean bl = !Files.exists(file2, new LinkOption[0]);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already exists: " + file2;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Path path = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
        Path path2 = path.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file.parent");
        this.makeDirectories(path2);
        Files.createFile(file2, new FileAttribute[0]);
        if (content != null) {
            Files.write(file2, content, new OpenOption[0]);
        }
        File file3 = file2.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file.toFile()");
        return file3;
    }

    public static /* synthetic */ File newFile$default(TempDirectory tempDirectory, String string, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return tempDirectory.newFile(string, byArray);
    }

    @JvmOverloads
    @NotNull
    public final File newFile(@NotNull String relativePath) {
        return TempDirectory.newFile$default(this, relativePath, null, 2, null);
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        boolean bl = existing == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Already exists: ");
            VirtualFile virtualFile = existing;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            String string = stringBuilder.append(virtualFile.getPath()).toString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = VfsTestUtil.createDir(this.getVirtualFileRoot(), relativePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VfsTestUtil.createDir(vi\u2026alFileRoot, relativePath)");
        return virtualFile;
    }

    @NotNull
    public final VirtualFile newVirtualFile(@NotNull String relativePath, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        VirtualFile existing = this.getVirtualFileRoot().findFileByRelativePath(relativePath);
        boolean bl = existing == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Already exists: ");
            VirtualFile virtualFile = existing;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            String string = stringBuilder.append(virtualFile.getPath()).toString();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        VirtualFile virtualFile = VfsTestUtil.createFile(this.getVirtualFileRoot(), relativePath, content);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VfsTestUtil.createFile(v\u2026t, relativePath, content)");
        return virtualFile;
    }

    public static /* synthetic */ VirtualFile newVirtualFile$default(TempDirectory tempDirectory, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return tempDirectory.newVirtualFile(string, string2);
    }

    @Deprecated(message="use newDirectory(relativePath) instead", replaceWith=@ReplaceWith(imports={}, expression="newDirectory(relativePath)"))
    @NotNull
    public final File newFolder(@NotNull String relativePath) {
        Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
        return this.newDirectory(relativePath);
    }

    @Deprecated(message="use newDirectory() instead", replaceWith=@ReplaceWith(imports={}, expression="newDirectory()"))
    @NotNull
    public final File newFolder() {
        return this.newDirectory();
    }

    private final void makeDirectories(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Path path2 = path.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path.parent");
            this.makeDirectories(path2);
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }
}

