/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

class FoldingHintMouseMotionListener
implements EditorMouseMotionListener {
    private final Project myProject;
    LightweightHint myCurrentHint;
    FoldRegion myCurrentFold;

    FoldingHintMouseMotionListener(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            FoldingHintMouseMotionListener.$$$reportNull$$$0(0);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        LightweightHint hint = null;
        try {
            HintManager hintManager = HintManager.getInstance();
            if (hintManager != null && hintManager.hasShownHintsThatWillHideByOtherHint(false)) {
                return;
            }
            if (e.getArea() != EditorMouseEventArea.FOLDING_OUTLINE_AREA) {
                return;
            }
            Editor editor = e.getEditor();
            if (PsiDocumentManager.getInstance((Project)this.myProject).isUncommited(editor.getDocument())) {
                return;
            }
            MouseEvent mouseEvent = e.getMouseEvent();
            FoldRegion fold = ((EditorEx)editor).getGutterComponentEx().findFoldingAnchorAt(mouseEvent.getX(), mouseEvent.getY());
            if (fold == null || !fold.isValid()) {
                return;
            }
            if (fold == this.myCurrentFold && this.myCurrentHint != null) {
                hint = this.myCurrentHint;
                return;
            }
            TextRange psiElementRange = EditorFoldingInfo.get(editor).getPsiElementRange(fold);
            if (psiElementRange == null) {
                return;
            }
            int textOffset = psiElementRange.getStartOffset();
            Point foldStartXY = editor.visualPositionToXY(editor.offsetToVisualPosition(Math.max(textOffset, fold.getStartOffset())));
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            if (visibleArea.y > foldStartXY.y) {
                int desiredEndVisualLine;
                int availableVisualLines;
                int startVisualLine;
                int endVisualLine;
                if (this.myCurrentHint != null) {
                    this.myCurrentHint.hide();
                    this.myCurrentHint = null;
                }
                if ((endVisualLine = (startVisualLine = editor.offsetToVisualPosition((int)textOffset).line) + (availableVisualLines = EditorFragmentComponent.getAvailableVisualLinesAboveEditor(editor))) > (desiredEndVisualLine = Math.max(0, editor.xyToVisualPosition((Point)new Point((int)0, (int)visibleArea.y)).line - 1))) {
                    endVisualLine = desiredEndVisualLine;
                }
                int endOffset = editor.visualPositionToOffset(new VisualPosition(endVisualLine, 0));
                UnfairTextRange textRange = new UnfairTextRange(textOffset, endOffset);
                hint = EditorFragmentComponent.showEditorFragmentHint(editor, (TextRange)textRange, true, true);
                this.myCurrentFold = fold;
                this.myCurrentHint = hint;
            }
        }
        finally {
            if (hint == null) {
                if (this.myCurrentHint != null) {
                    this.myCurrentHint.hide();
                    this.myCurrentHint = null;
                }
                this.myCurrentFold = null;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/folding/impl/FoldingHintMouseMotionListener", "mouseMoved"));
    }
}

