/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diagnostic/hprof/util/HeapReportUtils;", "", "()V", "SECTION_HEADER_SIZE", "", "SI_PREFIXES", "", "STRING_PADDING_FOR_COUNT", "STRING_PADDING_FOR_SIZE", "sectionHeader", "", "name", "toPaddedShortStringAsCount", "count", "", "toPaddedShortStringAsSize", "size", "toShortString", "num", "toShortStringAsCount", "toShortStringAsSize", "intellij.platform.ide.impl"})
public final class HeapReportUtils {
    private static final char[] SI_PREFIXES;
    public static final int STRING_PADDING_FOR_COUNT = 5;
    public static final int STRING_PADDING_FOR_SIZE = 6;
    public static final int SECTION_HEADER_SIZE = 50;
    public static final HeapReportUtils INSTANCE;

    @NotNull
    public final String toShortStringAsCount(long count) {
        return this.toShortString(count);
    }

    @NotNull
    public final String toPaddedShortStringAsCount(long count) {
        return StringsKt.padStart$default((String)this.toShortString(count), (int)5, (char)'\u0000', (int)2, null);
    }

    @NotNull
    public final String toShortStringAsSize(long size) {
        return this.toShortString(size) + "B";
    }

    @NotNull
    public final String toPaddedShortStringAsSize(long size) {
        return StringsKt.padStart$default((String)this.toShortStringAsSize(size), (int)6, (char)'\u0000', (int)2, null);
    }

    @NotNull
    public final String sectionHeader(@NonNls @NotNull String name) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        CharSequence charSequence = name;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = ((String)charSequence).toUpperCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase(locale)");
        String uppercaseName = string2;
        if (uppercaseName.length() >= 48) {
            string = uppercaseName;
        } else {
            charSequence = new StringBuilder();
            boolean bl2 = false;
            bl = false;
            CharSequence $this$apply = charSequence;
            boolean bl3 = false;
            ((StringBuilder)$this$apply).append(StringsKt.repeat((CharSequence)"=", (int)((50 - uppercaseName.length()) / 2)));
            ((StringBuilder)$this$apply).append(' ' + uppercaseName + ' ');
            ((StringBuilder)$this$apply).append(StringsKt.repeat((CharSequence)"=", (int)((50 - uppercaseName.length() - 1) / 2)));
            String string3 = ((StringBuilder)charSequence).toString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply {\n\u2026 / 2))\n      }.toString()");
        }
        return string;
    }

    private final String toShortString(long num) {
        long localNum;
        int shiftCount = 0;
        for (localNum = num; localNum >= (long)1000; localNum /= (long)10) {
            ++shiftCount;
        }
        if (shiftCount > 0) {
            String string;
            int siPrefixIndex = (shiftCount - 1) / 3;
            boolean bl = siPrefixIndex < SI_PREFIXES.length;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            char suffix = SI_PREFIXES[siPrefixIndex];
            switch (shiftCount % 3) {
                case 0: {
                    string = String.valueOf(localNum);
                    break;
                }
                case 1: {
                    string = String.valueOf((double)localNum / (double)100);
                    break;
                }
                case 2: {
                    string = String.valueOf((double)localNum / (double)10);
                    break;
                }
                default: {
                    bl3 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (_Assertions.ENABLED) {
                        boolean bl7 = false;
                        String string3 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string3));
                    }
                    string = "????";
                }
            }
            String value2 = string;
            return value2 + suffix;
        }
        return String.valueOf(localNum);
    }

    private HeapReportUtils() {
    }

    static {
        HeapReportUtils heapReportUtils;
        INSTANCE = heapReportUtils = new HeapReportUtils();
        SI_PREFIXES = new char[]{'K', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    }
}

