/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.util;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.Queue;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/hprof/util/TruncatingPrintBuffer;", "Ljava/io/Closeable;", "headLimit", "", "tailLimit", "printFunc", "Lkotlin/Function1;", "", "", "(IILkotlin/jvm/functions/Function1;)V", "closed", "", "linesLost", "linesPrinted", "queue", "Ljava/util/Queue;", "close", "", "println", "s", "intellij.platform.ide.impl"})
public final class TruncatingPrintBuffer
implements Closeable {
    private final Queue<String> queue;
    private int linesPrinted;
    private int linesLost;
    private boolean closed;
    private final int headLimit;
    private final int tailLimit;
    private final Function1<String, Object> printFunc;

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.linesLost > 0) {
            int n;
            while (this.queue.size() > this.tailLimit) {
                this.queue.remove();
                n = this.linesLost;
                this.linesLost = n + 1;
            }
            n = this.linesLost > 1 ? 1 : 0;
            boolean bl = false;
            boolean bl2 = false;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl3 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.printFunc.invoke((Object)("[...removed " + this.linesLost + " lines...]"));
        }
        Iterable $this$forEach$iv = this.queue;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            this.printFunc.invoke((Object)string);
        }
        this.queue.clear();
    }

    public final void println() {
        this.println("");
    }

    public final void println(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        if (this.closed) {
            throw (Throwable)new IllegalStateException();
        }
        if (this.linesPrinted < this.headLimit) {
            this.printFunc.invoke((Object)s);
            int n = this.linesPrinted;
            this.linesPrinted = n + 1;
        } else {
            this.queue.add(s);
            if (this.queue.size() > this.tailLimit + 1) {
                this.queue.remove();
                int n = this.linesLost;
                this.linesLost = n + 1;
            }
        }
    }

    public TruncatingPrintBuffer(int headLimit, int tailLimit, @NotNull Function1<? super String, ? extends Object> printFunc2) {
        Intrinsics.checkParameterIsNotNull(printFunc2, (String)"printFunc");
        this.headLimit = headLimit;
        this.tailLimit = tailLimit;
        this.printFunc = printFunc2;
        this.queue = new LinkedList();
    }
}

