/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleLineModifier;
import com.intellij.execution.console.CustomizableConsoleFoldingBean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="ConsoleFoldingSettings", storages={@Storage(value="consoleFolding.xml")})
public class ConsoleFoldingSettings
implements PersistentStateComponent<MyBean> {
    private final List<String> myPositivePatterns = new ArrayList<String>();
    private final List<String> myNegativePatterns = new ArrayList<String>();

    public ConsoleFoldingSettings() {
        for (CustomizableConsoleFoldingBean regexp : (CustomizableConsoleFoldingBean[])CustomizableConsoleFoldingBean.EP_NAME.getExtensions()) {
            this.patternList(regexp.negate).add(regexp.substring);
        }
        CustomizableConsoleFoldingBean.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CustomizableConsoleFoldingBean>(){

            public void extensionAdded(@NotNull CustomizableConsoleFoldingBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ConsoleFoldingSettings.this.patternList(extension.negate).add(extension.substring);
            }

            public void extensionRemoved(@NotNull CustomizableConsoleFoldingBean extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ConsoleFoldingSettings.this.patternList(extension.negate).remove(extension.substring);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/console/ConsoleFoldingSettings$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    public static ConsoleFoldingSettings getSettings() {
        return (ConsoleFoldingSettings)ServiceManager.getService(ConsoleFoldingSettings.class);
    }

    public boolean shouldFoldLine(String line) {
        return ConsoleFoldingSettings.containsAny(line, this.myPositivePatterns) && !ConsoleFoldingSettings.containsAny(line, this.myNegativePatterns);
    }

    private static boolean containsAny(String line, List<String> patterns) {
        HashSet<String> lines = null;
        for (ConsoleLineModifier modifier : ConsoleLineModifier.EP_NAME.getExtensionList()) {
            String modifiedLine = modifier.modify(line);
            if (modifiedLine == null) continue;
            if (lines == null) {
                lines = new HashSet<String>();
                lines.add(line);
            }
            lines.add(modifiedLine);
        }
        Condition containsPredicate = l -> {
            for (String pattern : patterns) {
                if (!l.contains(pattern)) continue;
                return true;
            }
            return false;
        };
        if (lines == null) {
            return containsPredicate.value((Object)line);
        }
        return ContainerUtil.exists(lines, (Condition)containsPredicate);
    }

    public List<String> getPositivePatterns() {
        return this.myPositivePatterns;
    }

    public List<String> getNegativePatterns() {
        return this.myNegativePatterns;
    }

    public MyBean getState() {
        MyBean result2 = new MyBean();
        this.writeDiff(result2.addedPositive, result2.removedPositive, false);
        this.writeDiff(result2.addedNegative, result2.removedNegative, true);
        return result2;
    }

    private void writeDiff(List<? super String> added, List<? super String> removed, boolean negated) {
        THashSet baseline = new THashSet();
        for (CustomizableConsoleFoldingBean regexp : (CustomizableConsoleFoldingBean[])CustomizableConsoleFoldingBean.EP_NAME.getExtensions()) {
            if (regexp.negate != negated) continue;
            baseline.add(regexp.substring);
        }
        List<String> current2 = this.patternList(negated);
        added.addAll(current2);
        added.removeAll((Collection<?>)baseline);
        baseline.removeAll(current2);
        removed.addAll((Collection<? super String>)baseline);
    }

    private List<String> patternList(boolean negated) {
        return negated ? this.myNegativePatterns : this.myPositivePatterns;
    }

    private static Collection<String> filterEmptyStringsFromCollection(Collection<String> collection) {
        return ContainerUtil.filter(collection, input -> !StringUtil.isEmpty((String)input));
    }

    public void loadState(@NotNull MyBean state) {
        if (state == null) {
            ConsoleFoldingSettings.$$$reportNull$$$0(0);
        }
        this.myPositivePatterns.clear();
        this.myNegativePatterns.clear();
        HashSet<String> removedPositive = new HashSet<String>(state.removedPositive);
        HashSet<String> removedNegative = new HashSet<String>(state.removedNegative);
        for (CustomizableConsoleFoldingBean regexp : (CustomizableConsoleFoldingBean[])CustomizableConsoleFoldingBean.EP_NAME.getExtensions()) {
            if ((regexp.negate ? removedNegative : removedPositive).contains(regexp.substring)) continue;
            this.patternList(regexp.negate).add(regexp.substring);
        }
        this.myPositivePatterns.addAll(ConsoleFoldingSettings.filterEmptyStringsFromCollection(state.addedPositive));
        this.myNegativePatterns.addAll(ConsoleFoldingSettings.filterEmptyStringsFromCollection(state.addedNegative));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/console/ConsoleFoldingSettings", "loadState"));
    }

    public static class MyBean {
        public List<String> addedPositive = new ArrayList<String>();
        public List<String> addedNegative = new ArrayList<String>();
        public List<String> removedPositive = new ArrayList<String>();
        public List<String> removedNegative = new ArrayList<String>();
    }
}

