/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.impl.NotificationAllowlistEP;
import com.intellij.notification.impl.NotificationWhitelistEP;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationCollector {
    private static final Logger LOG = Logger.getInstance(NotificationCollector.class);
    private static final Map<String, PluginInfo> ourNotificationGroupsWhitelist = new ConcurrentHashMap<String, PluginInfo>();
    private static final Set<String> ourNotificationsWhitelist = new HashSet<String>();
    private static final String NOTIFICATIONS = "notifications";
    private static final String UNKNOWN = "unknown";
    private static final String NOTIFICATION_GROUP = "notification_group";

    private NotificationCollector() {
        ContainerUtil.concat((List)NotificationWhitelistEP.EP_NAME.getExtensionList(), (List)NotificationAllowlistEP.EP_NAME.getExtensionList()).forEach(NotificationCollector::addNotificationsToWhitelist);
        ExtensionPointListener<NotificationAllowlistEP> extensionPointListener = new ExtensionPointListener<NotificationAllowlistEP>(){

            public void extensionAdded(@NotNull NotificationAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                NotificationCollector.addNotificationsToWhitelist(extension);
            }

            public void extensionRemoved(@NotNull NotificationAllowlistEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                NotificationCollector.removeNotificationsFromWhitelist(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NotificationWhitelistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)extensionPointListener, (Disposable)ApplicationManager.getApplication());
        NotificationAllowlistEP.EP_NAME.addExtensionPointListener((ExtensionPointListener)extensionPointListener, (Disposable)ApplicationManager.getApplication());
    }

    public void logBalloonShown(@Nullable Project project, @NotNull NotificationDisplayType displayType, @NotNull Notification notification, boolean isExpandable) {
        if (displayType == null) {
            NotificationCollector.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(1);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("display_type", displayType.name()).addData("severity", notification.getType().name()).addData("is_expandable", isExpandable);
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "shown", data2);
    }

    public void logToolWindowNotificationShown(@Nullable Project project, @NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(2);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("display_type", NotificationDisplayType.TOOL_WINDOW.name()).addData("severity", notification.getType().name());
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "shown", data2);
    }

    public void logNotificationLoggedInEventLog(@NotNull Project project, @NotNull Notification notification) {
        if (project == null) {
            NotificationCollector.$$$reportNull$$$0(3);
        }
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(4);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("severity", notification.getType().name());
        FUCounterUsageLogger.getInstance().logEvent(project, NOTIFICATIONS, "logged", data2);
    }

    public void logNotificationBalloonClosedByUser(@Nullable String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId2) {
        if (notificationId == null) {
            return;
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(groupId2, notificationId, notificationDisplayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "closed.by.user", data2);
    }

    public void logNotificationActionInvoked(@NotNull Notification notification, @NotNull AnAction action2, @NotNull NotificationPlace notificationPlace) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(5);
        }
        if (action2 == null) {
            NotificationCollector.$$$reportNull$$$0(6);
        }
        if (notificationPlace == null) {
            NotificationCollector.$$$reportNull$$$0(7);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId).addData("notification_place", notificationPlace.name());
        if (action2 instanceof NotificationAction.Simple) {
            Object actionInstance = ((NotificationAction.Simple)action2).getActionInstance();
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(actionInstance.getClass());
            data2.addData("action_id", info.isSafeToReport() ? actionInstance.getClass().getName() : "third.party");
        } else {
            ActionsCollectorImpl.addActionClass(data2, action2, PluginInfoDetectorKt.getPluginInfo(action2.getClass()));
        }
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "action.invoked", data2);
    }

    public void logHyperlinkClicked(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(8);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "hyperlink.clicked", data2);
    }

    public void logBalloonShownFromEventLog(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(9);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "event.log.balloon.shown", data2);
    }

    public void logNotificationSettingsClicked(@NotNull String notificationId, @Nullable String notificationDisplayId, @Nullable String groupId2) {
        if (notificationId == null) {
            NotificationCollector.$$$reportNull$$$0(10);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(groupId2, notificationId, notificationDisplayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "settings.clicked", data2);
    }

    public void logNotificationBalloonExpanded(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(11);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "balloon.expanded", data2);
    }

    public void logNotificationBalloonCollapsed(@NotNull Notification notification) {
        if (notification == null) {
            NotificationCollector.$$$reportNull$$$0(12);
        }
        FeatureUsageData data2 = NotificationCollector.createNotificationData(notification.getGroupId(), notification.id, notification.displayId);
        FUCounterUsageLogger.getInstance().logEvent(NOTIFICATIONS, "balloon.collapsed", data2);
    }

    @NotNull
    private static FeatureUsageData createNotificationData(@Nullable String groupId2, @NotNull String id2, @Nullable String displayId) {
        if (id2 == null) {
            NotificationCollector.$$$reportNull$$$0(13);
        }
        FeatureUsageData featureUsageData = new FeatureUsageData().addData("id", id2).addData("display_id", StringUtil.isNotEmpty((String)displayId) ? displayId : UNKNOWN).addData(NOTIFICATION_GROUP, StringUtil.isNotEmpty((String)groupId2) ? groupId2 : UNKNOWN).addPluginInfo(NotificationCollector.getPluginInfo(groupId2));
        if (featureUsageData == null) {
            NotificationCollector.$$$reportNull$$$0(14);
        }
        return featureUsageData;
    }

    public static NotificationCollector getInstance() {
        return (NotificationCollector)ServiceManager.getService(NotificationCollector.class);
    }

    private static void removeNotificationsFromWhitelist(@NotNull NotificationAllowlistEP extension) {
        PluginDescriptor pluginDescriptor;
        if (extension == null) {
            NotificationCollector.$$$reportNull$$$0(15);
        }
        if ((pluginDescriptor = extension.getPluginDescriptor()) == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
        if (!info.isDevelopedByJetBrains()) {
            return;
        }
        List<String> notificationGroups = NotificationCollector.parseIds(extension.groupIds);
        for (String notificationGroup : notificationGroups) {
            ourNotificationGroupsWhitelist.remove(notificationGroup, info);
        }
    }

    private static PluginInfo getPluginInfo(@Nullable String groupId2) {
        if (groupId2 == null) {
            return null;
        }
        PluginInfo pluginInfo = ourNotificationGroupsWhitelist.get(groupId2);
        if (pluginInfo != null) {
            return pluginInfo;
        }
        NotificationGroup group = NotificationGroup.findRegisteredGroup((String)groupId2);
        if (group == null) {
            return null;
        }
        return PluginInfoDetectorKt.getPluginInfoById((PluginId)group.getPluginId());
    }

    private static void addNotificationsToWhitelist(@NotNull NotificationAllowlistEP extension) {
        PluginDescriptor pluginDescriptor;
        if (extension == null) {
            NotificationCollector.$$$reportNull$$$0(16);
        }
        if ((pluginDescriptor = extension.getPluginDescriptor()) == null) {
            return;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor);
        if (!info.isDevelopedByJetBrains()) {
            return;
        }
        List<String> notificationGroups = NotificationCollector.parseIds(extension.groupIds);
        for (String notificationGroup : notificationGroups) {
            ourNotificationGroupsWhitelist.merge(notificationGroup, info, (oldValue, newValue2) -> {
                if (!oldValue.equals(newValue2)) {
                    LOG.warn("Notification group '" + notificationGroup + "' is already registered in whitelist");
                    return PluginInfoDetectorKt.getUnknownPlugin();
                }
                return oldValue;
            });
        }
        ourNotificationsWhitelist.addAll(NotificationCollector.parseIds(extension.notificationIds));
    }

    @NotNull
    private static List<String> parseIds(@Nullable String entry) {
        String[] values2;
        if (entry == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                NotificationCollector.$$$reportNull$$$0(17);
            }
            return list2;
        }
        ArrayList<String> list3 = new ArrayList<String>();
        for (String value2 : values2 = StringUtil.convertLineSeparators((String)entry, (String)"").split(";")) {
            if (StringUtil.isEmptyOrSpaces((String)value2)) continue;
            list3.add(StringUtil.trim((String)value2));
        }
        ArrayList<String> arrayList = list3;
        if (arrayList == null) {
            NotificationCollector.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationPlace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationCollector";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationData";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShown";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logToolWindowNotificationShown";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationLoggedInEventLog";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationActionInvoked";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logHyperlinkClicked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logBalloonShownFromEventLog";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationSettingsClicked";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonExpanded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logNotificationBalloonCollapsed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationData";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeNotificationsFromWhitelist";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationsToWhitelist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum NotificationPlace {
        BALLOON,
        EVENT_LOG;

    }

    public static class NotificationIdValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "notification_display_id".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                NotificationIdValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NotificationIdValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationIdValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ourNotificationsWhitelist.contains(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationIdValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationIdValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationIdValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NotificationGroupValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return NotificationCollector.NOTIFICATION_GROUP.equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            if (data2 == null) {
                NotificationGroupValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NotificationGroupValidator.$$$reportNull$$$0(1);
            }
            if (NotificationCollector.UNKNOWN.equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    NotificationGroupValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ourNotificationGroupsWhitelist.containsKey(data2) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
            if (validationResultType == null) {
                NotificationGroupValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/impl/NotificationCollector$NotificationGroupValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/impl/NotificationCollector$NotificationGroupValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

