/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;

class EditorAndState {
    private final FileEditorState myState;
    private final VirtualFile myVirtualFile;

    EditorAndState(FileEditor editor, FileEditorState state) {
        this.myVirtualFile = editor.getFile();
        this.myState = state;
    }

    public boolean canBeAppliedTo(FileEditor editor) {
        if (editor == null) {
            return false;
        }
        if (!Objects.equals(this.myVirtualFile, editor.getFile())) {
            return false;
        }
        if (this.myState == null) {
            return false;
        }
        FileEditorState currentState = editor.getState(FileEditorStateLevel.UNDO);
        return this.myState.getClass() == currentState.getClass();
    }

    public FileEditorState getState() {
        return this.myState;
    }
}

