/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ErrorStripeMarkerImpl;
import com.intellij.openapi.editor.impl.ErrorStripeRangeMarkerTree;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.TextRangeInterval;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

class ErrorStripeMarkersModel {
    private static final Logger LOG = Logger.getInstance(ErrorStripeMarkersModel.class);
    private final EditorImpl myEditor;
    private final ErrorStripeRangeMarkerTree myTree;
    private final ErrorStripeRangeMarkerTree myTreeForLines;
    private final List<ErrorStripeListener> myListeners;
    private static final Comparator<ErrorStripeMarkerImpl> BY_AFFECTED_START_OFFSET = Comparator.comparingInt(marker -> {
        RangeHighlighterEx highlighter = marker.getHighlighter();
        return highlighter.isValid() ? highlighter.getAffectedAreaStartOffset() : -1;
    });

    ErrorStripeMarkersModel(@NotNull EditorImpl editor) {
        if (editor == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditor = editor;
        this.myTree = new ErrorStripeRangeMarkerTree(this.myEditor.getDocument());
        this.myTreeForLines = new ErrorStripeRangeMarkerTree(this.myEditor.getDocument());
    }

    void addErrorMarkerListener(ErrorStripeListener listener2, Disposable parent) {
        ContainerUtil.add((Object)listener2, this.myListeners, (Disposable)parent);
    }

    void fireErrorMarkerClicked(RangeHighlighter highlighter, MouseEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeEvent event = new ErrorStripeEvent(this.myEditor, e, highlighter);
        this.myListeners.forEach(listener2 -> listener2.errorMarkerClicked(event));
    }

    public MarkupModelListener createMarkupListener(final boolean documentMarkupModel) {
        return new MarkupModelListener(){

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                ErrorStripeMarkersModel.this.afterAdded(highlighter, documentMarkupModel);
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                ErrorStripeMarkersModel.this.beforeRemoved(highlighter, documentMarkupModel);
            }

            @Override
            public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(2);
                }
                ErrorStripeMarkersModel.this.attributesChanged(highlighter, documentMarkupModel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/openapi/editor/impl/ErrorStripeMarkersModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "attributesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(1);
        }
        if (this.isAvailable(highlighter, documentMarkupModel) && highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) != null) {
            this.createErrorStripeMarker(highlighter);
        }
    }

    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        ErrorStripeMarkerImpl errorStripeMarker;
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(2);
        }
        if ((errorStripeMarker = this.findErrorStripeMarker(highlighter)) != null) {
            this.removeErrorStripeMarker(errorStripeMarker);
        } else {
            LOG.assertTrue(!this.isAvailable(highlighter, documentMarkupModel));
        }
    }

    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(3);
        }
        ErrorStripeMarkerImpl existingErrorStripeMarker = this.findErrorStripeMarker(highlighter);
        boolean hasErrorStripe = this.isAvailable(highlighter, documentMarkupModel);
        if (existingErrorStripeMarker == null) {
            if (hasErrorStripe) {
                this.createErrorStripeMarker(highlighter);
            }
            return;
        }
        if (!hasErrorStripe) {
            this.removeErrorStripeMarker(existingErrorStripeMarker);
            return;
        }
        existingErrorStripeMarker.setGreedyToLeft(highlighter.isGreedyToLeft());
        existingErrorStripeMarker.setGreedyToRight(highlighter.isGreedyToRight());
        if (highlighter instanceof RangeMarkerImpl) {
            existingErrorStripeMarker.setStickingToRight(((RangeMarkerImpl)((Object)highlighter)).isStickingToRight());
        }
        this.myListeners.forEach(l -> l.errorMarkerChanged(new ErrorStripeEvent(this.myEditor, null, highlighter)));
    }

    private boolean isAvailable(@NotNull RangeHighlighterEx highlighter, boolean documentMarkupModel) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(4);
        }
        if (!(!documentMarkupModel || highlighter.getEditorFilter().avaliableIn((Editor)this.myEditor) && this.myEditor.isHighlighterAvailable(highlighter))) {
            return false;
        }
        return highlighter.getErrorStripeMarkColor(this.myEditor.getColorsScheme()) != null;
    }

    private void createErrorStripeMarker(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeMarkerImpl marker = new ErrorStripeMarkerImpl(this.myEditor.getDocument(), highlighter);
        RangeHighlighterEx ex = marker.getHighlighter();
        boolean isStickingToRight = ex instanceof RangeMarkerImpl && ((RangeMarkerImpl)((Object)highlighter)).isStickingToRight();
        this.treeFor(ex).addInterval(marker, ex.getStartOffset(), ex.getEndOffset(), ex.isGreedyToLeft(), ex.isGreedyToRight(), isStickingToRight, ex.getLayer());
        this.myListeners.forEach(l -> l.errorMarkerChanged(new ErrorStripeEvent(this.myEditor, null, highlighter)));
    }

    private void removeErrorStripeMarker(ErrorStripeMarkerImpl errorStripeMarker) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighterEx highlighter = errorStripeMarker.getHighlighter();
        this.treeFor(highlighter).removeInterval(errorStripeMarker);
        this.myListeners.forEach(l -> l.errorMarkerChanged(new ErrorStripeEvent(this.myEditor, null, highlighter)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorStripeMarkerImpl findErrorStripeMarker(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int offset = highlighter.getStartOffset();
        MarkupIterator iterator2 = this.treeFor(highlighter).overlappingIterator(new TextRangeInterval(offset, offset), null);
        try {
            ErrorStripeMarkerImpl errorStripeMarkerImpl = (ErrorStripeMarkerImpl)ContainerUtil.find(iterator2, marker -> marker.getHighlighter() == highlighter);
            return errorStripeMarkerImpl;
        }
        finally {
            iterator2.dispose();
        }
    }

    MarkupIterator<RangeHighlighterEx> highlighterIterator(int startOffset, int endOffset) {
        return new HighlighterIterator(startOffset, endOffset);
    }

    private ErrorStripeRangeMarkerTree treeFor(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            ErrorStripeMarkersModel.$$$reportNull$$$0(7);
        }
        return highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? this.myTree : this.myTreeForLines;
    }

    void clear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myTree.clear();
        this.myTreeForLines.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/ErrorStripeMarkersModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "afterAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeRemoved";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "attributesChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createErrorStripeMarker";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findErrorStripeMarker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "treeFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class HighlighterIterator
    implements MarkupIterator<RangeHighlighterEx> {
        private final MarkupIterator<ErrorStripeMarkerImpl> myDelegate;
        private final List<ErrorStripeMarkerImpl> myToRemove = new ArrayList<ErrorStripeMarkerImpl>();
        private RangeHighlighterEx myNext;

        private HighlighterIterator(int startOffset, int endOffset) {
            startOffset = Math.max(0, startOffset);
            endOffset = Math.max(startOffset, endOffset);
            MarkupIterator exact = ErrorStripeMarkersModel.this.myTree.overlappingIterator(new TextRangeInterval(startOffset, endOffset), null);
            MarkupIterator lines = ErrorStripeMarkersModel.this.myTreeForLines.overlappingIterator(MarkupModelImpl.roundToLineBoundaries(ErrorStripeMarkersModel.this.myEditor.getDocument(), startOffset, endOffset), null);
            this.myDelegate = MarkupIterator.mergeIterators(exact, lines, BY_AFFECTED_START_OFFSET);
            this.advance();
        }

        @Override
        public void dispose() {
            this.myDelegate.dispose();
            this.myToRemove.forEach(m -> ErrorStripeMarkersModel.this.treeFor(m.getHighlighter()).removeInterval(m));
        }

        public RangeHighlighterEx peek() throws NoSuchElementException {
            return this.myNext;
        }

        public boolean hasNext() {
            return this.myNext != null;
        }

        public RangeHighlighterEx next() {
            RangeHighlighterEx result2 = this.myNext;
            this.advance();
            return result2;
        }

        private void advance() {
            while (this.myDelegate.hasNext()) {
                ErrorStripeMarkerImpl next = (ErrorStripeMarkerImpl)this.myDelegate.next();
                RangeHighlighterEx highlighter = next.getHighlighter();
                if (highlighter.isValid()) {
                    this.myNext = highlighter;
                    return;
                }
                LOG.error("Dangling highlighter found: " + highlighter + " (" + next + ")");
                this.myToRemove.add(next);
            }
            this.myNext = null;
        }
    }
}

