/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkPropertiesHolder
implements RemoteSdkProperties {
    private static final String INTERPRETER_PATH = "INTERPRETER_PATH";
    private static final String HELPERS_PATH = "HELPERS_PATH";
    private static final String REMOTE_ROOTS = "REMOTE_ROOTS";
    private static final String REMOTE_PATH = "REMOTE_PATH";
    private static final String INITIALIZED = "INITIALIZED";
    private static final String VALID = "VALID";
    private static final String PATH_MAPPINGS = "PATH_MAPPINGS";
    private static final String RUN_AS_ROOT_VIA_SUDO = "RUN_AS_ROOT_VIA_SUDO";
    private String mySdkId;
    private String myInterpreterPath;
    private String myHelpersPath;
    private final String myHelpersDefaultDirName;
    private boolean myHelpersVersionChecked = false;
    private Set<String> myRemoteRoots = new TreeSet<String>();
    private boolean myInitialized = false;
    private boolean myValid = true;
    private boolean myRunAsRootViaSudo = false;
    @NotNull
    private PathMappingSettings myPathMappings = new PathMappingSettings();

    public RemoteSdkPropertiesHolder(String name) {
        this.myHelpersDefaultDirName = name;
    }

    @Override
    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    @Override
    public void setInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
    }

    @Override
    public String getHelpersPath() {
        return this.myHelpersPath;
    }

    @Override
    public void setHelpersPath(String helpersPath) {
        this.myHelpersPath = helpersPath;
    }

    @Override
    public String getDefaultHelpersName() {
        return this.myHelpersDefaultDirName;
    }

    @Override
    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myPathMappings;
        if (pathMappingSettings == null) {
            RemoteSdkPropertiesHolder.$$$reportNull$$$0(0);
        }
        return pathMappingSettings;
    }

    @Override
    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myPathMappings = new PathMappingSettings();
        if (pathMappings != null) {
            this.myPathMappings.addAll(pathMappings);
        }
    }

    @Override
    public boolean isHelpersVersionChecked() {
        return this.myHelpersVersionChecked;
    }

    @Override
    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myHelpersVersionChecked = helpersVersionChecked;
    }

    @Override
    public void setSdkId(String sdkId) {
        this.mySdkId = sdkId;
    }

    @Override
    public String getSdkId() {
        return this.mySdkId;
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.myInitialized = initialized;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public boolean isRunAsRootViaSudo() {
        return this.myRunAsRootViaSudo;
    }

    @Override
    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRunAsRootViaSudo = runAsRootViaSudo;
    }

    public void copyTo(RemoteSdkProperties copy2) {
        copy2.setInterpreterPath(this.getInterpreterPath());
        copy2.setHelpersPath(this.getHelpersPath());
        copy2.setHelpersVersionChecked(this.isHelpersVersionChecked());
        copy2.setInitialized(this.isInitialized());
        copy2.setValid(this.isValid());
        copy2.setRunAsRootViaSudo(this.isRunAsRootViaSudo());
    }

    public void save(Element rootElement) {
        rootElement.setAttribute(INTERPRETER_PATH, StringUtil.notNullize((String)this.getInterpreterPath()));
        rootElement.setAttribute(HELPERS_PATH, StringUtil.notNullize((String)this.getHelpersPath()));
        rootElement.setAttribute(INITIALIZED, Boolean.toString(this.isInitialized()));
        rootElement.setAttribute(VALID, Boolean.toString(this.isValid()));
        rootElement.setAttribute(RUN_AS_ROOT_VIA_SUDO, Boolean.toString(this.isRunAsRootViaSudo()));
        PathMappingSettings.writeExternal((Element)rootElement, (PathMappingSettings)this.myPathMappings);
    }

    public void load(Element element2) {
        this.setInterpreterPath(StringUtil.nullize((String)element2.getAttributeValue(INTERPRETER_PATH)));
        this.setHelpersPath(StringUtil.nullize((String)element2.getAttributeValue(HELPERS_PATH)));
        this.setInitialized(Boolean.parseBoolean(element2.getAttributeValue(INITIALIZED)));
        this.setValid(Boolean.parseBoolean(element2.getAttributeValue(VALID)));
        this.setPathMappings(PathMappingSettings.readExternal((Element)element2));
        this.setRunAsRootViaSudo(Boolean.parseBoolean(element2.getAttributeValue(RUN_AS_ROOT_VIA_SUDO)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSdkPropertiesHolder holder = (RemoteSdkPropertiesHolder)o;
        if (this.myHelpersVersionChecked != holder.myHelpersVersionChecked) {
            return false;
        }
        if (this.myInitialized != holder.myInitialized) {
            return false;
        }
        if (this.myValid != holder.myValid) {
            return false;
        }
        if (this.myHelpersDefaultDirName != null ? !this.myHelpersDefaultDirName.equals(holder.myHelpersDefaultDirName) : holder.myHelpersDefaultDirName != null) {
            return false;
        }
        if (this.myHelpersPath != null ? !this.myHelpersPath.equals(holder.myHelpersPath) : holder.myHelpersPath != null) {
            return false;
        }
        if (this.myInterpreterPath != null ? !this.myInterpreterPath.equals(holder.myInterpreterPath) : holder.myInterpreterPath != null) {
            return false;
        }
        if (this.myRunAsRootViaSudo != holder.myRunAsRootViaSudo) {
            return false;
        }
        if (!this.myPathMappings.equals((Object)holder.myPathMappings)) {
            return false;
        }
        if (this.myRemoteRoots != null ? !this.myRemoteRoots.equals(holder.myRemoteRoots) : holder.myRemoteRoots != null) {
            return false;
        }
        return !(this.mySdkId != null ? !this.mySdkId.equals(holder.mySdkId) : holder.mySdkId != null);
    }

    public int hashCode() {
        int result2 = this.mySdkId != null ? this.mySdkId.hashCode() : 0;
        result2 = 31 * result2 + (this.myInterpreterPath != null ? this.myInterpreterPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myRunAsRootViaSudo ? 1 : 0);
        result2 = 31 * result2 + (this.myHelpersPath != null ? this.myHelpersPath.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersDefaultDirName != null ? this.myHelpersDefaultDirName.hashCode() : 0);
        result2 = 31 * result2 + (this.myHelpersVersionChecked ? 1 : 0);
        result2 = 31 * result2 + (this.myRemoteRoots != null ? this.myRemoteRoots.hashCode() : 0);
        result2 = 31 * result2 + (this.myInitialized ? 1 : 0);
        result2 = 31 * result2 + (this.myValid ? 1 : 0);
        result2 = 31 * result2 + this.myPathMappings.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteSdkPropertiesHolder", "getPathMappings"));
    }
}

