/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GestureUtilities;
import com.apple.eawt.event.PressureEvent;
import com.apple.eawt.event.PressureListener;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class MacGestureSupportForEditor {
    private final ArrayList<AnAction> myActions = new ArrayList(1);
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public MacGestureSupportForEditor(final JComponent component2) {
        GestureUtilities.addGestureListenerTo((JComponent)component2, (GestureListener)new PressureListener(){

            public void pressure(PressureEvent e) {
                if (IdeMouseEventDispatcher.isForceTouchAllowed() && e.getStage() == 2.0) {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> MacGestureSupportForEditor.this.handleMouseShortcut(e, (MouseShortcut)new PressureShortcut(e.getStage()), component2));
                }
            }
        });
    }

    private void handleMouseShortcut(PressureEvent e, MouseShortcut shortcut, JComponent component2) {
        this.fillActionsList(shortcut, IdeKeyEventDispatcher.isModalContext(component2));
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (actionManager != null) {
            AnAction[] actions;
            for (AnAction action2 : actions = this.myActions.toArray(AnAction.EMPTY_ARRAY)) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)component2);
                Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
                AnActionEvent actionEvent = new AnActionEvent(null, dataContext, "force touch", presentation2, ActionManager.getInstance(), 0);
                action2.beforeActionPerformedUpdate(actionEvent);
                if (!presentation2.isEnabled()) continue;
                actionManager.fireBeforeActionPerformed(action2, dataContext, actionEvent);
                Component context = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                if (context != null && !context.isShowing()) continue;
                action2.actionPerformed(actionEvent);
            }
        }
        e.consume();
        IdeMouseEventDispatcher.forbidForceTouch();
    }

    private void fillActionsList(@NotNull MouseShortcut mouseShortcut, boolean isModalContext) {
        if (mouseShortcut == null) {
            MacGestureSupportForEditor.$$$reportNull$$$0(0);
        }
        this.myActions.clear();
        if (!KeymapManagerImpl.isKeymapManagerInitialized()) {
            return;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return;
        }
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        ActionManager actionManager = ActionManager.getInstance();
        for (String actionId : keymap2.getActionIds(mouseShortcut)) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null || isModalContext && !action2.isEnabledInModalContext() || this.myActions.contains(action2)) continue;
            this.myActions.add(action2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseShortcut", "com/intellij/ui/mac/MacGestureSupportForEditor", "fillActionsList"));
    }
}

