/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SubstitutedFileType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IndexedFileImpl
extends UserDataHolderBase
implements IndexedFile {
    protected final VirtualFile myFile;
    protected final String myFileName;
    private volatile Project myProject;
    private FileType mySubstituteFileType;
    @NotNull
    private final FileType myType;

    public IndexedFileImpl(@NotNull VirtualFile file2, Project project) {
        if (file2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(0);
        }
        this(file2, file2.getFileType(), project);
    }

    public IndexedFileImpl(@NotNull VirtualFile file2, @NotNull FileType type, Project project) {
        if (file2 == null) {
            IndexedFileImpl.$$$reportNull$$$0(1);
        }
        if (type == null) {
            IndexedFileImpl.$$$reportNull$$$0(2);
        }
        this.myFile = file2;
        this.myFileName = file2.getName();
        this.myProject = project;
        this.myType = type;
    }

    @NotNull
    public FileType getFileType() {
        if (this.mySubstituteFileType == null) {
            this.mySubstituteFileType = SubstitutedFileType.substituteFileType(this.myFile, this.myType, this.getProject());
        }
        FileType fileType = this.mySubstituteFileType;
        if (fileType == null) {
            IndexedFileImpl.$$$reportNull$$$0(3);
        }
        return fileType;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            IndexedFileImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            IndexedFileImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return "IndexedFileImpl(" + this.getFileName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/IndexedFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/IndexedFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

