/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\bH\u0016J\r\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\rH\u0016J\r\u0010\u000e\u001a\u00070\b\u00a2\u0006\u0002\b\rH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/indexing/roots/SdkIndexableFilesProvider;", "Lcom/intellij/util/indexing/roots/IndexableFilesProvider;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "sdkPresentableName", "", "getSdkPresentableName", "()Ljava/lang/String;", "getDebugName", "getIndexingProgressText", "Lorg/jetbrains/annotations/NotNull;", "getRootsScanningProgressText", "iterateFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "visitedFileSet", "Lcom/intellij/util/containers/ConcurrentBitSet;", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class SdkIndexableFilesProvider
implements IndexableFilesProvider {
    @NotNull
    private final Sdk sdk;

    @Override
    @NotNull
    public String getDebugName() {
        return this.getSdkPresentableName() + ' ' + this.sdk.getName();
    }

    private final String getSdkPresentableName() {
        SdkTypeId sdkTypeId = this.sdk.getSdkType();
        if (!(sdkTypeId instanceof SdkType)) {
            sdkTypeId = null;
        }
        SdkType sdkType = (SdkType)sdkTypeId;
        String string = sdkType != null ? sdkType.getPresentableName() : null;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        boolean bl5 = false;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            String string3 = IndexingBundle.message((String)"indexable.files.provider.indexing.sdk.unnamed", (Object[])new Object[0]);
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"IndexingBundle.message(\"\u2026er.indexing.sdk.unnamed\")");
        }
        return string2;
    }

    @Override
    @NotNull
    public String getIndexingProgressText() {
        String string = IndexingBundle.message((String)"indexable.files.provider.indexing.sdk", (Object[])new Object[]{this.getSdkPresentableName(), this.sdk.getName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexingBundle.message(\"\u2026resentableName, sdk.name)");
        return string;
    }

    @Override
    @NotNull
    public String getRootsScanningProgressText() {
        String string = IndexingBundle.message((String)"indexable.files.provider.scanning.sdk", (Object[])new Object[]{this.getSdkPresentableName(), this.sdk.getName()});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IndexingBundle.message(\"\u2026                sdk.name)");
        return string;
    }

    @Override
    public boolean iterateFiles(@NotNull Project project, @NotNull ContentIterator fileIterator, @NotNull ConcurrentBitSet visitedFileSet) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkParameterIsNotNull((Object)visitedFileSet, (String)"visitedFileSet");
        boolean $i$f$runReadAction = false;
        List roots = (List)ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
            final /* synthetic */ SdkIndexableFilesProvider this$0;
            {
                this.this$0 = sdkIndexableFilesProvider;
            }

            public final T compute() {
                boolean bl = false;
                RootProvider rootProvider = this.this$0.getSdk().getRootProvider();
                Intrinsics.checkExpressionValueIsNotNull((Object)rootProvider, (String)"sdk.rootProvider");
                RootProvider rootProvider2 = rootProvider;
                Object[] objectArray = rootProvider2.getFiles(OrderRootType.SOURCES);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
                Collection collection = ArraysKt.toList((Object[])objectArray);
                Object[] objectArray2 = rootProvider2.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray2, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
                return (T)CollectionsKt.plus((Collection)collection, (Object[])objectArray2);
            }
        });
        return IndexableFilesIterationMethods.INSTANCE.iterateNonExcludedRoots(project, roots, fileIterator, visitedFileSet);
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    public SdkIndexableFilesProvider(@NotNull Sdk sdk2) {
        Intrinsics.checkParameterIsNotNull((Object)sdk2, (String)"sdk");
        this.sdk = sdk2;
    }
}

