/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBoxListModelEditor<T> {
    private final CheckBoxList<T> list;
    private final ToolbarDecorator toolbarDecorator;
    private final Function<? super T, String> toNameConverter;

    public CheckBoxListModelEditor(@NotNull Function<? super T, String> toNameConverter, @NotNull String emptyText) {
        if (toNameConverter == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(0);
        }
        if (emptyText == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(1);
        }
        this.toNameConverter = toNameConverter;
        this.list = new CheckBoxList();
        this.list.setEmptyText(emptyText);
        this.list.setBorder(null);
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.list);
    }

    @NotNull
    public CheckBoxListModelEditor<T> editAction(@NotNull Function<? super T, ? extends T> consumer) {
        if (consumer == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(2);
        }
        final Runnable action2 = () -> {
            T item = this.getSelectedItem();
            if (item != null) {
                Object newItem = consumer.fun(item);
                if (newItem != null) {
                    this.list.updateItem(item, newItem, StringUtil.notNullize((String)((String)this.toNameConverter.fun(newItem))));
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.list, true));
            }
        };
        this.toolbarDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                action2.run();
            }
        });
        EditSourceOnDoubleClickHandler.install(this.list, (Runnable)action2);
        CheckBoxListModelEditor checkBoxListModelEditor = this;
        if (checkBoxListModelEditor == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(3);
        }
        return checkBoxListModelEditor;
    }

    @NotNull
    public CheckBoxListModelEditor<T> copyAction(final @NotNull Consumer<? super T> consumer) {
        if (consumer == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(4);
        }
        this.toolbarDecorator.addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int[] indices;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((indices = CheckBoxListModelEditor.this.list.getSelectedIndices()) == null || indices.length == 0) {
                    return;
                }
                for (int index : indices) {
                    Object item = CheckBoxListModelEditor.this.list.getItemAt(index);
                    if (item == null) continue;
                    consumer.consume(item);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/CheckBoxListModelEditor$2", "actionPerformed"));
            }
        });
        CheckBoxListModelEditor checkBoxListModelEditor = this;
        if (checkBoxListModelEditor == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(5);
        }
        return checkBoxListModelEditor;
    }

    public ToolbarDecorator getToolbar() {
        return this.toolbarDecorator;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel2 = this.toolbarDecorator.createPanel();
        if (jPanel2 == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(6);
        }
        return jPanel2;
    }

    @NotNull
    public DefaultListModel getModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        if (defaultListModel == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(7);
        }
        return defaultListModel;
    }

    public void selectItemByName(@NotNull String name) {
        if (name == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(8);
        }
        for (int i2 = 0; i2 < this.list.getItemsCount(); ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null || !name.equalsIgnoreCase((String)this.toNameConverter.fun(item))) continue;
            this.list.setSelectedIndex(i2);
        }
    }

    @Nullable
    private T getSelectedItem() {
        int index = this.list.getSelectedIndex();
        return (T)(index == -1 ? null : this.list.getItemAt(index));
    }

    public CheckBoxList<T> getList() {
        return this.list;
    }

    public void reset(@NotNull List<? extends Pair<T, Boolean>> items) {
        if (items == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(9);
        }
        this.list.clear();
        for (Pair<T, Boolean> item : items) {
            this.list.addItem(item.first, (String)this.toNameConverter.fun(item.first), ((Boolean)item.second).booleanValue());
        }
    }

    public boolean isModified(@NotNull List<? extends Pair<T, Boolean>> oldItems) {
        if (oldItems == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(10);
        }
        if (oldItems.size() != this.list.getItemsCount()) {
            return true;
        }
        for (int i2 = 0; i2 < this.list.getItemsCount(); ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null) {
                return true;
            }
            Pair<T, Boolean> oldItem = oldItems.get(i2);
            if (((Boolean)oldItem.second).booleanValue() == this.list.isItemSelected(i2) && oldItem.first.equals(item)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<T> getItems() {
        int count = this.list.getItemsCount();
        ArrayList<Object> result2 = new ArrayList<Object>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null) continue;
            result2.add(item);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<T, Boolean>> apply() {
        int count = this.list.getItemsCount();
        ArrayList<Pair<T, Boolean>> result2 = new ArrayList<Pair<T, Boolean>>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null) continue;
            result2.add(Pair.create((Object)item, (Object)this.list.isItemSelected(i2)));
        }
        ArrayList<Pair<T, Boolean>> arrayList = result2;
        if (arrayList == null) {
            CheckBoxListModelEditor.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNameConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/CheckBoxListModelEditor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/CheckBoxListModelEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "editAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "editAction";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectItemByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

