/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootManagerBridge;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChanged;
import com.intellij.workspaceModel.storage.bridgeEntities.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.CustomSourceRootPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaModuleSettingsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaResourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryPropertiesEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleCustomImlDataEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleGroupPathEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/project/ProjectRootsChangeListener;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "beforeChanged", "", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChanged;", "changed", "libraryHasOrderEntry", "", "library", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "shouldFireRootsChanged", "events", "intellij.platform.workspaceModel.ide"})
public final class ProjectRootsChangeListener {
    private final Project project;

    public final void beforeChanged(@NotNull VersionedStorageChanged event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.project.isDisposed() || Disposer.isDisposing((Disposable)((Disposable)this.project))) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate) {
            ((ProjectRootManagerBridge)projectRootManager).fireRootsChanged$intellij_platform_workspaceModel_ide(true);
        }
    }

    public final void changed(@NotNull VersionedStorageChanged event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.project.isDisposed() || Disposer.isDisposing((Disposable)((Disposable)this.project))) {
            return;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        if (!(projectRootManager instanceof ProjectRootManagerBridge)) {
            return;
        }
        boolean performUpdate = this.shouldFireRootsChanged(event, this.project);
        if (performUpdate) {
            ((ProjectRootManagerBridge)projectRootManager).fireRootsChanged$intellij_platform_workspaceModel_ide(false);
        }
    }

    private final boolean shouldFireRootsChanged(VersionedStorageChanged events, Project project) {
        boolean bl;
        block7: {
            Sequence<EntityChange<?>> $this$any$iv = events.getAllChanges();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Object t;
                EntityChange it = (EntityChange)element$iv;
                boolean bl2 = false;
                EntityChange entityChange = it;
                if (entityChange instanceof EntityChange.Added) {
                    t = ((EntityChange.Added)it).getEntity();
                } else if (entityChange instanceof EntityChange.Removed) {
                    t = ((EntityChange.Removed)it).getEntity();
                } else if (entityChange instanceof EntityChange.Replaced) {
                    t = ((EntityChange.Replaced)it).getNewEntity();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Object entity = t;
                entityChange = entity;
                boolean bl3 = entityChange instanceof LibraryEntity ? this.libraryHasOrderEntry((LibraryEntity)entity, project) : (entityChange instanceof LibraryPropertiesEntity ? this.libraryHasOrderEntry(((LibraryPropertiesEntity)entity).getLibrary(), project) : entityChange instanceof ModuleEntity || entityChange instanceof JavaModuleSettingsEntity || entityChange instanceof ModuleCustomImlDataEntity || entityChange instanceof ModuleGroupPathEntity || entityChange instanceof SourceRootEntity || entityChange instanceof JavaSourceRootEntity || entityChange instanceof JavaResourceRootEntity || entityChange instanceof CustomSourceRootPropertiesEntity || entityChange instanceof ContentRootEntity);
                if (!bl3) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean libraryHasOrderEntry(LibraryEntity library, Project project) {
        if (library.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) {
            return true;
        }
        String libraryName = library.getName();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$forEach$iv = moduleArray;
        boolean $i$f$forEach = false;
        Module[] moduleArray2 = $this$forEach$iv;
        int n = moduleArray2.length;
        for (int j = 0; j < n; ++j) {
            boolean exists;
            block3: {
                boolean bl;
                OrderEntry[] $this$any$iv;
                Module element$iv;
                Module module = element$iv = moduleArray2[j];
                boolean bl2 = false;
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager.getOrderEntries(), (String)"ModuleRootManager.getInstance(module).orderEntries");
                boolean $i$f$any = false;
                OrderEntry[] orderEntryArray = $this$any$iv;
                int n2 = orderEntryArray.length;
                for (int k = 0; k < n2; ++k) {
                    OrderEntry element$iv2;
                    OrderEntry it = element$iv2 = orderEntryArray[k];
                    boolean bl3 = false;
                    if (!(it instanceof LibraryOrderEntry && Intrinsics.areEqual((Object)((LibraryOrderEntry)it).getLibraryName(), (Object)libraryName))) continue;
                    bl = true;
                    break block3;
                }
                bl = exists = false;
            }
            if (!exists) continue;
            return true;
        }
        return false;
    }

    public ProjectRootsChangeListener(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

