/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NotNull;

public class InjectedReferencesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InjectedReferencesInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                PsiReference[] injected;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((injected = InjectedReferencesContributor.getInjectedReferences(element)) != null) {
                    for (PsiReference reference : injected) {
                        if (reference.resolve() != null) continue;
                        TextRange range = reference.getRangeInElement();
                        if (range.isEmpty() && range.getStartOffset() == 1 && "\"\"".equals(element.getText())) {
                            String message = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
                            holder.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                            continue;
                        }
                        holder.registerProblem(reference);
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/intelliLang/references/InjectedReferencesInspection$1", "visitElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/intelliLang/references/InjectedReferencesInspection", "buildVisitor"));
    }
}

