/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.google.common.collect.Ordering;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PyImportOptimizer
implements ImportOptimizer {
    private static final Logger LOG = Logger.getInstance(PyImportOptimizer.class);
    private boolean mySortImports = true;

    @NotNull
    public static PyImportOptimizer onlyRemoveUnused() {
        PyImportOptimizer optimizer = new PyImportOptimizer();
        optimizer.mySortImports = false;
        PyImportOptimizer pyImportOptimizer = optimizer;
        if (pyImportOptimizer == null) {
            PyImportOptimizer.$$$reportNull$$$0(0);
        }
        return pyImportOptimizer;
    }

    public boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            PyImportOptimizer.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            PyImportOptimizer.$$$reportNull$$$0(2);
        }
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, 0, file.getTextLength());
        final PyUnresolvedReferencesInspection.Visitor visitor2 = new PyUnresolvedReferencesInspection.Visitor(null, session, Collections.emptyList());
        session.putUserData(PyUnresolvedReferencesVisitor.INSPECTION, (Object)new PyUnresolvedReferencesInspection());
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(node);
                node.accept((PsiElementVisitor)visitor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$1", "visitElement"));
            }
        });
        Runnable runnable = () -> {
            LOG.debug(String.format("----------------- OPTIMIZE IMPORTS STARTED (%s) -----------------", file.getVirtualFile()));
            visitor2.optimizeImports();
            if (this.mySortImports && file instanceof PyFile) {
                new ImportSorter((PyFile)file).run();
            }
            LOG.debug("----------------- OPTIMIZE IMPORTS FINISHED -----------------");
        };
        if (runnable == null) {
            PyImportOptimizer.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyRemoveUnused";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImportSorter {
        private final PyFile myFile;
        private final PyCodeStyleSettings myPySettings;
        private final List<PyImportStatementBase> myImportBlock;
        private final Map<AddImportHelper.ImportPriority, List<PyImportStatementBase>> myGroups;
        private final MultiMap<PyImportStatementBase, PsiComment> myOldImportToLineComments;
        private final MultiMap<PyImportStatementBase, PsiComment> myOldImportToInnerComments;
        private final MultiMap<String, PyFromImportStatement> myOldFromImportBySources;
        private final MultiMap<PyImportStatementBase, PsiComment> myNewImportToLineComments;
        private final MultiMap<PyImportStatementBase, PsiComment> myNewImportToInnerComments;
        private final List<PsiComment> myDanglingComments;
        private final PyElementGenerator myGenerator;
        private final LanguageLevel myLangLevel;

        private ImportSorter(@NotNull PyFile file) {
            if (file == null) {
                ImportSorter.$$$reportNull$$$0(0);
            }
            this.myOldImportToLineComments = MultiMap.create();
            this.myOldImportToInnerComments = MultiMap.create();
            this.myOldFromImportBySources = MultiMap.create();
            this.myNewImportToLineComments = MultiMap.create();
            this.myNewImportToInnerComments = MultiMap.create();
            this.myDanglingComments = new ArrayList<PsiComment>();
            this.myFile = file;
            this.myPySettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.myFile, PyCodeStyleSettings.class);
            this.myImportBlock = this.myFile.getImportBlock();
            this.myGroups = new EnumMap<AddImportHelper.ImportPriority, List<PyImportStatementBase>>(AddImportHelper.ImportPriority.class);
            for (AddImportHelper.ImportPriority priority : AddImportHelper.ImportPriority.values()) {
                this.myGroups.put(priority, new ArrayList());
            }
            this.myGenerator = PyElementGenerator.getInstance(this.myFile.getProject());
            this.myLangLevel = LanguageLevel.forElement((PsiElement)this.myFile);
        }

        @NotNull
        private Comparator<PyImportElement> getFromNamesComparator() {
            Comparator<String> stringComparator = AddImportHelper.getImportTextComparator(this.myFile);
            Comparator<QualifiedName> qNamesComparator = Comparator.comparing(QualifiedName::toString, stringComparator);
            Comparator<PyImportElement> comparator = Comparator.comparing(PyImportElement::getImportedQName, Comparator.nullsFirst(qNamesComparator)).thenComparing(PyImportElement::getAsName, Comparator.nullsFirst(stringComparator));
            if (comparator == null) {
                ImportSorter.$$$reportNull$$$0(1);
            }
            return comparator;
        }

        public void run() {
            if (this.myImportBlock.isEmpty()) {
                return;
            }
            this.analyzeImports(this.myImportBlock);
            for (PyImportStatementBase importStatement : this.myImportBlock) {
                AddImportHelper.ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importStatement);
                LOG.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importStatement.getText(), choice.getPriority(), choice.getDescription()}));
                this.myGroups.get((Object)choice.getPriority()).add(importStatement);
            }
            boolean hasTransformedImports = false;
            for (AddImportHelper.ImportPriority priority : AddImportHelper.ImportPriority.values()) {
                List<PyImportStatementBase> transformed;
                List<PyImportStatementBase> original = this.myGroups.get((Object)priority);
                hasTransformedImports |= !original.equals(transformed = this.transformImportsInGroup(original));
                this.myGroups.put(priority, transformed);
            }
            if (hasTransformedImports || this.needBlankLinesBetweenGroups() || this.groupsNotSorted()) {
                this.applyResults();
            }
        }

        private void analyzeImports(@NotNull List<PyImportStatementBase> imports) {
            if (imports == null) {
                ImportSorter.$$$reportNull$$$0(2);
            }
            for (PyImportStatementBase statement : imports) {
                PyFromImportStatement fromImport = PyUtil.as(statement, PyFromImportStatement.class);
                if (fromImport != null && !fromImport.isStarImport()) {
                    this.myOldFromImportBySources.putValue((Object)ImportSorter.getNormalizedFromImportSource(fromImport), (Object)fromImport);
                }
                Couple<List<PsiComment>> boundAndOthers = ImportSorter.collectPrecedingLineComments(statement);
                this.myOldImportToLineComments.putValues((Object)statement, (Collection)boundAndOthers.getFirst());
                if (statement != this.myImportBlock.get(0)) {
                    this.myDanglingComments.addAll((Collection)boundAndOthers.getSecond());
                }
                this.myOldImportToInnerComments.putValues((Object)statement, PsiTreeUtil.collectElementsOfType((PsiElement)statement, (Class[])new Class[]{PsiComment.class}));
            }
        }

        @NotNull
        private List<PyImportStatementBase> transformImportsInGroup(@NotNull List<PyImportStatementBase> imports) {
            if (imports == null) {
                ImportSorter.$$$reportNull$$$0(3);
            }
            ArrayList<PyImportStatementBase> result = new ArrayList<PyImportStatementBase>();
            for (PyImportStatementBase statement : imports) {
                if (statement instanceof PyImportStatement) {
                    this.transformPlainImport(result, (PyImportStatement)statement);
                    continue;
                }
                if (!(statement instanceof PyFromImportStatement)) continue;
                this.transformFromImport(result, (PyFromImportStatement)statement);
            }
            ArrayList<PyImportStatementBase> arrayList = result;
            if (arrayList == null) {
                ImportSorter.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private void transformPlainImport(@NotNull List<PyImportStatementBase> result, @NotNull PyImportStatement importStatement) {
            Object[] importElements;
            if (result == null) {
                ImportSorter.$$$reportNull$$$0(5);
            }
            if (importStatement == null) {
                ImportSorter.$$$reportNull$$$0(6);
            }
            if ((importElements = importStatement.getImportElements()).length > 1) {
                List newImports = ContainerUtil.map((Object[])importElements, e -> this.myGenerator.createImportStatement(this.myLangLevel, e.getText(), null));
                this.replaceOneImportWithSeveral(result, importStatement, newImports);
            } else {
                this.addImportAsIs(result, importStatement);
            }
        }

        private void transformFromImport(@NotNull List<PyImportStatementBase> result, @NotNull PyFromImportStatement fromImport) {
            boolean shouldGenerateNewFromImport;
            boolean shouldSplitImport;
            if (result == null) {
                ImportSorter.$$$reportNull$$$0(7);
            }
            if (fromImport == null) {
                ImportSorter.$$$reportNull$$$0(8);
            }
            if (fromImport.isStarImport()) {
                this.addImportAsIs(result, fromImport);
                return;
            }
            String source = ImportSorter.getNormalizedFromImportSource(fromImport);
            Object[] importedFromNames = fromImport.getImportElements();
            ArrayList<PyImportElement> newFromImportNames = new ArrayList<PyImportElement>();
            Comparator<PyImportElement> fromNamesComparator = this.getFromNamesComparator();
            Collection sameSourceImports = this.myOldFromImportBySources.get((Object)source);
            if (sameSourceImports.isEmpty()) {
                return;
            }
            boolean forceParentheses = sameSourceImports.size() == 1 && fromImport.getLeftParen() != null;
            boolean shouldJoinImports = this.myPySettings.OPTIMIZE_IMPORTS_JOIN_FROM_IMPORTS_WITH_SAME_SOURCE && sameSourceImports.size() > 1;
            boolean bl = shouldSplitImport = this.myPySettings.OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS && importedFromNames.length > 1;
            if (shouldJoinImports) {
                for (PyFromImportStatement sameSourceImport : sameSourceImports) {
                    ContainerUtil.addAll(newFromImportNames, (Object[])sameSourceImport.getImportElements());
                }
                this.myOldFromImportBySources.remove((Object)source);
            } else if (!shouldSplitImport && this.myPySettings.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS && !Ordering.from(fromNamesComparator).isOrdered(Arrays.asList(importedFromNames))) {
                ContainerUtil.addAll(newFromImportNames, (Object[])importedFromNames);
            }
            boolean bl2 = shouldGenerateNewFromImport = !newFromImportNames.isEmpty();
            if (shouldGenerateNewFromImport) {
                if (this.myPySettings.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS) {
                    newFromImportNames.sort(fromNamesComparator);
                }
                String importedNames = StringUtil.join(newFromImportNames, ImportSorter::getNormalizedImportElementText, (String)", ");
                if (forceParentheses) {
                    importedNames = "(" + importedNames + ")";
                }
                PyFromImportStatement combinedImport = this.myGenerator.createFromImportStatement(this.myLangLevel, source, importedNames, null);
                Set oldImports = ContainerUtil.map2LinkedSet(newFromImportNames, e -> (PyImportStatementBase)e.getParent());
                this.replaceSeveralImportsWithOne(result, oldImports, combinedImport);
            } else if (shouldSplitImport) {
                List newFromImports = ContainerUtil.map((Object[])importedFromNames, importElem -> {
                    String name = Objects.toString(importElem.getImportedQName(), "");
                    String alias = importElem.getAsName();
                    return this.myGenerator.createFromImportStatement(this.myLangLevel, source, name, alias);
                });
                this.replaceOneImportWithSeveral(result, fromImport, newFromImports);
            } else {
                this.addImportAsIs(result, fromImport);
            }
        }

        private void replaceSeveralImportsWithOne(@NotNull List<PyImportStatementBase> result, @NotNull Collection<? extends PyImportStatementBase> oldImports, @NotNull PyFromImportStatement newImport) {
            if (result == null) {
                ImportSorter.$$$reportNull$$$0(9);
            }
            if (oldImports == null) {
                ImportSorter.$$$reportNull$$$0(10);
            }
            if (newImport == null) {
                ImportSorter.$$$reportNull$$$0(11);
            }
            for (PyImportStatementBase pyImportStatementBase : oldImports) {
                this.myNewImportToLineComments.putValues((Object)newImport, this.myOldImportToLineComments.get((Object)pyImportStatementBase));
                this.myNewImportToInnerComments.putValues((Object)newImport, this.myOldImportToInnerComments.get((Object)pyImportStatementBase));
            }
            result.add(newImport);
        }

        private void replaceOneImportWithSeveral(@NotNull List<PyImportStatementBase> result, @NotNull PyImportStatementBase oldImport, @NotNull Collection<? extends PyImportStatementBase> newImports) {
            if (result == null) {
                ImportSorter.$$$reportNull$$$0(12);
            }
            if (oldImport == null) {
                ImportSorter.$$$reportNull$$$0(13);
            }
            if (newImports == null) {
                ImportSorter.$$$reportNull$$$0(14);
            }
            PyImportStatementBase topmostImport = this.myPySettings.OPTIMIZE_IMPORTS_SORT_IMPORTS ? Collections.min(newImports, AddImportHelper.getSameGroupImportsComparator(this.myFile)) : (PyImportStatementBase)ContainerUtil.getFirstItem(newImports);
            this.myNewImportToLineComments.putValues((Object)topmostImport, this.myOldImportToLineComments.get((Object)oldImport));
            this.myNewImportToInnerComments.putValues((Object)topmostImport, this.myOldImportToInnerComments.get((Object)oldImport));
            result.addAll(newImports);
        }

        private void addImportAsIs(@NotNull List<PyImportStatementBase> result, @NotNull PyImportStatementBase oldImport) {
            if (result == null) {
                ImportSorter.$$$reportNull$$$0(15);
            }
            if (oldImport == null) {
                ImportSorter.$$$reportNull$$$0(16);
            }
            this.myNewImportToLineComments.putValues((Object)oldImport, this.myOldImportToLineComments.get((Object)oldImport));
            result.add(oldImport);
        }

        @NotNull
        private static String getNormalizedImportElementText(@NotNull PyImportElement element) {
            if (element == null) {
                ImportSorter.$$$reportNull$$$0(17);
            }
            String string = element.getText().replaceAll("#.*", "").replaceAll("[\\s\\\\]+", " ");
            if (string == null) {
                ImportSorter.$$$reportNull$$$0(18);
            }
            return string;
        }

        @NotNull
        private static Couple<List<PsiComment>> collectPrecedingLineComments(@NotNull PyImportStatementBase statement) {
            List<PsiComment> boundComments;
            PsiComment firstComment;
            if (statement == null) {
                ImportSorter.$$$reportNull$$$0(19);
            }
            if ((firstComment = (PsiComment)ContainerUtil.getFirstItem(boundComments = PyPsiUtils.getPrecedingComments((PsiElement)statement, true))) != null && ImportSorter.isFirstInFile((PsiElement)firstComment)) {
                Couple couple = Couple.of(Collections.emptyList(), boundComments);
                if (couple == null) {
                    ImportSorter.$$$reportNull$$$0(20);
                }
                return couple;
            }
            List<PsiComment> remainingComments = PyPsiUtils.getPrecedingComments((PsiElement)ObjectUtils.notNull((Object)firstComment, (Object)statement), false);
            Couple couple = Couple.of(boundComments, remainingComments);
            if (couple == null) {
                ImportSorter.$$$reportNull$$$0(21);
            }
            return couple;
        }

        private static boolean isFirstInFile(@NotNull PsiElement element) {
            if (element == null) {
                ImportSorter.$$$reportNull$$$0(22);
            }
            if (element.getTextRange().getStartOffset() == 0) {
                return true;
            }
            PsiWhiteSpace prevWhitespace = PyUtil.as(PsiTreeUtil.prevLeaf((PsiElement)element), PsiWhiteSpace.class);
            return prevWhitespace != null && prevWhitespace.getTextRange().getStartOffset() == 0;
        }

        @NotNull
        public static String getNormalizedFromImportSource(@NotNull PyFromImportStatement statement) {
            if (statement == null) {
                ImportSorter.$$$reportNull$$$0(23);
            }
            String string = StringUtil.repeatSymbol((char)'.', (int)statement.getRelativeLevel()) + Objects.toString(statement.getImportSourceQName(), "");
            if (string == null) {
                ImportSorter.$$$reportNull$$$0(24);
            }
            return string;
        }

        private boolean groupsNotSorted() {
            if (!this.myPySettings.OPTIMIZE_IMPORTS_SORT_IMPORTS) {
                return false;
            }
            Ordering importOrdering = Ordering.from(AddImportHelper.getSameGroupImportsComparator(this.myFile));
            return ContainerUtil.exists(this.myGroups.values(), imports -> !importOrdering.isOrdered((Iterable)imports));
        }

        private boolean needBlankLinesBetweenGroups() {
            return ((StreamEx)StreamEx.of(this.myGroups.values()).remove(List::isEmpty)).count() > 1L;
        }

        private void applyResults() {
            PyImportStatementBase firstImport;
            List boundComments;
            if (this.myPySettings.OPTIMIZE_IMPORTS_SORT_IMPORTS) {
                for (AddImportHelper.ImportPriority priority : this.myGroups.keySet()) {
                    List<PyImportStatementBase> imports = this.myGroups.get((Object)priority);
                    imports.sort(AddImportHelper.getSameGroupImportsComparator(this.myFile));
                    this.myGroups.put(priority, imports);
                }
            }
            PyImportStatementBase firstElementToRemove = (boundComments = (List)ImportSorter.collectPrecedingLineComments(firstImport = this.myImportBlock.get(0)).getFirst()).isEmpty() ? firstImport : (PsiElement)boundComments.get(0);
            PyImportStatementBase lastImport = (PyImportStatementBase)ContainerUtil.getLastItem(this.myImportBlock);
            assert (lastImport != null);
            this.addImportsAfter((PsiElement)lastImport);
            ImportSorter.deleteRangeThroughDocument((PsiElement)firstElementToRemove, PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)lastImport).getPrevSibling());
        }

        private void addImportsAfter(@NotNull PsiElement anchor) {
            if (anchor == null) {
                ImportSorter.$$$reportNull$$$0(25);
            }
            StringBuilder content2 = new StringBuilder();
            for (List<PyImportStatementBase> imports : this.myGroups.values()) {
                if (content2.length() > 0 && !imports.isEmpty()) {
                    content2.append("\n");
                }
                for (PyImportStatementBase statement : imports) {
                    for (PsiComment comment2 : this.myNewImportToLineComments.get((Object)statement)) {
                        content2.append(comment2.getText()).append("\n");
                    }
                    content2.append(statement.getText());
                    Collection innerComments = this.myNewImportToInnerComments.get((Object)statement);
                    if (!innerComments.isEmpty()) {
                        content2.append("  # ");
                        String combinedComment = StringUtil.join((Collection)innerComments, comment -> comment.getText().substring(1).trim(), (String)"; ");
                        content2.append(combinedComment).append("\n");
                        continue;
                    }
                    content2.append("\n");
                }
            }
            if (!this.myDanglingComments.isEmpty()) {
                content2.append("\n");
                for (PsiComment comment3 : this.myDanglingComments) {
                    content2.append(comment3.getText()).append("\n");
                }
            }
            Project project = anchor.getProject();
            PyFile file = (PyFile)this.myGenerator.createDummyFile(this.myLangLevel, content2.toString());
            PyFile reformattedFile = (PyFile)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
            List<PyImportStatementBase> newImportBlock = reformattedFile.getImportBlock();
            assert (newImportBlock != null);
            this.myFile.addRangeAfter(reformattedFile.getFirstChild(), reformattedFile.getLastChild(), anchor);
        }

        private static void deleteRangeThroughDocument(@NotNull PsiElement first, @NotNull PsiElement last) {
            if (first == null) {
                ImportSorter.$$$reportNull$$$0(26);
            }
            if (last == null) {
                ImportSorter.$$$reportNull$$$0(27);
            }
            PyUtil.updateDocumentUnblockedAndCommitted(first, (Consumer<? super Document>)((Consumer)document -> document.deleteString(first.getTextRange().getStartOffset(), last.getTextRange().getEndOffset())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$ImportSorter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importStatement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromImport";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldImports";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newImport";
                    break;
                }
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldImport";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newImports";
                    break;
                }
                case 17: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$ImportSorter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFromNamesComparator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformImportsInGroup";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedImportElementText";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectPrecedingLineComments";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedFromImportSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeImports";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "transformImportsInGroup";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "transformPlainImport";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "transformFromImport";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceSeveralImportsWithOne";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceOneImportWithSeveral";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportAsIs";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedImportElementText";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "collectPrecedingLineComments";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstInFile";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedFromImportSource";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsAfter";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRangeThroughDocument";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

