/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class HighlightingAnnotator
extends PyAnnotator {
    public static final HighlightSeverity LOW_PRIORITY_HIGHLIGHTING = new HighlightSeverity("LOW_PRIORITY_HIGHLIGHTING", HighlightSeverity.INFORMATION.myVal - 3);

    @Override
    public void visitPyParameter(PyParameter node) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
        if (function != null) {
            TextAttributesKey attrKey;
            TextAttributesKey textAttributesKey = attrKey = node.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER;
            if (HighlightingAnnotator.isArgOrKwargParameter(node)) {
                this.addHighlightingAnnotation((PsiElement)node, attrKey);
            } else {
                this.addHighlightingAnnotation(node.getFirstChild(), attrKey);
            }
        }
    }

    private static boolean isArgOrKwargParameter(PyParameter parameter) {
        if (parameter instanceof PyNamedParameter) {
            PyNamedParameter namedParameter = (PyNamedParameter)parameter;
            return namedParameter.isPositionalContainer() || namedParameter.isKeywordContainer();
        }
        return false;
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        PyNamedParameter element;
        PyFunction function;
        String referencedName = node.getReferencedName();
        if (!node.isQualified() && referencedName != null && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null && (element = function.getParameterList().findParameterByName(referencedName)) != null) {
            TextAttributesKey attrKey = element.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER;
            this.addHighlightingAnnotation((PsiElement)node, attrKey);
        }
    }

    @Override
    public void visitPyKeywordArgument(PyKeywordArgument node) {
        ASTNode keywordNode = node.getKeywordNode();
        if (keywordNode != null) {
            this.addHighlightingAnnotation(keywordNode, PyHighlighter.PY_KEYWORD_ARGUMENT);
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        if (node.getParent() instanceof PyDecorator) {
            return;
        }
        PyReferenceExpression callee = PyUtil.as(node.getCallee(), PyReferenceExpression.class);
        if (callee != null) {
            if (!callee.isQualified() && PyBuiltinCache.isInBuiltins(callee)) {
                return;
            }
            ASTNode functionName = callee.getNameElement();
            if (functionName != null) {
                TextAttributesKey attrKey = callee.isQualified() ? PyHighlighter.PY_METHOD_CALL : PyHighlighter.PY_FUNCTION_CALL;
                this.addHighlightingAnnotation(functionName, attrKey);
            }
        }
    }

    @Override
    public void visitPyAnnotation(PyAnnotation node) {
        PyExpression value = node.getValue();
        if (value != null) {
            this.addHighlightingAnnotation((PsiElement)value, PyHighlighter.PY_ANNOTATION, LOW_PRIORITY_HIGHLIGHTING);
        }
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            HighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (PyTokenTypes.EXPRESSION_KEYWORDS.contains(element.getNode().getElementType()) && PsiTreeUtil.getParentOfType((PsiElement)element, PyAnnotation.class) != null) {
            this.addHighlightingAnnotation(element, PyHighlighter.PY_KEYWORD);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/validation/HighlightingAnnotator", "visitElement"));
    }
}

