/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.syntax.InjectionNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;

class SyntaxNodeDescriptorImpl
implements MutableSyntaxNodeDescriptor {
    private static final Logger LOG = Logger.getInstance(SyntaxNodeDescriptor.class);
    private TIntObjectHashMap<SyntaxNodeDescriptor> myRepository = new TIntObjectHashMap();
    private Map<Constants.StringKey, CharSequence> myStringAttributes = new EnumMap<Constants.StringKey, CharSequence>(Constants.StringKey.class);
    private Map<Constants.CaptureKey, TIntObjectHashMap<CharSequence>> myCaptures = new EnumMap<Constants.CaptureKey, TIntObjectHashMap<CharSequence>>(Constants.CaptureKey.class);
    private List<SyntaxNodeDescriptor> myChildren = new ArrayList<SyntaxNodeDescriptor>();
    private List<InjectionNodeDescriptor> myInjections = new ArrayList<InjectionNodeDescriptor>();
    private final SyntaxNodeDescriptor myParentNode;
    private CharSequence myScopeName = null;

    SyntaxNodeDescriptorImpl(@Nullable SyntaxNodeDescriptor parentNode) {
        this.myParentNode = parentNode;
    }

    @Override
    public void setStringAttribute(@NotNull Constants.StringKey key, @Nullable CharSequence value) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myStringAttributes.put(key, value);
    }

    @Override
    @Nullable
    public CharSequence getStringAttribute(@NotNull Constants.StringKey key) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(1);
        }
        return this.myStringAttributes.get((Object)key);
    }

    @Override
    public void setCaptures(@NotNull Constants.CaptureKey key, @Nullable TIntObjectHashMap<CharSequence> captures) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(2);
        }
        this.myCaptures.put(key, captures);
    }

    @Override
    @Nullable
    public TIntObjectHashMap<CharSequence> getCaptures(@NotNull Constants.CaptureKey key) {
        if (key == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(3);
        }
        return this.myCaptures.get((Object)key);
    }

    @Override
    public void addChild(SyntaxNodeDescriptor descriptor) {
        this.myChildren.add(descriptor);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        List<SyntaxNodeDescriptor> list = this.myChildren;
        if (list == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void appendRepository(int ruleId, SyntaxNodeDescriptor descriptor) {
        this.myRepository.put(ruleId, (Object)descriptor);
    }

    @Override
    public void setScopeName(@NotNull CharSequence scopeName) {
        if (scopeName == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(5);
        }
        this.myScopeName = scopeName;
    }

    @Override
    public void compact() {
        this.myStringAttributes = PreferencesReadUtil.compactMap(this.myStringAttributes);
        this.myCaptures = PreferencesReadUtil.compactMap(this.myCaptures);
        this.myChildren = SyntaxNodeDescriptorImpl.compactList(this.myChildren);
        this.myInjections = SyntaxNodeDescriptorImpl.compactList(this.myInjections);
        this.myRepository = SyntaxNodeDescriptorImpl.compactMap(this.myRepository);
    }

    private static TIntObjectHashMap<SyntaxNodeDescriptor> compactMap(TIntObjectHashMap<SyntaxNodeDescriptor> map) {
        if (map.isEmpty()) {
            return null;
        }
        map.trimToSize();
        return map;
    }

    private static <T> List<T> compactList(List<T> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.get(0));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    @Override
    @NotNull
    public List<InjectionNodeDescriptor> getInjections() {
        List<InjectionNodeDescriptor> list = this.myInjections;
        if (list == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public void addInjection(@NotNull InjectionNodeDescriptor injection) {
        if (injection == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(7);
        }
        this.myInjections.add(injection);
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(int ruleId) {
        SyntaxNodeDescriptor syntaxNodeDescriptor;
        SyntaxNodeDescriptor syntaxNodeDescriptor2 = syntaxNodeDescriptor = this.myRepository != null ? (SyntaxNodeDescriptor)this.myRepository.get(ruleId) : null;
        if (syntaxNodeDescriptor == null && this.myParentNode != null) {
            SyntaxNodeDescriptor syntaxNodeDescriptor3 = this.myParentNode.findInRepository(ruleId);
            if (syntaxNodeDescriptor3 == null) {
                SyntaxNodeDescriptorImpl.$$$reportNull$$$0(8);
            }
            return syntaxNodeDescriptor3;
        }
        if (syntaxNodeDescriptor == null) {
            LOG.warn("Can't find repository " + ruleId);
            SyntaxNodeDescriptor syntaxNodeDescriptor4 = EMPTY_NODE;
            if (syntaxNodeDescriptor4 == null) {
                SyntaxNodeDescriptorImpl.$$$reportNull$$$0(9);
            }
            return syntaxNodeDescriptor4;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor5 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor5 == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(10);
        }
        return syntaxNodeDescriptor5;
    }

    @Override
    @NotNull
    public CharSequence getScopeName() {
        CharSequence charSequence = this.myScopeName;
        if (charSequence == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(11);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    public String toString() {
        CharSequence name = this.myStringAttributes.get((Object)Constants.StringKey.NAME);
        return name != null ? "Syntax rule: " + name : super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRepository";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setStringAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCaptures";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCaptures";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setScopeName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInjection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

