/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.internal.statistic.service.fus.StatisticsWhitelistGroupConditions;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseWhitelistStorage
implements WhitelistGroupRulesStorage {
    @NotNull
    protected final AtomicBoolean isWhiteListInitialized = new AtomicBoolean(false);

    protected BaseWhitelistStorage() {
    }

    @Override
    public boolean isUnreachableWhitelist() {
        return !this.isWhiteListInitialized.get();
    }

    @NotNull
    protected Map<String, EventGroupRules> createValidators(@Nullable EventLogBuild build2, @NotNull FUStatisticsWhiteListGroupsService.WLGroups groups) {
        if (groups == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(0);
        }
        Map<String, EventGroupRules> map = groups.groups.stream().filter(group -> StatisticsWhitelistGroupConditions.create((FUStatisticsWhiteListGroupsService.WLGroup)group).accepts(build2)).collect(Collectors.toMap(group -> group.id, group -> BaseWhitelistStorage.createRules(group, groups.rules)));
        if (map == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    protected static EventGroupRules createRules(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable FUStatisticsWhiteListGroupsService.WLRule globalRules) {
        if (group == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(2);
        }
        EventGroupRules eventGroupRules = globalRules != null ? EventGroupRules.create(group, globalRules.enums, globalRules.regexps) : EventGroupRules.create(group, null, null);
        if (eventGroupRules == null) {
            BaseWhitelistStorage.$$$reportNull$$$0(3);
        }
        return eventGroupRules;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/whitelist/BaseWhitelistStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/whitelist/BaseWhitelistStorage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidators";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createValidators";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

