/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import git4idea.config.DefaultExecutableProblemHandler;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitExecutableProblemHandler;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVersion;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u001f\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\t2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\b\u0010\u0015\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\b\u0010\u0017\u001a\u00020\u0005H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0005*\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"findGitExecutableProblemHandler", "Lgit4idea/config/GitExecutableProblemHandler;", "project", "Lcom/intellij/openapi/project/Project;", "getErrorMessage", "", "text", "description", "getErrorTitle", "Lorg/jetbrains/annotations/NotNull;", "getHumanReadableErrorFor", "exception", "", "getLinkToConfigure", "Lgit4idea/config/ErrorNotifier$FixOption;", "showUnsupportedVersionError", "", "version", "Lgit4idea/config/GitVersion;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "unsupportedVersionDescription", "unsupportedVersionMessage", "unsupportedWslVersionDescription", "dumpToString", "Lcom/intellij/execution/process/ProcessOutput;", "intellij.vcs.git"})
public final class GitExecutableProblemHandlersKt {
    @NotNull
    public static final GitExecutableProblemHandler findGitExecutableProblemHandler(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return SystemInfo.isWindows ? (GitExecutableProblemHandler)new WindowsExecutableProblemHandler(project) : (SystemInfo.isMac ? (GitExecutableProblemHandler)new MacExecutableProblemHandler(project) : (GitExecutableProblemHandler)new DefaultExecutableProblemHandler(project));
    }

    public static final void showUnsupportedVersionError(@NotNull Project project, @NotNull GitVersion version, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)errorNotifier, (String)"errorNotifier");
        String description = version.getType() == GitVersion.Type.WSL1 ? GitExecutableProblemHandlersKt.unsupportedWslVersionDescription() : GitExecutableProblemHandlersKt.unsupportedVersionDescription();
        errorNotifier.showError(GitExecutableProblemHandlersKt.unsupportedVersionMessage(version), description, GitExecutableProblemHandlersKt.getLinkToConfigure(project));
    }

    @NotNull
    public static final String unsupportedVersionMessage(@NotNull GitVersion version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        String string = GitBundle.message("git.executable.validation.error.version.title", version.getPresentation());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.message(\"git.e\u2026e\", version.presentation)");
        return string;
    }

    @NotNull
    public static final String unsupportedVersionDescription() {
        Object[] objectArray = new Object[1];
        GitVersion gitVersion = GitVersion.MIN;
        Intrinsics.checkExpressionValueIsNotNull((Object)gitVersion, (String)"GitVersion.MIN");
        objectArray[0] = gitVersion.getPresentation();
        String string = GitBundle.message("git.executable.validation.error.version.message", objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.message(\"git.e\u2026Version.MIN.presentation)");
        return string;
    }

    @NotNull
    public static final String unsupportedWslVersionDescription() {
        String string = GitBundle.message("git.executable.validation.error.wsl1.unsupported.message", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"GitBundle.message(\"git.e\u2026sl1.unsupported.message\")");
        return string;
    }

    @NotNull
    public static final ErrorNotifier.FixOption getLinkToConfigure(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return new ErrorNotifier.FixOption.Configure(project);
    }

    @NotNull
    public static final String dumpToString(@NotNull ProcessOutput $this$dumpToString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$dumpToString, (String)"$this$dumpToString");
        return "output: " + $this$dumpToString.getStdout() + ", error output: " + $this$dumpToString.getStderr();
    }

    @NotNull
    public static final String getErrorTitle(@NotNull String text, @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String string = description == null ? GitBundle.getString("git.executable.validation.error.start.title") : text;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (description == null)\u2026r.start.title\") else text");
        return string;
    }

    @NotNull
    public static final String getErrorMessage(@NotNull String text, @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String string = description;
        if (string == null) {
            string = text;
        }
        return string;
    }

    @Nullable
    public static final String getHumanReadableErrorFor(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (exception instanceof GitNotInstalledException) {
            return null;
        }
        return GitExecutableProblemsNotifier.getPrettyErrorMessage(exception);
    }
}

