/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitFileStatusNodeProducerBase;
import git4idea.index.GitStageDiffUtilKt$WhenMappings;
import git4idea.index.MergedProducer;
import git4idea.index.StagedProducer;
import git4idea.index.ThreeSidesProducer;
import git4idea.index.UnStagedProducer;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileCache;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"createThreeSidesDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "project", "Lcom/intellij/openapi/project/Project;", "statusNode", "Lgit4idea/index/ui/GitFileStatusNode;", "createTwoSidesDiffRequestProducer", "getTitle", "", "status", "Lgit4idea/index/GitFileStatus;", "headContent", "Lcom/intellij/diff/contents/DiffContent;", "localContent", "stagedContent", "has", "", "contentVersion", "Lgit4idea/index/ContentVersion;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.git"})
public final class GitStageDiffUtilKt {
    @NotNull
    public static final ChangeDiffRequestChain.Producer createTwoSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode) {
        ChangeDiffRequestChain.Producer producer;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)statusNode, (String)"statusNode");
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$0[statusNode.getKind().ordinal()]) {
            case 1: {
                producer = new StagedProducer(project, statusNode);
                break;
            }
            case 2: {
                producer = new UnStagedProducer(project, statusNode);
                break;
            }
            case 3: {
                producer = new MergedProducer(project, statusNode);
                break;
            }
            case 4: 
            case 5: {
                UnversionedDiffRequestProducer unversionedDiffRequestProducer = UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath());
                Intrinsics.checkExpressionValueIsNotNull((Object)unversionedDiffRequestProducer, (String)"UnversionedDiffRequestPr\u2026ect, statusNode.filePath)");
                producer = (ChangeDiffRequestChain.Producer)unversionedDiffRequestProducer;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return producer;
    }

    @NotNull
    public static final ChangeDiffRequestChain.Producer createThreeSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode) {
        ChangeDiffRequestChain.Producer producer;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)statusNode, (String)"statusNode");
        boolean hasThreeSides = GitStageDiffUtilKt.has(statusNode, ContentVersion.HEAD) && GitStageDiffUtilKt.has(statusNode, ContentVersion.STAGED) && GitStageDiffUtilKt.has(statusNode, ContentVersion.LOCAL);
        switch (GitStageDiffUtilKt$WhenMappings.$EnumSwitchMapping$1[statusNode.getKind().ordinal()]) {
            case 1: {
                producer = hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode) : (GitFileStatusNodeProducerBase)new StagedProducer(project, statusNode);
                break;
            }
            case 2: {
                producer = hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode) : (GitFileStatusNodeProducerBase)new UnStagedProducer(project, statusNode);
                break;
            }
            case 3: {
                producer = new MergedProducer(project, statusNode);
                break;
            }
            case 4: 
            case 5: {
                UnversionedDiffRequestProducer unversionedDiffRequestProducer = UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath());
                Intrinsics.checkExpressionValueIsNotNull((Object)unversionedDiffRequestProducer, (String)"UnversionedDiffRequestPr\u2026ect, statusNode.filePath)");
                producer = (ChangeDiffRequestChain.Producer)unversionedDiffRequestProducer;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return producer;
    }

    private static final DiffContent headContent(Project project, GitFileStatusNode statusNode) throws VcsException, IOException {
        if (!GitStageDiffUtilKt.has(statusNode, ContentVersion.HEAD)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        byte[] headContent = GitFileUtils.getFileContent(project, statusNode.getRoot(), "HEAD", VcsFileUtil.relativePath((VirtualFile)statusNode.getRoot(), (FilePath)GitStageDiffUtilKt.path(statusNode, ContentVersion.HEAD)));
        DiffContent diffContent = DiffContentFactoryEx.getInstanceEx().createFromBytes(project, headContent, statusNode.getFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)diffContent, (String)"DiffContentFactoryEx.get\u2026ent, statusNode.filePath)");
        return diffContent;
    }

    private static final DiffContent stagedContent(Project project, GitFileStatusNode statusNode) throws VcsException {
        if (!GitStageDiffUtilKt.has(statusNode, ContentVersion.STAGED)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitIndexVirtualFileCache.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        GitIndexVirtualFile indexFile = ((GitIndexVirtualFileCache)object).get(statusNode.getRoot(), GitStageDiffUtilKt.path(statusNode, ContentVersion.STAGED));
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, (VirtualFile)indexFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)diffContent, (String)"DiffContentFactory.getIn\u2026reate(project, indexFile)");
        return diffContent;
    }

    private static final DiffContent localContent(Project project, GitFileStatusNode statusNode) throws VcsException {
        if (!GitStageDiffUtilKt.has(statusNode, ContentVersion.LOCAL)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkExpressionValueIsNotNull((Object)emptyContent, (String)"DiffContentFactory.getInstance().createEmpty()");
            return (DiffContent)emptyContent;
        }
        VirtualFile virtualFile = GitStageDiffUtilKt.path(statusNode, ContentVersion.LOCAL).getVirtualFile();
        if (virtualFile == null) {
            throw (Throwable)new VcsException("Can't get local file: " + statusNode.getFilePath());
        }
        VirtualFile localFile = virtualFile;
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, localFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)diffContent, (String)"DiffContentFactory.getIn\u2026reate(project, localFile)");
        return diffContent;
    }

    private static final boolean has(@NotNull GitFileStatusNode $this$has, ContentVersion contentVersion) {
        return GitFileStatusKt.has($this$has.getStatus(), contentVersion);
    }

    private static final FilePath path(@NotNull GitFileStatusNode $this$path, ContentVersion contentVersion) {
        return GitFileStatusKt.path($this$path.getStatus(), contentVersion);
    }

    private static final String getTitle(GitFileStatusNode statusNode) {
        String string = DiffRequestFactoryImpl.getTitle((FilePath)statusNode.getFilePath(), (FilePath)statusNode.getOrigPath(), (String)" -> ");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DiffRequestFactoryImpl.g\u2026F_TITLE_RENAME_SEPARATOR)");
        return string;
    }

    private static final String getTitle(GitFileStatus status) {
        String string = DiffRequestFactoryImpl.getTitle((FilePath)status.getPath(), (FilePath)status.getOrigPath(), (String)" -> ");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"DiffRequestFactoryImpl.g\u2026F_TITLE_RENAME_SEPARATOR)");
        return string;
    }

    public static final /* synthetic */ DiffContent access$stagedContent(Project project, GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.stagedContent(project, statusNode);
    }

    public static final /* synthetic */ DiffContent access$localContent(Project project, GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.localContent(project, statusNode);
    }

    public static final /* synthetic */ String access$getTitle(GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.getTitle(statusNode);
    }

    public static final /* synthetic */ DiffContent access$headContent(Project project, GitFileStatusNode statusNode) {
        return GitStageDiffUtilKt.headContent(project, statusNode);
    }

    public static final /* synthetic */ String access$getTitle(GitFileStatus status) {
        return GitStageDiffUtilKt.getTitle(status);
    }
}

