/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Fonts;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AllFonts
extends AnimatingControlsSurface {
    private static final List<Font> fonts = new ArrayList<Font>();
    private int nStrs;
    private int strH;
    private int fi;
    protected int fsize = 14;
    protected List<Font> v = new ArrayList<Font>();

    public AllFonts() {
        this.setBackground(Color.WHITE);
        this.setSleepAmount(500L);
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void handleThread(int state) {
    }

    @Override
    public void reset(int w, int h) {
        this.v.clear();
        Font f = fonts.get(0).deriveFont(0, this.fsize);
        FontMetrics fm = this.getFontMetrics(f);
        this.strH = fm.getAscent() + fm.getDescent();
        this.nStrs = h / this.strH + 1;
        this.fi = 0;
    }

    @Override
    public void step(int w, int h) {
        if (this.fi < fonts.size()) {
            this.v.add(fonts.get(this.fi).deriveFont(0, this.fsize));
        }
        if (this.v.size() == this.nStrs && !this.v.isEmpty() || this.fi > fonts.size()) {
            this.v.remove(0);
        }
        this.fi = this.v.isEmpty() ? 0 : (this.fi = this.fi + 1);
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        g2.setColor(Color.BLACK);
        int yy = this.fi >= fonts.size() ? 0 : h - this.v.size() * this.strH - this.strH / 2;
        for (int i = 0; i < this.v.size(); ++i) {
            Font f = this.v.get(i);
            int sw = this.getFontMetrics(f).stringWidth(f.getName());
            g2.setFont(f);
            g2.drawString(f.getName(), w / 2 - sw / 2, yy += this.strH);
        }
    }

    public static void main(String[] argv) {
        AllFonts.createDemoFrame(new AllFonts());
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : ge.getAllFonts()) {
            if (font.canDisplayUpTo(font.getName()) == 0) continue;
            fonts.add(font);
        }
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener,
    ChangeListener {
        AllFonts demo;
        JSlider slider;
        int[] fsize = new int[]{8, 14, 18, 24};
        JMenuItem[] menuitem = new JMenuItem[this.fsize.length];
        Font[] font = new Font[this.fsize.length];

        public DemoControls(AllFonts demo) {
            this.demo = demo;
            this.setBackground(Color.GRAY);
            int sleepAmount = (int)demo.getSleepAmount();
            this.slider = new JSlider(0, 0, 999, sleepAmount);
            this.slider.setBorder(new EtchedBorder());
            this.slider.setPreferredSize(new Dimension(90, 22));
            this.slider.addChangeListener(this);
            this.add(this.slider);
            JMenuBar menubar = new JMenuBar();
            this.add(menubar);
            JMenu menu = menubar.add(new JMenu("Font Size"));
            for (int i = 0; i < this.fsize.length; ++i) {
                this.font[i] = new Font("Serif", 0, this.fsize[i]);
                this.menuitem[i] = menu.add(new JMenuItem(String.valueOf(this.fsize[i])));
                this.menuitem[i].setFont(this.font[i]);
                this.menuitem[i].addActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.fsize.length; ++i) {
                if (!e.getSource().equals(this.menuitem[i])) continue;
                this.demo.fsize = this.fsize[i];
                Dimension d = this.demo.getSize();
                this.demo.reset(d.width, d.height);
                break;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.demo.setSleepAmount(this.slider.getValue());
        }
    }
}

