/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.FileAssociation;
import com.sun.javafx.tools.packager.DeployParams;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class Info
extends DataType {
    String title;
    String vendor;
    String appDescription;
    String category;
    String licenseType;
    String copyright;
    String email;
    List<Icon> icons = new LinkedList<Icon>();
    List<FileAssociation> fileAssociations = new LinkedList<FileAssociation>();
    static final Set<String> iconTypes = new HashSet<String>(){
        {
            this.add("default");
            this.add("selected");
            this.add("disabled");
            this.add("rollover");
            this.add("splash");
            this.add("shortcut");
        }
    };

    public void setCategory(String string) {
        this.category = string;
    }

    public void setLicense(String string) {
        this.licenseType = string;
    }

    public void setCopyright(String string) {
        this.copyright = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void setDescription(String string) {
        this.appDescription = string;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public Icon createIcon() {
        Icon icon = new Icon();
        this.icons.add(icon);
        return icon;
    }

    public Splash createSplash() {
        Splash splash = new Splash();
        this.icons.add(splash);
        return splash;
    }

    public FileAssociation createAssociation() {
        FileAssociation fileAssociation = new FileAssociation();
        this.fileAssociations.add(fileAssociation);
        return fileAssociation;
    }

    public class Splash
    extends Icon {
        DeployParams.RunMode mode;

        public Splash() {
            this.kind = "splash";
        }

        public void setKind() {
            throw new BuildException("Can not change kind of splash. Use icon instead.");
        }

        public void setMode(String string) {
            String string2 = string.toLowerCase();
            if ("webstart".equals(string2)) {
                this.mode = DeployParams.RunMode.WEBSTART;
            } else if ("embedded".equals(string2)) {
                this.mode = DeployParams.RunMode.EMBEDDED;
            } else if ("standalone".equals(string2)) {
                this.mode = DeployParams.RunMode.STANDALONE;
            } else if ("any".equals(string2)) {
                this.mode = DeployParams.RunMode.ALL;
            } else {
                throw new BuildException("Unsupported run mode: [" + string + "].");
            }
        }
    }

    public class Icon
    extends DataType {
        String href;
        String kind;
        int width = -1;
        int height = -1;
        int depth = -1;
        static final int UNDEFINED = -1;

        public void setHref(String string) {
            this.href = string;
        }

        public void setKind(String string) {
            if (!iconTypes.contains(string.toLowerCase())) {
                StringBuffer stringBuffer = new StringBuffer("Usupported type of icon [");
                stringBuffer.append(string.toLowerCase());
                stringBuffer.append("]. Supported types: ");
                for (String string2 : iconTypes) {
                    stringBuffer.append("\"" + string2 + "\" ");
                }
                throw new BuildException(stringBuffer.toString());
            }
            this.kind = string.toLowerCase();
        }

        public void setWidth(int n) {
            if (n <= 0) {
                throw new BuildException("Width must be positive number");
            }
            this.width = n;
        }

        public void setHeight(int n) {
            if (n <= 0) {
                throw new BuildException("Height must be positive number");
            }
            this.height = n;
        }

        public void setDepth(int n) {
            if (n <= 0) {
                throw new BuildException("Depth must be positive number");
            }
            this.depth = n;
        }
    }
}

