/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import com.sun.media.sound.JDK13Services;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public class AudioSystem {
    public static final int NOT_SPECIFIED = -1;

    private AudioSystem() {
    }

    public static Mixer.Info[] getMixerInfo() {
        List list = AudioSystem.getMixerInfoList();
        Mixer.Info[] infoArray = list.toArray(new Mixer.Info[list.size()]);
        return infoArray;
    }

    public static Mixer getMixer(Mixer.Info info) {
        int n;
        Object var1_1 = null;
        List list = AudioSystem.getMixerProviders();
        for (n = 0; n < list.size(); ++n) {
            try {
                return ((MixerProvider)list.get(n)).getMixer(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (info == null) {
            for (n = 0; n < list.size(); ++n) {
                try {
                    MixerProvider mixerProvider = (MixerProvider)list.get(n);
                    Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
                    for (int i = 0; i < infoArray.length; ++i) {
                        try {
                            return mixerProvider.getMixer(infoArray[i]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        throw new IllegalArgumentException("Mixer not supported: " + (info != null ? info.toString() : "null"));
    }

    public static Line.Info[] getSourceLineInfo(Line.Info info) {
        int n;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getSourceLineInfo(info);
            for (n = 0; n < infoArray2.length; ++n) {
                vector.addElement(infoArray2[n]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n = 0; n < infoArray3.length; ++n) {
            infoArray3[n] = (Line.Info)vector.get(n);
        }
        return infoArray3;
    }

    public static Line.Info[] getTargetLineInfo(Line.Info info) {
        int n;
        Vector<Line.Info> vector = new Vector<Line.Info>();
        Object var4_2 = null;
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = AudioSystem.getMixer(infoArray[i]);
            Line.Info[] infoArray2 = mixer.getTargetLineInfo(info);
            for (n = 0; n < infoArray2.length; ++n) {
                vector.addElement(infoArray2[n]);
            }
        }
        Line.Info[] infoArray3 = new Line.Info[vector.size()];
        for (n = 0; n < infoArray3.length; ++n) {
            infoArray3[n] = (Line.Info)vector.get(n);
        }
        return infoArray3;
    }

    public static boolean isLineSupported(Line.Info info) {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer;
            if (infoArray[i] == null || !(mixer = AudioSystem.getMixer(infoArray[i])).isLineSupported(info)) continue;
            return true;
        }
        return false;
    }

    public static Line getLine(Line.Info info) throws LineUnavailableException {
        Mixer mixer;
        int n;
        Mixer.Info[] infoArray;
        MixerProvider mixerProvider;
        int n2;
        LineUnavailableException lineUnavailableException = null;
        List list = AudioSystem.getMixerProviders();
        try {
            Mixer mixer2 = AudioSystem.getDefaultMixer(list, info);
            if (mixer2 != null && mixer2.isLineSupported(info)) {
                return mixer2.getLine(info);
            }
        }
        catch (LineUnavailableException lineUnavailableException2) {
            lineUnavailableException = lineUnavailableException2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            mixerProvider = (MixerProvider)list.get(n2);
            infoArray = mixerProvider.getMixerInfo();
            for (n = 0; n < infoArray.length; ++n) {
                try {
                    mixer = mixerProvider.getMixer(infoArray[n]);
                    if (!AudioSystem.isAppropriateMixer(mixer, info, true)) continue;
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException lineUnavailableException3) {
                    lineUnavailableException = lineUnavailableException3;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            mixerProvider = (MixerProvider)list.get(n2);
            infoArray = mixerProvider.getMixerInfo();
            for (n = 0; n < infoArray.length; ++n) {
                try {
                    mixer = mixerProvider.getMixer(infoArray[n]);
                    if (!AudioSystem.isAppropriateMixer(mixer, info, false)) continue;
                    return mixer.getLine(info);
                }
                catch (LineUnavailableException lineUnavailableException4) {
                    lineUnavailableException = lineUnavailableException4;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (lineUnavailableException != null) {
            throw lineUnavailableException;
        }
        throw new IllegalArgumentException("No line matching " + info.toString() + " is supported.");
    }

    public static Clip getClip() throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true);
        DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
        return (Clip)AudioSystem.getLine(info);
    }

    public static Clip getClip(Mixer.Info info) throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true);
        DataLine.Info info2 = new DataLine.Info(Clip.class, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        return (Clip)mixer.getLine(info2);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        return (SourceDataLine)AudioSystem.getLine(info);
    }

    public static SourceDataLine getSourceDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        DataLine.Info info2 = new DataLine.Info(SourceDataLine.class, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        return (SourceDataLine)mixer.getLine(info2);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        return (TargetDataLine)AudioSystem.getLine(info);
    }

    public static TargetDataLine getTargetDataLine(AudioFormat audioFormat, Mixer.Info info) throws LineUnavailableException {
        DataLine.Info info2 = new DataLine.Info(TargetDataLine.class, audioFormat);
        Mixer mixer = AudioSystem.getMixer(info);
        return (TargetDataLine)mixer.getLine(info2);
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat.Encoding encoding) {
        List list = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding> vector = new Vector<AudioFormat.Encoding>();
        AudioFormat.Encoding[] encodingArray = null;
        for (int i = 0; i < list.size(); ++i) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i);
            if (!formatConversionProvider.isSourceEncodingSupported(encoding)) continue;
            encodingArray = formatConversionProvider.getTargetEncodings();
            for (int j = 0; j < encodingArray.length; ++j) {
                vector.addElement(encodingArray[j]);
            }
        }
        AudioFormat.Encoding[] encodingArray2 = vector.toArray(new AudioFormat.Encoding[0]);
        return encodingArray2;
    }

    public static AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        List list = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat.Encoding[]> vector = new Vector<AudioFormat.Encoding[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat.Encoding[] encodingArray = null;
        for (int i = 0; i < list.size(); ++i) {
            encodingArray = ((FormatConversionProvider)list.get(i)).getTargetEncodings(audioFormat);
            n += encodingArray.length;
            vector.addElement(encodingArray);
        }
        AudioFormat.Encoding[] encodingArray2 = new AudioFormat.Encoding[n];
        for (int i = 0; i < vector.size(); ++i) {
            encodingArray = (AudioFormat.Encoding[])vector.get(i);
            for (int j = 0; j < encodingArray.length; ++j) {
                encodingArray2[n2++] = encodingArray[j];
            }
        }
        return encodingArray2;
    }

    public static boolean isConversionSupported(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        List list = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < list.size(); ++i) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i);
            if (!formatConversionProvider.isConversionSupported(encoding, audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        List list = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < list.size(); ++i) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i);
            if (!formatConversionProvider.isConversionSupported(encoding, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(encoding, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + encoding + " from " + audioInputStream.getFormat());
    }

    public static AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        List list = AudioSystem.getFormatConversionProviders();
        Vector<AudioFormat[]> vector = new Vector<AudioFormat[]>();
        int n = 0;
        int n2 = 0;
        AudioFormat[] audioFormatArray = null;
        for (int i = 0; i < list.size(); ++i) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i);
            audioFormatArray = formatConversionProvider.getTargetFormats(encoding, audioFormat);
            n += audioFormatArray.length;
            vector.addElement(audioFormatArray);
        }
        AudioFormat[] audioFormatArray2 = new AudioFormat[n];
        for (int i = 0; i < vector.size(); ++i) {
            audioFormatArray = (AudioFormat[])vector.get(i);
            for (int j = 0; j < audioFormatArray.length; ++j) {
                audioFormatArray2[n2++] = audioFormatArray[j];
            }
        }
        return audioFormatArray2;
    }

    public static boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        List list = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < list.size(); ++i) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i);
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioFormat2)) continue;
            return true;
        }
        return false;
    }

    public static AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        if (audioInputStream.getFormat().matches(audioFormat)) {
            return audioInputStream;
        }
        List list = AudioSystem.getFormatConversionProviders();
        for (int i = 0; i < list.size(); ++i) {
            FormatConversionProvider formatConversionProvider = (FormatConversionProvider)list.get(i);
            if (!formatConversionProvider.isConversionSupported(audioFormat, audioInputStream.getFormat())) continue;
            return formatConversionProvider.getAudioInputStream(audioFormat, audioInputStream);
        }
        throw new IllegalArgumentException("Unsupported conversion: " + audioFormat + " from " + audioInputStream.getFormat());
    }

    public static AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i);
            try {
                audioFileFormat = audioFileReader.getAudioFileFormat(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i);
            try {
                audioFileFormat = audioFileReader.getAudioFileFormat(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioFileFormat audioFileFormat = null;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i);
            try {
                audioFileFormat = audioFileReader.getAudioFileFormat(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioFileFormat == null) {
            throw new UnsupportedAudioFileException("file is not a supported file type");
        }
        return audioFileFormat;
    }

    public static AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i);
            try {
                audioInputStream = audioFileReader.getAudioInputStream(inputStream);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input stream");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i);
            try {
                audioInputStream = audioFileReader.getAudioInputStream(uRL);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input URL");
        }
        return audioInputStream;
    }

    public static AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        List list = AudioSystem.getAudioFileReaders();
        AudioInputStream audioInputStream = null;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileReader audioFileReader = (AudioFileReader)list.get(i);
            try {
                audioInputStream = audioFileReader.getAudioInputStream(file);
                break;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                continue;
            }
        }
        if (audioInputStream == null) {
            throw new UnsupportedAudioFileException("could not get audio input stream from input file");
        }
        return audioInputStream;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes() {
        List list = AudioSystem.getAudioFileWriters();
        HashSet<AudioFileFormat.Type> hashSet = new HashSet<AudioFileFormat.Type>();
        for (int i = 0; i < list.size(); ++i) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i);
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes();
            for (int j = 0; j < typeArray.length; ++j) {
                hashSet.add(typeArray[j]);
            }
        }
        AudioFileFormat.Type[] typeArray = hashSet.toArray(new AudioFileFormat.Type[0]);
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type) {
        List list = AudioSystem.getAudioFileWriters();
        for (int i = 0; i < list.size(); ++i) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i);
            if (!audioFileWriter.isFileTypeSupported(type)) continue;
            return true;
        }
        return false;
    }

    public static AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream audioInputStream) {
        List list = AudioSystem.getAudioFileWriters();
        HashSet<AudioFileFormat.Type> hashSet = new HashSet<AudioFileFormat.Type>();
        for (int i = 0; i < list.size(); ++i) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i);
            AudioFileFormat.Type[] typeArray = audioFileWriter.getAudioFileTypes(audioInputStream);
            for (int j = 0; j < typeArray.length; ++j) {
                hashSet.add(typeArray[j]);
            }
        }
        AudioFileFormat.Type[] typeArray = hashSet.toArray(new AudioFileFormat.Type[0]);
        return typeArray;
    }

    public static boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        List list = AudioSystem.getAudioFileWriters();
        for (int i = 0; i < list.size(); ++i) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i);
            if (!audioFileWriter.isFileTypeSupported(type, audioInputStream)) continue;
            return true;
        }
        return false;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, OutputStream outputStream) throws IOException {
        List list = AudioSystem.getAudioFileWriters();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i);
            try {
                n = audioFileWriter.write(audioInputStream, type, outputStream);
                bl = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n;
    }

    public static int write(AudioInputStream audioInputStream, AudioFileFormat.Type type, File file) throws IOException {
        List list = AudioSystem.getAudioFileWriters();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            AudioFileWriter audioFileWriter = (AudioFileWriter)list.get(i);
            try {
                n = audioFileWriter.write(audioInputStream, type, file);
                bl = true;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        if (!bl) {
            throw new IllegalArgumentException("could not write audio file: file type not supported: " + type);
        }
        return n;
    }

    private static List getMixerProviders() {
        return AudioSystem.getProviders(MixerProvider.class);
    }

    private static List getFormatConversionProviders() {
        return AudioSystem.getProviders(FormatConversionProvider.class);
    }

    private static List getAudioFileReaders() {
        return AudioSystem.getProviders(AudioFileReader.class);
    }

    private static List getAudioFileWriters() {
        return AudioSystem.getProviders(AudioFileWriter.class);
    }

    private static Mixer getDefaultMixer(List list, Line.Info info) {
        Mixer mixer;
        MixerProvider mixerProvider;
        Class<?> clazz = info.getLineClass();
        String string = JDK13Services.getDefaultProviderClassName(clazz);
        String string2 = JDK13Services.getDefaultInstanceName(clazz);
        if (string != null && (mixerProvider = AudioSystem.getNamedProvider(string, list)) != null && (string2 != null ? (mixer = AudioSystem.getNamedMixer(string2, mixerProvider, info)) != null : (mixer = AudioSystem.getFirstMixer(mixerProvider, info, false)) != null)) {
            return mixer;
        }
        if (string2 != null && (mixer = AudioSystem.getNamedMixer(string2, list, info)) != null) {
            return mixer;
        }
        return null;
    }

    private static MixerProvider getNamedProvider(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            MixerProvider mixerProvider = (MixerProvider)list.get(i);
            if (!mixerProvider.getClass().getName().equals(string)) continue;
            return mixerProvider;
        }
        return null;
    }

    private static Mixer getNamedMixer(String string, MixerProvider mixerProvider, Line.Info info) {
        Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer;
            if (!infoArray[i].getName().equals(string) || !AudioSystem.isAppropriateMixer(mixer = mixerProvider.getMixer(infoArray[i]), info, false)) continue;
            return mixer;
        }
        return null;
    }

    private static Mixer getNamedMixer(String string, List list, Line.Info info) {
        for (int i = 0; i < list.size(); ++i) {
            MixerProvider mixerProvider = (MixerProvider)list.get(i);
            Mixer mixer = AudioSystem.getNamedMixer(string, mixerProvider, info);
            if (mixer == null) continue;
            return mixer;
        }
        return null;
    }

    private static Mixer getFirstMixer(MixerProvider mixerProvider, Line.Info info, boolean bl) {
        Mixer.Info[] infoArray = mixerProvider.getMixerInfo();
        for (int i = 0; i < infoArray.length; ++i) {
            Mixer mixer = mixerProvider.getMixer(infoArray[i]);
            if (!AudioSystem.isAppropriateMixer(mixer, info, bl)) continue;
            return mixer;
        }
        return null;
    }

    private static boolean isAppropriateMixer(Mixer mixer, Line.Info info, boolean bl) {
        if (!mixer.isLineSupported(info)) {
            return false;
        }
        Class<?> clazz = info.getLineClass();
        if (bl && (SourceDataLine.class.isAssignableFrom(clazz) || Clip.class.isAssignableFrom(clazz))) {
            int n = mixer.getMaxLines(info);
            return n == -1 || n > 1;
        }
        return true;
    }

    private static List getMixerInfoList() {
        List list = AudioSystem.getMixerProviders();
        return AudioSystem.getMixerInfoList(list);
    }

    private static List getMixerInfoList(List list) {
        ArrayList<Mixer.Info> arrayList = new ArrayList<Mixer.Info>();
        for (int i = 0; i < list.size(); ++i) {
            Mixer.Info[] infoArray = ((MixerProvider)list.get(i)).getMixerInfo();
            for (int j = 0; j < infoArray.length; ++j) {
                arrayList.add(infoArray[j]);
            }
        }
        return arrayList;
    }

    private static List getProviders(Class clazz) {
        return JDK13Services.getProviders(clazz);
    }
}

