/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TreeNode {
    protected HashMap<String, String> attributes = null;
    protected String body = null;
    protected ArrayList<TreeNode> children = null;
    protected String name = null;
    protected TreeNode parent = null;

    public TreeNode(String string, TreeNode treeNode) {
        this.name = string;
        this.parent = treeNode;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public void addAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
    }

    public void addChild(TreeNode treeNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(treeNode);
    }

    public String findAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public Iterator<String> findAttributes() {
        if (this.attributes == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.attributes.keySet().iterator();
    }

    public TreeNode findChild(String string) {
        if (this.children == null) {
            return null;
        }
        for (TreeNode treeNode : this.children) {
            if (!string.equals(treeNode.getName())) continue;
            return treeNode;
        }
        return null;
    }

    public Iterator<TreeNode> findChildren() {
        if (this.children == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        return this.children.iterator();
    }

    public Iterator<TreeNode> findChildren(String string) {
        if (this.children == null) {
            List list = Collections.emptyList();
            return list.iterator();
        }
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        for (TreeNode treeNode : this.children) {
            if (!string.equals(treeNode.getName())) continue;
            arrayList.add(treeNode);
        }
        return arrayList.iterator();
    }

    public String getBody() {
        return this.body;
    }

    public String getName() {
        return this.name;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, 0, this);
        return stringBuilder.toString();
    }

    protected void toString(StringBuilder stringBuilder, int n, TreeNode treeNode) {
        String string;
        int n2 = n + 2;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append('<');
        stringBuilder.append(treeNode.getName());
        Iterator<String> iterator = treeNode.findAttributes();
        while (iterator.hasNext()) {
            stringBuilder.append(' ');
            string = iterator.next();
            stringBuilder.append(string);
            stringBuilder.append("=\"");
            String string2 = treeNode.findAttribute(string);
            stringBuilder.append(string2);
            stringBuilder.append("\"");
        }
        stringBuilder.append(">\n");
        string = treeNode.getBody();
        if (string != null && string.length() > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        Iterator<TreeNode> iterator2 = treeNode.findChildren();
        while (iterator2.hasNext()) {
            TreeNode treeNode2 = iterator2.next();
            this.toString(stringBuilder, n2, treeNode2);
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("</");
        stringBuilder.append(treeNode.getName());
        stringBuilder.append(">\n");
    }
}

