/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.coyote.http11.upgrade.servlet31.WriteListener;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractServletOutputStream
extends ServletOutputStream {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11.upgrade");
    private final Object fireListenerLock = new Object();
    private final Object writeLock = new Object();
    private volatile boolean closeRequired = false;
    private volatile WriteListener listener = null;
    private volatile boolean fireListener = false;
    private volatile ClassLoader applicationLoader = null;
    private volatile byte[] buffer;
    private volatile int bufferPos;
    private volatile int bufferLimit;
    private final int asyncWriteBufferSize;

    public AbstractServletOutputStream(int n) {
        this.asyncWriteBufferSize = n;
        this.buffer = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sos.canWrite.ise"));
        }
        Object object = this.fireListenerLock;
        synchronized (object) {
            boolean bl = this.bufferLimit == 0;
            this.fireListener = !bl;
            return bl;
        }
    }

    public final void setWriteListener(WriteListener writeListener) {
        if (writeListener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sos.writeListener.set"));
        }
        this.listener = writeListener;
        this.applicationLoader = Thread.currentThread().getContextClassLoader();
    }

    protected final boolean isCloseRequired() {
        return this.closeRequired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(new byte[]{(byte)n}, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.preWriteChecks();
            this.writeInternal(byArray, n, n2);
        }
    }

    public void close() throws IOException {
        this.closeRequired = true;
        this.doClose();
    }

    private void preWriteChecks() {
        if (this.bufferLimit != 0) {
            throw new IllegalStateException(sm.getString("upgrade.sis.write.ise"));
        }
    }

    private void writeInternal(byte[] byArray, int n, int n2) throws IOException {
        if (this.listener == null) {
            this.doWrite(true, byArray, n, n2);
        } else {
            int n3 = this.doWrite(false, byArray, n, n2);
            if (n3 < n2) {
                if (byArray == this.buffer) {
                    this.bufferPos += n3;
                } else {
                    int n4 = n2 - n3;
                    if (n4 > this.buffer.length) {
                        this.buffer = new byte[n4];
                    } else if (n4 < this.asyncWriteBufferSize && this.buffer.length > this.asyncWriteBufferSize) {
                        this.buffer = new byte[this.asyncWriteBufferSize];
                    }
                    this.bufferPos = 0;
                    this.bufferLimit = n4;
                    System.arraycopy(byArray, n + n3, this.buffer, this.bufferPos, this.bufferLimit);
                }
            } else {
                this.bufferLimit = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onWritePossible() throws IOException {
        try {
            Object object = this.writeLock;
            synchronized (object) {
                if (this.bufferLimit > 0) {
                    this.writeInternal(this.buffer, this.bufferPos, this.bufferLimit - this.bufferPos);
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            this.onError(throwable);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
        boolean bl = false;
        Object object = this.fireListenerLock;
        synchronized (object) {
            if (this.bufferLimit == 0 && this.fireListener) {
                this.fireListener = false;
                bl = true;
            }
        }
        if (bl) {
            object = Thread.currentThread();
            ClassLoader classLoader = ((Thread)object).getContextClassLoader();
            try {
                ((Thread)object).setContextClassLoader(this.applicationLoader);
                this.listener.onWritePossible();
            }
            finally {
                ((Thread)object).setContextClassLoader(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onError(Throwable throwable) {
        if (this.listener == null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.applicationLoader);
            this.listener.onError(throwable);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    protected abstract int doWrite(boolean var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void doFlush() throws IOException;

    protected abstract void doClose() throws IOException;
}

