/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.util.XMLWriter;
import org.apache.naming.resources.CacheEntry;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.tomcat.util.http.ConcurrentDateFormat;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.security.MD5Encoder;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet {
    private static final long serialVersionUID = 1L;
    private static final URLEncoder URL_ENCODER_XML = (URLEncoder)URLEncoder.DEFAULT.clone();
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final ConcurrentDateFormat creationDateFormat;
    protected static MessageDigest md5Helper;
    @Deprecated
    protected static final MD5Encoder md5Encoder;
    private final Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private final Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private final Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;

    @Override
    public void init() throws ServletException {
        super.init();
        if (this.getServletConfig().getInitParameter("secret") != null) {
            this.secret = this.getServletConfig().getInitParameter("secret");
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnavailableException("No MD5");
        }
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        if (httpServletRequest.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isSpecialPath(string)) {
            httpServletResponse.sendError(404);
            return;
        }
        String string2 = httpServletRequest.getMethod();
        if (this.debug > 0) {
            this.log("[" + string2 + "] " + string);
        }
        if (string2.equals(METHOD_PROPFIND)) {
            this.doPropfind(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_PROPPATCH)) {
            this.doProppatch(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MKCOL)) {
            this.doMkcol(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_COPY)) {
            this.doCopy(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MOVE)) {
            this.doMove(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_LOCK)) {
            this.doLock(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_UNLOCK)) {
            this.doUnlock(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    private final boolean isSpecialPath(String string) {
        return !this.allowSpecialPaths && (string.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || string.toUpperCase(Locale.ENGLISH).startsWith("/META-INF"));
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ResourceAttributes resourceAttributes) throws IOException {
        return super.checkIfHeaders(httpServletRequest, httpServletResponse, resourceAttributes);
    }

    @Override
    protected String rewriteUrl(String string) {
        return URL_ENCODER_XML.encode(string, "UTF-8");
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest) {
        return this.getRelativePath(httpServletRequest, false);
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest, boolean bl) {
        String string = httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null ? (String)httpServletRequest.getAttribute("javax.servlet.include.path_info") : httpServletRequest.getPathInfo();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getPathPrefix(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getContextPath();
        if (httpServletRequest.getServletPath() != null) {
            string = string + httpServletRequest.getServletPath();
        }
        return string;
    }

    @Override
    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.addHeader("DAV", "1,2");
        httpServletResponse.addHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
        httpServletResponse.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Enumeration<String> enumeration;
        boolean bl;
        Enumeration<String> enumeration2;
        Object object2;
        Object object3;
        int n;
        int n2;
        Vector<String> vector;
        String string;
        block44: {
            Object object4;
            Object object5;
            if (!this.listings) {
                this.sendNotAllowed(httpServletRequest, httpServletResponse);
                return;
            }
            string = this.getRelativePath(httpServletRequest);
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            vector = null;
            n2 = this.maxDepth;
            n = 1;
            String string2 = httpServletRequest.getHeader("Depth");
            if (string2 == null) {
                n2 = this.maxDepth;
            } else if (string2.equals("0")) {
                n2 = 0;
            } else if (string2.equals("1")) {
                n2 = 1;
            } else if (string2.equals("infinity")) {
                n2 = this.maxDepth;
            }
            Object object6 = null;
            if (httpServletRequest.getContentLength() > 0) {
                object5 = this.getDocumentBuilder();
                try {
                    object3 = ((DocumentBuilder)object5).parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                    object2 = object3.getDocumentElement();
                    object4 = object2.getChildNodes();
                    block17: for (int i = 0; i < object4.getLength(); ++i) {
                        enumeration2 = object4.item(i);
                        switch (enumeration2.getNodeType()) {
                            case 3: {
                                continue block17;
                            }
                            case 1: {
                                if (enumeration2.getNodeName().endsWith("prop")) {
                                    n = 0;
                                    object6 = enumeration2;
                                }
                                if (enumeration2.getNodeName().endsWith("propname")) {
                                    n = 2;
                                }
                                if (!enumeration2.getNodeName().endsWith("allprop")) continue block17;
                                n = 1;
                            }
                        }
                    }
                }
                catch (SAXException sAXException) {
                    httpServletResponse.sendError(400);
                    return;
                }
                catch (IOException iOException) {
                    httpServletResponse.sendError(400);
                    return;
                }
            }
            if (n == 0) {
                vector = new Vector<String>();
                object5 = object6.getChildNodes();
                block18: for (int i = 0; i < object5.getLength(); ++i) {
                    object2 = object5.item(i);
                    switch (object2.getNodeType()) {
                        case 3: {
                            continue block18;
                        }
                        case 1: {
                            object4 = object2.getNodeName();
                            Object object7 = null;
                            object7 = ((String)object4).indexOf(58) != -1 ? ((String)object4).substring(((String)object4).indexOf(58) + 1) : object4;
                            vector.addElement((String)object7);
                        }
                    }
                }
            }
            bl = true;
            object3 = null;
            try {
                object3 = this.resources.lookup(string);
            }
            catch (NamingException namingException) {
                String string3;
                bl = false;
                int n3 = string.lastIndexOf(47);
                if (n3 == -1 || (enumeration2 = this.lockNullResources.get(string3 = string.substring(0, n3))) == null) break block44;
                enumeration = ((Vector)((Object)enumeration2)).elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (!((String)object).equals(string)) continue;
                    httpServletResponse.setStatus(207);
                    httpServletResponse.setContentType("text/xml; charset=UTF-8");
                    XMLWriter xMLWriter = new XMLWriter(httpServletResponse.getWriter());
                    xMLWriter.writeXMLHeader();
                    xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    this.parseLockNullProperties(httpServletRequest, xMLWriter, (String)object, n, vector);
                    xMLWriter.writeElement("D", "multistatus", 1);
                    xMLWriter.sendData();
                    return;
                }
            }
        }
        if (!bl) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(207);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object2 = new XMLWriter(httpServletResponse.getWriter());
        ((XMLWriter)object2).writeXMLHeader();
        ((XMLWriter)object2).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (n2 == 0) {
            this.parseProperties(httpServletRequest, (XMLWriter)object2, string, n, vector);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(string);
            Stack<Object> stack2 = new Stack<Object>();
            while (!stack.isEmpty() && n2 >= 0) {
                enumeration2 = (String)stack.pop();
                this.parseProperties(httpServletRequest, (XMLWriter)object2, (String)((Object)enumeration2), n, vector);
                try {
                    object3 = this.resources.lookup((String)((Object)enumeration2));
                }
                catch (NamingException namingException) {
                    continue;
                }
                if (object3 instanceof DirContext && n2 > 0) {
                    Enumeration<String> enumeration3;
                    try {
                        enumeration = this.resources.list((String)((Object)enumeration2));
                        while (enumeration.hasMoreElements()) {
                            object = (NameClassPair)enumeration.nextElement();
                            enumeration3 = enumeration2;
                            if (!((String)((Object)enumeration3)).endsWith("/")) {
                                enumeration3 = (String)((Object)enumeration3) + "/";
                            }
                            enumeration3 = (String)((Object)enumeration3) + ((NameClassPair)object).getName();
                            stack2.push(enumeration3);
                        }
                    }
                    catch (NamingException namingException) {
                        httpServletResponse.sendError(500, string);
                        return;
                    }
                    enumeration = enumeration2;
                    if (((String)((Object)enumeration)).endsWith("/")) {
                        enumeration = ((String)((Object)enumeration)).substring(0, ((String)((Object)enumeration)).length() - 1);
                    }
                    if ((object = this.lockNullResources.get(enumeration)) != null) {
                        enumeration3 = ((Vector)object).elements();
                        while (enumeration3.hasMoreElements()) {
                            String string4 = (String)enumeration3.nextElement();
                            this.parseLockNullProperties(httpServletRequest, (XMLWriter)object2, string4, n, vector);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --n2;
                    stack = stack2;
                    stack2 = new Stack();
                }
                ((XMLWriter)object2).sendData();
            }
        }
        ((XMLWriter)object2).writeElement("D", "multistatus", 1);
        ((XMLWriter)object2).sendData();
    }

    protected void doProppatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        httpServletResponse.sendError(501);
    }

    protected void doMkcol(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        boolean bl = true;
        try {
            this.resources.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (bl) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        if (httpServletRequest.getContentLength() > 0) {
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            try {
                documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
                httpServletResponse.sendError(501);
                return;
            }
            catch (SAXException sAXException) {
                httpServletResponse.sendError(415);
                return;
            }
        }
        boolean bl2 = true;
        try {
            this.resources.createSubcontext(string);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (bl2) {
            httpServletResponse.setStatus(201);
            this.lockNullResources.remove(string);
        } else {
            httpServletResponse.sendError(409, WebdavStatus.getStatusText(409));
        }
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        this.deleteResource(httpServletRequest, httpServletResponse);
    }

    @Override
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        Object object = null;
        try {
            object = this.resources.lookup(string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object instanceof DirContext) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        super.doPut(httpServletRequest, httpServletResponse);
        this.lockNullResources.remove(string);
    }

    protected void doCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        this.copyResource(httpServletRequest, httpServletResponse);
    }

    protected void doMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (this.copyResource(httpServletRequest, httpServletResponse)) {
            this.deleteResource(string, httpServletRequest, httpServletResponse, false);
        }
    }

    protected void doLock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Enumeration<LockInfo> enumeration;
        Object object5;
        Object object6;
        Object object7;
        int n;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        Object object8 = new LockInfo(this.maxDepth);
        String string = httpServletRequest.getHeader("Depth");
        ((LockInfo)object8).depth = string == null ? this.maxDepth : (string.equals("0") ? 0 : this.maxDepth);
        int n2 = 3600;
        String string2 = httpServletRequest.getHeader("Timeout");
        if (string2 == null) {
            n2 = 3600;
        } else {
            n = string2.indexOf(44);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (string2.startsWith("Second-")) {
                n2 = Integer.parseInt(string2.substring(7));
            } else if (string2.equalsIgnoreCase("infinity")) {
                n2 = 604800;
            } else {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 604800;
                }
            }
            if (n2 == 0) {
                n2 = 3600;
            }
            if (n2 > 604800) {
                n2 = 604800;
            }
        }
        ((LockInfo)object8).expiresAt = System.currentTimeMillis() + (long)(n2 * 1000);
        n = 0;
        Node node = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            object7 = documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
            object6 = object7.getDocumentElement();
            node = object6;
        }
        catch (IOException iOException) {
            n = 1;
        }
        catch (SAXException sAXException) {
            n = 1;
        }
        if (node != null) {
            int n3;
            object7 = node.getChildNodes();
            object6 = null;
            object5 = null;
            enumeration = null;
            object4 = null;
            object3 = null;
            block25: for (n3 = 0; n3 < object7.getLength(); ++n3) {
                object2 = object7.item(n3);
                switch (object2.getNodeType()) {
                    case 3: {
                        continue block25;
                    }
                    case 1: {
                        object = object2.getNodeName();
                        if (((String)object).endsWith("lockscope")) {
                            enumeration = object2;
                        }
                        if (((String)object).endsWith("locktype")) {
                            object4 = object2;
                        }
                        if (!((String)object).endsWith("owner")) continue block25;
                        object3 = object2;
                    }
                }
            }
            if (enumeration != null) {
                object7 = enumeration.getChildNodes();
                block26: for (n3 = 0; n3 < object7.getLength(); ++n3) {
                    object2 = object7.item(n3);
                    switch (object2.getNodeType()) {
                        case 3: {
                            continue block26;
                        }
                        case 1: {
                            object = object2.getNodeName();
                            ((LockInfo)object8).scope = ((String)object).indexOf(58) != -1 ? ((String)object).substring(((String)object).indexOf(58) + 1) : object;
                        }
                    }
                }
                if (((LockInfo)object8).scope == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (object4 != null) {
                object7 = object4.getChildNodes();
                block27: for (n3 = 0; n3 < object7.getLength(); ++n3) {
                    object2 = object7.item(n3);
                    switch (object2.getNodeType()) {
                        case 3: {
                            continue block27;
                        }
                        case 1: {
                            object = object2.getNodeName();
                            ((LockInfo)object8).type = ((String)object).indexOf(58) != -1 ? ((String)object).substring(((String)object).indexOf(58) + 1) : object;
                        }
                    }
                }
                if (((LockInfo)object8).type == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (object3 != null) {
                object7 = object3.getChildNodes();
                block28: for (n3 = 0; n3 < object7.getLength(); ++n3) {
                    object2 = object7.item(n3);
                    switch (object2.getNodeType()) {
                        case 3: {
                            ((LockInfo)object8).owner = ((LockInfo)object8).owner + object2.getNodeValue();
                            continue block28;
                        }
                        case 1: {
                            object6 = new StringWriter();
                            object5 = new DOMWriter((Writer)object6, true);
                            ((DOMWriter)object5).setQualifiedNames(false);
                            ((DOMWriter)object5).print((Node)object2);
                            ((LockInfo)object8).owner = ((LockInfo)object8).owner + ((StringWriter)object6).toString();
                        }
                    }
                }
                if (((LockInfo)object8).owner == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                ((LockInfo)object8).owner = "";
            }
        }
        ((LockInfo)object8).path = object7 = this.getRelativePath(httpServletRequest);
        boolean bl = true;
        object5 = null;
        try {
            object5 = this.resources.lookup((String)object7);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        enumeration = null;
        if (n == 0) {
            object4 = httpServletRequest.getServletPath() + "-" + ((LockInfo)object8).type + "-" + ((LockInfo)object8).scope + "-" + httpServletRequest.getUserPrincipal() + "-" + ((LockInfo)object8).depth + "-" + ((LockInfo)object8).owner + "-" + ((LockInfo)object8).tokens + "-" + ((LockInfo)object8).expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            object3 = MD5Encoder.encode((byte[])md5Helper.digest(((String)object4).getBytes(Charset.defaultCharset())));
            if (bl && object5 instanceof DirContext && ((LockInfo)object8).depth == this.maxDepth) {
                Vector<String> vector = new Vector<String>();
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (LockInfo)enumeration.nextElement();
                    if (((LockInfo)object2).hasExpired()) {
                        this.resourceLocks.remove(((LockInfo)object2).path);
                        continue;
                    }
                    if (!((LockInfo)object2).path.startsWith(((LockInfo)object8).path) || !((LockInfo)object2).isExclusive() && !((LockInfo)object8).isExclusive()) continue;
                    vector.addElement(((LockInfo)object2).path);
                }
                enumeration = this.resourceLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    if (((LockInfo)object2).hasExpired()) {
                        this.resourceLocks.remove(((LockInfo)object2).path);
                        continue;
                    }
                    if (!((LockInfo)object2).path.startsWith(((LockInfo)object8).path) || !((LockInfo)object2).isExclusive() && !((LockInfo)object8).isExclusive()) continue;
                    vector.addElement(((LockInfo)object2).path);
                }
                if (!vector.isEmpty()) {
                    object2 = vector.elements();
                    httpServletResponse.setStatus(409);
                    object = new XMLWriter();
                    ((XMLWriter)object).writeXMLHeader();
                    ((XMLWriter)object).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    while (object2.hasMoreElements()) {
                        ((XMLWriter)object).writeElement("D", "response", 0);
                        ((XMLWriter)object).writeElement("D", "href", 0);
                        ((XMLWriter)object).writeText((String)object2.nextElement());
                        ((XMLWriter)object).writeElement("D", "href", 1);
                        ((XMLWriter)object).writeElement("D", "status", 0);
                        ((XMLWriter)object).writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        ((XMLWriter)object).writeElement("D", "status", 1);
                        ((XMLWriter)object).writeElement("D", "response", 1);
                    }
                    ((XMLWriter)object).writeElement("D", "multistatus", 1);
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    ((Writer)printWriter).write(((XMLWriter)object).toString());
                    ((Writer)printWriter).close();
                    return;
                }
                boolean bl2 = true;
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!((LockInfo)object).path.equals(((LockInfo)object8).path)) continue;
                    if (((LockInfo)object).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    if (((LockInfo)object8).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    ((LockInfo)object).tokens.addElement((String)object3);
                    object8 = object;
                    bl2 = false;
                }
                if (bl2) {
                    ((LockInfo)object8).tokens.addElement((String)object3);
                    this.collectionLocks.addElement((LockInfo)object8);
                }
            } else {
                LockInfo lockInfo = this.resourceLocks.get(((LockInfo)object8).path);
                if (lockInfo != null) {
                    if (lockInfo.isExclusive() || ((LockInfo)object8).isExclusive()) {
                        httpServletResponse.sendError(412);
                        return;
                    }
                    lockInfo.tokens.addElement((String)object3);
                    object8 = lockInfo;
                } else {
                    ((LockInfo)object8).tokens.addElement((String)object3);
                    this.resourceLocks.put(((LockInfo)object8).path, (LockInfo)object8);
                    bl = true;
                    try {
                        object5 = this.resources.lookup((String)object7);
                    }
                    catch (NamingException namingException) {
                        bl = false;
                    }
                    if (!bl) {
                        int n4 = ((LockInfo)object8).path.lastIndexOf(47);
                        object = ((LockInfo)object8).path.substring(0, n4);
                        Vector<String> vector = this.lockNullResources.get(object);
                        if (vector == null) {
                            vector = new Vector();
                            this.lockNullResources.put((String)object, vector);
                        }
                        vector.addElement(((LockInfo)object8).path);
                    }
                    httpServletResponse.addHeader("Lock-Token", "<opaquelocktoken:" + (String)object3 + ">");
                }
            }
        }
        if (n == 1) {
            object4 = httpServletRequest.getHeader("If");
            if (object4 == null) {
                object4 = "";
            }
            object3 = this.resourceLocks.get(object7);
            Enumeration<String> enumeration2 = null;
            if (object3 != null) {
                enumeration2 = ((LockInfo)object3).tokens.elements();
                while (enumeration2.hasMoreElements()) {
                    String string3 = enumeration2.nextElement();
                    if (!((String)object4).contains(string3)) continue;
                    ((LockInfo)object3).expiresAt = ((LockInfo)object8).expiresAt;
                    object8 = object3;
                }
            }
            Enumeration<LockInfo> enumeration3 = this.collectionLocks.elements();
            while (enumeration3.hasMoreElements()) {
                object3 = enumeration3.nextElement();
                if (!((String)object7).equals(((LockInfo)object3).path)) continue;
                enumeration2 = ((LockInfo)object3).tokens.elements();
                while (enumeration2.hasMoreElements()) {
                    object = enumeration2.nextElement();
                    if (!((String)object4).contains((CharSequence)object)) continue;
                    ((LockInfo)object3).expiresAt = ((LockInfo)object8).expiresAt;
                    object8 = object3;
                }
            }
        }
        object4 = new XMLWriter();
        ((XMLWriter)object4).writeXMLHeader();
        ((XMLWriter)object4).writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        ((XMLWriter)object4).writeElement("D", "lockdiscovery", 0);
        ((LockInfo)object8).toXML((XMLWriter)object4);
        ((XMLWriter)object4).writeElement("D", "lockdiscovery", 1);
        ((XMLWriter)object4).writeElement("D", "prop", 1);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object3 = httpServletResponse.getWriter();
        ((Writer)object3).write(((XMLWriter)object4).toString());
        ((Writer)object3).close();
    }

    protected void doUnlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        String string2 = httpServletRequest.getHeader("Lock-Token");
        if (string2 == null) {
            string2 = "";
        }
        LockInfo lockInfo = this.resourceLocks.get(string);
        Enumeration<String> enumeration = null;
        if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!string2.contains((CharSequence)object)) continue;
                lockInfo.tokens.removeElement(object);
            }
            if (lockInfo.tokens.isEmpty()) {
                this.resourceLocks.remove(string);
                this.lockNullResources.remove(string);
            }
        }
        object = this.collectionLocks.elements();
        while (object.hasMoreElements()) {
            lockInfo = object.nextElement();
            if (!string.equals(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (!string2.contains(string3)) continue;
                lockInfo.tokens.removeElement(string3);
                break;
            }
            if (!lockInfo.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lockInfo);
            this.lockNullResources.remove(string);
        }
        httpServletResponse.setStatus(204);
    }

    private boolean isLocked(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = this.getRelativePath(httpServletRequest);
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string = httpServletRequest.getHeader("Lock-Token")) == null) {
            string = "";
        }
        return this.isLocked(string2, string3 + string);
    }

    private boolean isLocked(String string, String string2) {
        LockInfo lockInfo = this.resourceLocks.get(string);
        Enumeration<String> enumeration = null;
        if (lockInfo != null && lockInfo.hasExpired()) {
            this.resourceLocks.remove(string);
        } else if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (!string2.contains(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return true;
            }
        }
        Enumeration<LockInfo> enumeration2 = this.collectionLocks.elements();
        while (enumeration2.hasMoreElements()) {
            lockInfo = enumeration2.nextElement();
            if (lockInfo.hasExpired()) {
                this.collectionLocks.removeElement(lockInfo);
                continue;
            }
            if (!string.startsWith(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string4 = enumeration.nextElement();
                if (!string2.contains(string4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Hashtable<String, Integer> hashtable;
        boolean bl;
        String string;
        String string2;
        String string3 = httpServletRequest.getHeader("Destination");
        if (string3 == null) {
            httpServletResponse.sendError(400);
            return false;
        }
        int n = (string3 = RequestUtil.URLDecode(string3, "UTF-8")).indexOf("://");
        if (n >= 0) {
            int n2 = string3.indexOf(47, n + 4);
            string3 = n2 < 0 ? "/" : string3.substring(n2);
        } else {
            int n3;
            String string4 = httpServletRequest.getServerName();
            if (string4 != null && string3.startsWith(string4)) {
                string3 = string3.substring(string4.length());
            }
            if ((n3 = string3.indexOf(58)) >= 0) {
                string3 = string3.substring(n3);
            }
            if (string3.startsWith(":")) {
                int n4 = string3.indexOf(47);
                string3 = n4 < 0 ? "/" : string3.substring(n4);
            }
        }
        string3 = org.apache.tomcat.util.http.RequestUtil.normalize((String)string3);
        String string5 = httpServletRequest.getContextPath();
        if (string5 != null && string3.startsWith(string5)) {
            string3 = string3.substring(string5.length());
        }
        if ((string2 = httpServletRequest.getPathInfo()) != null && (string = httpServletRequest.getServletPath()) != null && string3.startsWith(string)) {
            string3 = string3.substring(string.length());
        }
        if (this.debug > 0) {
            this.log("Dest path :" + string3);
        }
        if (this.isSpecialPath(string3)) {
            httpServletResponse.sendError(403);
            return false;
        }
        String string6 = this.getRelativePath(httpServletRequest);
        if (string3.equals(string6)) {
            httpServletResponse.sendError(403);
            return false;
        }
        boolean bl2 = true;
        String string7 = httpServletRequest.getHeader("Overwrite");
        if (string7 != null) {
            bl2 = string7.equalsIgnoreCase("T");
        }
        boolean bl3 = true;
        try {
            this.resources.lookup(string3);
        }
        catch (NamingException namingException) {
            bl3 = false;
        }
        if (bl2) {
            if (bl3) {
                if (!this.deleteResource(string3, httpServletRequest, httpServletResponse, true)) {
                    return false;
                }
            } else {
                httpServletResponse.setStatus(201);
            }
        } else if (bl3) {
            httpServletResponse.sendError(412);
            return false;
        }
        if (!(bl = this.copyResource(this.resources, hashtable = new Hashtable<String, Integer>(), string6, string3)) || !hashtable.isEmpty()) {
            if (hashtable.size() == 1) {
                httpServletResponse.sendError(hashtable.elements().nextElement().intValue());
            } else {
                this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            }
            return false;
        }
        if (bl3) {
            httpServletResponse.setStatus(204);
        } else {
            httpServletResponse.setStatus(201);
        }
        this.lockNullResources.remove(string3);
        return true;
    }

    private boolean copyResource(DirContext dirContext, Hashtable<String, Integer> hashtable, String string, String string2) {
        if (this.debug > 1) {
            this.log("Copy: " + string + " To: " + string2);
        }
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object instanceof DirContext) {
            try {
                dirContext.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                hashtable.put(string2, 409);
                return false;
            }
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list(string);
                while (namingEnumeration.hasMoreElements()) {
                    NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    String string3 = string2;
                    if (!string3.equals("/")) {
                        string3 = string3 + "/";
                    }
                    string3 = string3 + nameClassPair.getName();
                    String string4 = string;
                    if (!string4.equals("/")) {
                        string4 = string4 + "/";
                    }
                    string4 = string4 + nameClassPair.getName();
                    this.copyResource(dirContext, hashtable, string4, string3);
                }
            }
            catch (NamingException namingException) {
                hashtable.put(string2, 500);
                return false;
            }
        }
        if (object instanceof Resource) {
            if (string2.endsWith("/") && string2.length() > 1) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            try {
                dirContext.bind(string2, object);
            }
            catch (NamingException namingException) {
                if (namingException.getCause() instanceof FileNotFoundException) {
                    hashtable.put(string, 409);
                } else {
                    hashtable.put(string, 500);
                }
                return false;
            }
        } else {
            hashtable.put(string, 500);
            return false;
        }
        return true;
    }

    private boolean deleteResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = this.getRelativePath(httpServletRequest);
        return this.deleteResource(string, httpServletRequest, httpServletResponse, true);
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        String string2;
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        if (this.isLocked(string, string3 + string2)) {
            httpServletResponse.sendError(423);
            return false;
        }
        boolean bl2 = true;
        Object object = null;
        try {
            object = this.resources.lookup(string);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (!bl2) {
            httpServletResponse.sendError(404);
            return false;
        }
        boolean bl3 = object instanceof DirContext;
        if (!bl3) {
            try {
                this.resources.unbind(string);
            }
            catch (NamingException namingException) {
                httpServletResponse.sendError(500);
                return false;
            }
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        this.deleteCollection(httpServletRequest, this.resources, string, hashtable);
        try {
            this.resources.unbind(string);
        }
        catch (NamingException namingException) {
            hashtable.put(string, 500);
        }
        if (!hashtable.isEmpty()) {
            this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            return false;
        }
        if (bl) {
            httpServletResponse.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest httpServletRequest, DirContext dirContext, String string, Hashtable<String, Integer> hashtable) {
        String string2;
        if (this.debug > 1) {
            this.log("Delete:" + string);
        }
        if (this.isSpecialPath(string)) {
            hashtable.put(string, 403);
            return;
        }
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        NamingEnumeration<NameClassPair> namingEnumeration = null;
        try {
            namingEnumeration = dirContext.list(string);
        }
        catch (NamingException namingException) {
            hashtable.put(string, 500);
            return;
        }
        while (namingEnumeration.hasMoreElements()) {
            NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
            String string4 = string;
            if (!string4.equals("/")) {
                string4 = string4 + "/";
            }
            if (this.isLocked(string4 = string4 + nameClassPair.getName(), string3 + string2)) {
                hashtable.put(string4, 423);
                continue;
            }
            try {
                Object object = dirContext.lookup(string4);
                if (object instanceof DirContext) {
                    this.deleteCollection(httpServletRequest, dirContext, string4, hashtable);
                }
                try {
                    dirContext.unbind(string4);
                }
                catch (NamingException namingException) {
                    if (object instanceof DirContext) continue;
                    hashtable.put(string4, 500);
                }
            }
            catch (NamingException namingException) {
                hashtable.put(string4, 500);
            }
        }
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable<String, Integer> hashtable) throws IOException {
        Object object;
        httpServletResponse.setStatus(207);
        String string = httpServletRequest.getRequestURI();
        String string2 = this.getRelativePath(httpServletRequest);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            int n = hashtable.get(object);
            xMLWriter.writeElement("D", "response", 0);
            xMLWriter.writeElement("D", "href", 0);
            String string3 = ((String)object).substring(string2.length());
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            xMLWriter.writeText(string + string3);
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", "status", 0);
            xMLWriter.writeText("HTTP/1.1 " + n + " " + WebdavStatus.getStatusText(n));
            xMLWriter.writeElement("D", "status", 1);
            xMLWriter.writeElement("D", "response", 1);
        }
        xMLWriter.writeElement("D", "multistatus", 1);
        object = httpServletResponse.getWriter();
        ((Writer)object).write(xMLWriter.toString());
        ((Writer)object).close();
    }

    private void parseProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, Vector<String> vector) {
        if (this.isSpecialPath(string)) {
            return;
        }
        CacheEntry cacheEntry = this.resources.lookupCache(string);
        if (!cacheEntry.exists) {
            return;
        }
        String string2 = httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
        string2 = string2.endsWith("/") && string.startsWith("/") ? string2 + string.substring(1) : string2 + string;
        if (cacheEntry.context != null && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        String string3 = this.rewriteUrl(string2);
        this.generatePropFindResponse(xMLWriter, string3, string, n, vector, cacheEntry.context == null, false, cacheEntry.attributes.getCreation(), cacheEntry.attributes.getLastModified(), cacheEntry.attributes.getContentLength(), this.getServletContext().getMimeType(cacheEntry.name), this.generateETag(cacheEntry.attributes));
    }

    private void parseLockNullProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, Vector<String> vector) {
        if (this.isSpecialPath(string)) {
            return;
        }
        LockInfo lockInfo = this.resourceLocks.get(string);
        if (lockInfo == null) {
            return;
        }
        String string2 = httpServletRequest.getRequestURI();
        String string3 = this.getRelativePath(httpServletRequest);
        String string4 = string.substring(string3.length());
        if (!string4.startsWith("/")) {
            string4 = "/" + string4;
        }
        String string5 = this.rewriteUrl(org.apache.tomcat.util.http.RequestUtil.normalize((String)(string2 + string4)));
        this.generatePropFindResponse(xMLWriter, string5, string, n, vector, true, true, lockInfo.creationDate.getTime(), lockInfo.creationDate.getTime(), 0L, "", "");
    }

    private void generatePropFindResponse(XMLWriter xMLWriter, String string, String string2, int n, Vector<String> vector, boolean bl, boolean bl2, long l, long l2, long l3, String string3, String string4) {
        xMLWriter.writeElement("D", "response", 0);
        String string5 = "HTTP/1.1 200 " + WebdavStatus.getStatusText(200);
        xMLWriter.writeElement("D", "href", 0);
        xMLWriter.writeText(string);
        xMLWriter.writeElement("D", "href", 1);
        String string6 = string2;
        int n2 = string2.lastIndexOf(47);
        if (n2 != -1) {
            string6 = string6.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeProperty("D", "creationdate", this.getISOCreationDate(l));
                xMLWriter.writeElement("D", "displayname", 0);
                xMLWriter.writeData(string6);
                xMLWriter.writeElement("D", "displayname", 1);
                if (bl) {
                    xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                    xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                    if (string3 != null) {
                        xMLWriter.writeProperty("D", "getcontenttype", string3);
                    }
                    xMLWriter.writeProperty("D", "getetag", string4);
                    if (bl2) {
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "lock-null", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                    } else {
                        xMLWriter.writeElement("D", "resourcetype", 2);
                    }
                } else {
                    xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                    xMLWriter.writeElement("D", "resourcetype", 0);
                    xMLWriter.writeElement("D", "collection", 2);
                    xMLWriter.writeElement("D", "resourcetype", 1);
                }
                xMLWriter.writeProperty("D", "source", "");
                String string7 = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                xMLWriter.writeElement("D", "supportedlock", 0);
                xMLWriter.writeText(string7);
                xMLWriter.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(string2, xMLWriter);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeElement("D", "creationdate", 2);
                xMLWriter.writeElement("D", "displayname", 2);
                if (bl) {
                    xMLWriter.writeElement("D", "getcontentlanguage", 2);
                    xMLWriter.writeElement("D", "getcontentlength", 2);
                    xMLWriter.writeElement("D", "getcontenttype", 2);
                    xMLWriter.writeElement("D", "getetag", 2);
                    xMLWriter.writeElement("D", "getlastmodified", 2);
                }
                xMLWriter.writeElement("D", "resourcetype", 2);
                xMLWriter.writeElement("D", "source", 2);
                xMLWriter.writeElement("D", "lockdiscovery", 2);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Object object;
                Vector<Object> vector2 = new Vector<Object>();
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                Enumeration<String> enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (((String)object).equals("creationdate")) {
                        xMLWriter.writeProperty("D", "creationdate", this.getISOCreationDate(l));
                        continue;
                    }
                    if (((String)object).equals("displayname")) {
                        xMLWriter.writeElement("D", "displayname", 0);
                        xMLWriter.writeData(string6);
                        xMLWriter.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (((String)object).equals("getcontentlanguage")) {
                        if (bl) {
                            xMLWriter.writeElement("D", "getcontentlanguage", 2);
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getcontentlength")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getcontenttype")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontenttype", string3);
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getetag")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getetag", string4);
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("getlastmodified")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                            continue;
                        }
                        vector2.addElement(object);
                        continue;
                    }
                    if (((String)object).equals("resourcetype")) {
                        if (bl) {
                            if (bl2) {
                                xMLWriter.writeElement("D", "resourcetype", 0);
                                xMLWriter.writeElement("D", "lock-null", 2);
                                xMLWriter.writeElement("D", "resourcetype", 1);
                                continue;
                            }
                            xMLWriter.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "collection", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (((String)object).equals("source")) {
                        xMLWriter.writeProperty("D", "source", "");
                        continue;
                    }
                    if (((String)object).equals("supportedlock")) {
                        String string8 = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        xMLWriter.writeElement("D", "supportedlock", 0);
                        xMLWriter.writeText(string8);
                        xMLWriter.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (((String)object).equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string2, xMLWriter)) continue;
                        vector2.addElement(object);
                        continue;
                    }
                    vector2.addElement(object);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                object = vector2.elements();
                if (!object.hasMoreElements()) break;
                string5 = "HTTP/1.1 404 " + WebdavStatus.getStatusText(404);
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                while (object.hasMoreElements()) {
                    xMLWriter.writeElement("D", (String)object.nextElement(), 2);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
            }
        }
        xMLWriter.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String string, XMLWriter xMLWriter) {
        LockInfo lockInfo = this.resourceLocks.get(string);
        Enumeration<LockInfo> enumeration = this.collectionLocks.elements();
        boolean bl = false;
        if (lockInfo != null) {
            bl = true;
            xMLWriter.writeElement("D", "lockdiscovery", 0);
            lockInfo.toXML(xMLWriter);
        }
        while (enumeration.hasMoreElements()) {
            LockInfo lockInfo2 = enumeration.nextElement();
            if (!string.startsWith(lockInfo2.path)) continue;
            if (!bl) {
                bl = true;
                xMLWriter.writeElement("D", "lockdiscovery", 0);
            }
            lockInfo2.toXML(xMLWriter);
        }
        if (!bl) {
            return false;
        }
        xMLWriter.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long l) {
        return creationDateFormat.format(new Date(l));
    }

    @Override
    protected String determineMethodsAllowed(HttpServletRequest httpServletRequest) {
        boolean bl = true;
        Object object = null;
        try {
            object = this.resources.lookup(this.getRelativePath(httpServletRequest));
        }
        catch (NamingException namingException) {
            bl = false;
        }
        StringBuilder stringBuilder = new StringBuilder("OPTIONS, GET, POST, HEAD");
        if (!this.readOnly) {
            stringBuilder.append(", DELETE");
            if (!(object instanceof DirContext)) {
                stringBuilder.append(", PUT");
            }
        }
        if (httpServletRequest instanceof RequestFacade && ((RequestFacade)httpServletRequest).getAllowTrace()) {
            stringBuilder.append(", TRACE");
        }
        stringBuilder.append(", LOCK, UNLOCK, PROPPATCH, COPY, MOVE");
        if (this.listings) {
            stringBuilder.append(", PROPFIND");
        }
        if (!bl) {
            stringBuilder.append(", MKCOL");
        }
        return stringBuilder.toString();
    }

    static {
        URL_ENCODER_XML.removeSafeCharacter('&');
        creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
        md5Encoder = new MD5Encoder();
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        public WebdavResolver(ServletContext servletContext) {
            this.context = servletContext;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.externalEntityIgnored", new Object[]{string, string2}));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector<String> tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public LockInfo(int n) {
            this.maxDepth = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Type:");
            stringBuilder.append(this.type);
            stringBuilder.append("\nScope:");
            stringBuilder.append(this.scope);
            stringBuilder.append("\nDepth:");
            stringBuilder.append(this.depth);
            stringBuilder.append("\nOwner:");
            stringBuilder.append(this.owner);
            stringBuilder.append("\nExpiration:");
            stringBuilder.append(FastHttpDateFormat.formatDate((long)this.expiresAt));
            Enumeration<String> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                stringBuilder.append("\nToken:");
                stringBuilder.append(enumeration.nextElement());
            }
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter xMLWriter) {
            xMLWriter.writeElement("D", "activelock", 0);
            xMLWriter.writeElement("D", "locktype", 0);
            xMLWriter.writeElement("D", this.type, 2);
            xMLWriter.writeElement("D", "locktype", 1);
            xMLWriter.writeElement("D", "lockscope", 0);
            xMLWriter.writeElement("D", this.scope, 2);
            xMLWriter.writeElement("D", "lockscope", 1);
            xMLWriter.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                xMLWriter.writeText("Infinity");
            } else {
                xMLWriter.writeText("0");
            }
            xMLWriter.writeElement("D", "depth", 1);
            xMLWriter.writeElement("D", "owner", 0);
            xMLWriter.writeText(this.owner);
            xMLWriter.writeElement("D", "owner", 1);
            xMLWriter.writeElement("D", "timeout", 0);
            long l = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            xMLWriter.writeText("Second-" + l);
            xMLWriter.writeElement("D", "timeout", 1);
            xMLWriter.writeElement("D", "locktoken", 0);
            Enumeration<String> enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                xMLWriter.writeElement("D", "href", 0);
                xMLWriter.writeText("opaquelocktoken:" + enumeration.nextElement());
                xMLWriter.writeElement("D", "href", 1);
            }
            xMLWriter.writeElement("D", "locktoken", 1);
            xMLWriter.writeElement("D", "activelock", 1);
        }
    }
}

