/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.memory;

import com.sun.tools.visualvm.sampler.AbstractSamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemorySamplerSupport;
import com.sun.tools.visualvm.sampler.memory.MemoryView;
import com.sun.tools.visualvm.sampler.memory.ThreadsMemoryInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadInfo;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class ThreadsMemoryView
extends JPanel {
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private final MemoryMXBean memoryBean;
    private final MemorySamplerSupport.HeapDumper heapDumper;
    private List<ThreadInfo> threads;
    private List<Long> allocatedBytes;
    private List<Long> allocatedBytesPerSec;
    private ThreadsMemoryInfo currentThreadsInfo;
    private ThreadsMemoryInfo baseThreadsInfo;
    private int totalThreads = -1;
    private long totalBytes = -1L;
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private ProfilerToolbar toolbar;
    private AbstractButton gcButton;
    private AbstractButton heapdumpButton;
    private boolean popupPause;
    private JComponent bottomPanel;
    private JComponent filterPanel;
    private JComponent searchPanel;
    private NumberRenderer threadsCount;
    private NumberRenderer threadsTotalBytes;
    private TreadsAllocTableModel tableModel;
    private ProfilerTable table;
    private HideableBarRenderer[] renderers;
    private static final String COL_NAME = NbBundle.getMessage(MemoryView.class, (String)"COL_Thread_name");
    private static final String COL_BYTES = NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes");
    private static final String COL_BYTES_SEC = NbBundle.getMessage(MemoryView.class, (String)"COL_ABytes_Sec");

    ThreadsMemoryView(AbstractSamplerSupport.Refresher refresher, MemoryMXBean memoryBean, MemorySamplerSupport.HeapDumper heapDumper) {
        this.refresher = refresher;
        this.memoryBean = memoryBean;
        this.heapDumper = heapDumper;
        this.threads = Collections.EMPTY_LIST;
        this.allocatedBytes = Collections.EMPTY_LIST;
        this.allocatedBytesPerSec = Collections.EMPTY_LIST;
        this.initComponents();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && ThreadsMemoryView.this.isShowing()) {
                    ThreadsMemoryView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
    }

    boolean isPaused() {
        return this.lrPauseButton.isSelected() && !this.forceRefresh;
    }

    boolean isEmpty() {
        return this.tableModel.getRowCount() == 0;
    }

    void refresh(ThreadsMemoryInfo info) {
        if (this.isPaused()) {
            return;
        }
        this.forceRefresh = false;
        this.threads = info.getThreads();
        this.allocatedBytes = info.getAllocatedBytes();
        this.totalBytes = info.getTotalBytes();
        if (this.currentThreadsInfo != null) {
            this.allocatedBytesPerSec = this.currentThreadsInfo.getAllocatedBytesPerSecond(info);
            this.renderers[1].setMaxValue(this.currentThreadsInfo.getTotalAllocatedBytesPerSecond());
        }
        this.currentThreadsInfo = info;
        boolean diff = this.lrDeltasButton.isSelected();
        if (diff) {
            if (this.baseThreadsInfo == null) {
                this.baseThreadsInfo = info;
            }
            this.totalThreads = this.threads.size() - this.baseThreadsInfo.getThreads().size();
            this.allocatedBytes = this.baseThreadsInfo.getAllocatedDiffBytes(info);
            this.totalBytes = this.baseThreadsInfo.getTotalDiffBytes();
        } else {
            if (this.baseThreadsInfo != null) {
                this.baseThreadsInfo = null;
            }
            this.allocatedBytes = info.getAllocatedBytes();
            this.totalBytes = info.getTotalBytes();
            this.totalThreads = this.threads.size();
        }
        this.renderers[0].setDiffMode(diff);
        this.renderers[0].setMaxValue(this.totalBytes);
        this.threadsCount.setDiffMode(diff);
        this.threadsCount.setValue((Object)this.totalThreads, -1);
        this.threadsTotalBytes.setDiffMode(diff);
        this.threadsTotalBytes.setValue((Object)this.totalBytes, -1);
        this.tableModel.fireTableDataChanged();
    }

    void starting() {
        this.lrPauseButton.setEnabled(true);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(true);
    }

    void stopping() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
    }

    void terminated() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
        this.gcButton.setEnabled(false);
        this.heapdumpButton.setEnabled(false);
    }

    private void initComponents() {
        this.tableModel = new TreadsAllocTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                popup.add(this.createCopyMenuItem());
                popup.addSeparator();
                popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ThreadsMemoryView.this.activateFilter();
                    }
                });
                popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ThreadsMemoryView.this.activateSearch();
                    }
                });
            }

            protected void popupShowing() {
                if (ThreadsMemoryView.this.lrPauseButton.isEnabled() && !ThreadsMemoryView.this.lrRefreshButton.isEnabled()) {
                    ThreadsMemoryView.this.popupPause = true;
                    ThreadsMemoryView.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (ThreadsMemoryView.this.lrPauseButton.isEnabled() && ThreadsMemoryView.this.popupPause) {
                    ThreadsMemoryView.this.popupPause = false;
                    ThreadsMemoryView.this.lrPauseButton.setSelected(false);
                }
            }
        };
        this.table.setColumnToolTips(new String[]{NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_TOOLTIP_Col_name"), NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_TOOLTIP_Col_bytes"), NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_TOOLTIP_Col_bytessec")});
        this.table.providePopupMenu(true);
        this.table.setMainColumn(0);
        this.table.setFitWidthColumn(0);
        this.table.setSortColumn(1);
        this.table.setDefaultSortOrder(1, SortOrder.DESCENDING);
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[0].setBarDiffMode(HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL);
        this.renderers[1] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1].setBarDiffMode(HideableBarRenderer.BarDiffMode.MODE_BAR_NORMAL);
        LabelRenderer threadRenderer = new LabelRenderer();
        threadRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
        threadRenderer.setFont(threadRenderer.getFont().deriveFont(1));
        this.table.setColumnRenderer(0, (ProfilerRenderer)threadRenderer);
        this.table.setColumnRenderer(1, (ProfilerRenderer)this.renderers[0]);
        this.table.setColumnRenderer(2, (ProfilerRenderer)this.renderers[1]);
        long refTime = 12345678L;
        this.renderers[0].setMaxValue(refTime);
        this.renderers[1].setMaxValue(refTime);
        this.table.setDefaultColumnWidth(1, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(2, this.renderers[1].getOptimalWidth());
        this.renderers[1].setMaxValue(1000000L);
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        this.lrLabel = new GrayLabel(NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_LBL_Results"));
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                ThreadsMemoryView.this.lrRefreshButton.setEnabled(paused && !ThreadsMemoryView.this.popupPause);
                if (!paused) {
                    ThreadsMemoryView.this.refresher.refresh();
                }
            }
        };
        this.lrPauseButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Pause_results"));
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                ThreadsMemoryView.this.forceRefresh = true;
                ThreadsMemoryView.this.refresher.refresh();
            }
        };
        this.lrRefreshButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Update_results"));
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!ThreadsMemoryView.this.lrPauseButton.isSelected()) {
                    ThreadsMemoryView.this.forceRefresh = true;
                    ThreadsMemoryView.this.refresher.refresh();
                }
            }
        };
        this.lrDeltasButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Deltas"));
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrLabel);
        this.toolbar.addSpace(2);
        this.toolbar.add((Component)this.lrPauseButton);
        this.toolbar.add((Component)this.lrRefreshButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)this.lrDeltasButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_LBL_Statistics")));
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new JLabel(NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_LBL_TCount")));
        final Dimension tcDim = new Dimension(-1, -1);
        final JLabel threadsCountL = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (tcDim.width >= 0) {
                    dim.width = Math.max(dim.width, tcDim.width);
                    dim.height = Math.max(dim.height, tcDim.height);
                }
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.threadsCount = new NumberRenderer(){

            public void setText(String text) {
                super.setText(text);
                threadsCountL.setText(super.getText());
            }
        };
        this.threadsCount.setDiffMode(true);
        this.threadsCount.setValue((Object)99, -1);
        tcDim.setSize(threadsCountL.getPreferredSize());
        this.threadsCount.setDiffMode(false);
        this.threadsCount.setValue((Object)0, -1);
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)threadsCountL);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new JLabel(NbBundle.getMessage(ThreadsMemoryView.class, (String)"ThreadsMemoryView_LBL_Total_bytes")));
        final JLabel threadsTotalBytesL = new JLabel();
        this.threadsTotalBytes = new NumberRenderer(Formatters.bytesFormat()){

            public void setText(String text) {
                super.setText(text);
                threadsTotalBytesL.setText(super.getText());
            }
        };
        this.toolbar.addSpace(3);
        this.toolbar.add((Component)threadsTotalBytesL);
        this.toolbar.addFiller();
        this.gcButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Gc")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                new RequestProcessor("GC Processor").post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ThreadsMemoryView.this.memoryBean.gc();
                        }
                        catch (Exception e) {
                            this.setEnabled(false);
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width += 5;
                return dim;
            }
        };
        this.gcButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Gc"));
        this.gcButton.setOpaque(false);
        this.gcButton.setEnabled(this.heapDumper != null);
        this.toolbar.add((Component)this.gcButton);
        this.heapdumpButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_HeapDump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                ThreadsMemoryView.this.heapDumper.takeHeapDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width += 5;
                return dim;
            }
        };
        this.heapdumpButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_HeapDump"));
        this.heapdumpButton.setOpaque(false);
        this.heapdumpButton.setEnabled(this.heapDumper != null);
        this.toolbar.add((Component)this.heapdumpButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar.getComponent(), "North");
        this.add((Component)tableContainer, "Center");
    }

    private JComponent getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FilterFindLayout());
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setBackground(UIManager.getColor("controlShadow"));
            this.add((Component)this.bottomPanel, "South");
        }
        return this.bottomPanel;
    }

    private void activateFilter() {
        JComponent panel = this.getBottomPanel();
        if (this.filterPanel == null) {
            this.filterPanel = FilterUtils.createFilterPanel((ProfilerTable)this.table, null);
            panel.add(this.filterPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.filterPanel.setVisible(true);
        this.filterPanel.requestFocusInWindow();
    }

    private void activateSearch() {
        JComponent panel = this.getBottomPanel();
        if (this.searchPanel == null) {
            this.searchPanel = SearchUtils.createSearchPanel((ProfilerTable)this.table);
            panel.add(this.searchPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.searchPanel.setVisible(true);
        this.searchPanel.requestFocusInWindow();
    }

    private final class FilterFindLayout
    implements LayoutManager {
        private FilterFindLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = ThreadsMemoryView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = ThreadsMemoryView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getPreferredSize();
                Dimension dim2 = search.getPreferredSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getPreferredSize();
            } else if (search != null) {
                dim = search.getPreferredSize();
            }
            if (filter != null || search != null) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = ThreadsMemoryView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = ThreadsMemoryView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getMinimumSize();
                Dimension dim2 = search.getMinimumSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getMinimumSize();
            } else if (search != null) {
                dim = search.getMinimumSize();
            }
            if (filter != null || search != null) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            JComponent search;
            JComponent filter = ThreadsMemoryView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = ThreadsMemoryView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            int bottomOffset = 0;
            if (filter != null && search != null) {
                Dimension size = parent.getSize();
                int w = (size.width - 1) / 2;
                filter.setBounds(0, 0, w, size.height - bottomOffset);
                search.setBounds(w + 1, 0, size.width - w - 1, size.height - bottomOffset);
            } else if (filter != null) {
                Dimension size = parent.getSize();
                filter.setBounds(0, 0, size.width, size.height - bottomOffset);
            } else if (search != null) {
                Dimension size = parent.getSize();
                search.setBounds(0, 0, size.width, size.height - bottomOffset);
            }
        }
    }

    private class TreadsAllocTableModel
    extends AbstractTableModel {
        private TreadsAllocTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return COL_NAME;
            }
            if (columnIndex == 1) {
                return COL_BYTES;
            }
            if (columnIndex == 2) {
                return COL_BYTES_SEC;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return ThreadsMemoryView.this.threads.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((ThreadInfo)ThreadsMemoryView.this.threads.get(rowIndex)).getThreadName();
            }
            if (columnIndex == 1) {
                return (long)((Long)ThreadsMemoryView.this.allocatedBytes.get(rowIndex));
            }
            if (columnIndex == 2) {
                return ThreadsMemoryView.this.allocatedBytesPerSec.isEmpty() ? 0L : (Long)ThreadsMemoryView.this.allocatedBytesPerSec.get(rowIndex);
            }
            return null;
        }
    }
}

