/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi;

import java.io.PrintStream;
import org.a11y.brlapi.Connection;
import org.a11y.brlapi.ConnectionSettings;
import org.a11y.brlapi.Constants;
import org.a11y.brlapi.DisplaySize;
import org.a11y.brlapi.Key;
import org.a11y.brlapi.LibraryVersion;

public class TestProgram
implements Constants {
    private static void writeProperty(String string, String string2, Object ... objectArray) {
        PrintStream printStream = System.out;
        printStream.print(string);
        printStream.print(": ");
        printStream.print(String.format(string2, objectArray));
        printStream.println();
    }

    private static void showKey(Key key, Connection connection) {
        String string = String.format("code=0X%X type=%X cmd=%X arg=%X flg=%X", key.getKeyCode(), key.getTypeValue(), key.getCommandValue(), key.getArgumentValue(), key.getFlagsValue());
        TestProgram.writeProperty("Key", string, new Object[0]);
        if (connection != null) {
            connection.writeText(string);
        }
    }

    private static void showKey(Key key) {
        TestProgram.showKey(key, null);
    }

    private static void syntaxError(String string) {
        System.err.println(string);
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        ConnectionSettings connectionSettings = new ConnectionSettings();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            if ((string = stringArray[n2++]).equals("-host")) {
                if (n2 == n) {
                    TestProgram.syntaxError("missing host specification");
                }
                connectionSettings.setServerHost(stringArray[n2++]);
                continue;
            }
            TestProgram.syntaxError("unrecognized option: " + string);
        }
        TestProgram.writeProperty("Library Version", "%d.%d.%d", LibraryVersion.getMajor(), LibraryVersion.getMinor(), LibraryVersion.getRevision());
        try {
            Connection connection = new Connection(connectionSettings);
            try {
                TestProgram.writeProperty("File Descriptor", "%d", connection.getFileDescriptor());
                TestProgram.writeProperty("Server Host", "%s", connection.getServerHost());
                TestProgram.writeProperty("Authorization Schemes", "%s", connection.getAuthorizationSchemes());
                TestProgram.writeProperty("Driver Name", "%s", connection.getDriverName());
                TestProgram.writeProperty("Model Identifier", "%s", connection.getModelIdentifier());
                DisplaySize displaySize = connection.getDisplaySize();
                TestProgram.writeProperty("Display Size", "%dx%d", displaySize.getWidth(), displaySize.getHeight());
                int n3 = connection.enterTtyMode();
                try {
                    long l;
                    TestProgram.writeProperty("TTY Number", "%d", n3);
                    long[] lArray = new long[]{0L};
                    connection.ignoreKeys(0L, lArray);
                    lArray[0] = 0x20000000L;
                    connection.acceptKeys(1L, lArray);
                    long[][] lArrayArray = new long[][]{{0L, 2L}, {5L, 7L}};
                    connection.ignoreKeyRanges(lArrayArray);
                    int n4 = 10;
                    connection.writeText(String.format("press keys (timeout is %d seconds)", n4), 0);
                    while ((l = connection.readKeyWithTimeout(n4 * 1000)) >= 0L) {
                        TestProgram.showKey(new Key(l), connection);
                    }
                }
                finally {
                    connection.leaveTtyMode();
                }
            }
            finally {
                connection.closeConnection();
                connection = null;
            }
        }
        catch (Error error) {
            System.out.println("got error: " + error);
            System.exit(3);
        }
    }
}

