/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.cpu.CPUJavaNameRenderer;
import org.netbeans.lib.profiler.ui.cpu.CPUView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.McsTimeRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class CPUTreeTableView
extends CPUView {
    private CPUTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private Map<Integer, ClientUtils.SourceCodeSelection> idMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private final boolean reverse;
    private boolean sampled = true;
    private boolean twoTimeStamps;
    private boolean hitsVisible = false;
    private boolean invocationsVisible = true;
    private boolean filterTopMethods = true;
    private boolean filterCallerMethods = false;
    private boolean searchTopMethods = true;
    private boolean searchCallerMethods = false;
    private HideableBarRenderer[] renderers;

    public CPUTreeTableView(Set<ClientUtils.SourceCodeSelection> set, boolean bl) {
        this.selection = set;
        this.reverse = bl;
        this.initUI();
    }

    void setData(CPUResultsSnapshot cPUResultsSnapshot, Map<Integer, ClientUtils.SourceCodeSelection> map, int n, Collection<Integer> collection, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        boolean bl4 = this.sampled != bl2;
        this.sampled = bl2;
        boolean bl5 = this.twoTimeStamps;
        this.twoTimeStamps = cPUResultsSnapshot == null ? !bl5 : cPUResultsSnapshot.isCollectingTwoTimeStamps();
        this.idMap = map;
        this.renderers[0].setDiffMode(bl3);
        this.renderers[1].setDiffMode(bl3);
        this.renderers[2].setDiffMode(bl3);
        if (this.treeTableModel != null) {
            this.treeTableModel.setRoot((TreeNode)(cPUResultsSnapshot == null ? PrestimeCPUCCTNode.EMPTY : (!this.reverse ? cPUResultsSnapshot.getRootNode(n, collection, bl) : cPUResultsSnapshot.getReverseRootNode(n, collection, bl))));
        }
        if (bl4) {
            n2 = this.treeTable.convertColumnIndexToView(this.selection == null ? 3 : 4);
            String string = this.treeTableModel.getColumnName(this.selection == null ? 3 : 4);
            if (this.sampled) {
                this.invocationsVisible = this.treeTable.isColumnVisible(n2);
            } else {
                this.hitsVisible = this.treeTable.isColumnVisible(n2);
            }
            this.treeTable.getColumnModel().getColumn(n2).setHeaderValue(string);
            this.treeTable.setColumnVisibility(n2, this.sampled ? this.hitsVisible : this.invocationsVisible);
            this.setToolTips();
            this.repaint();
        }
        if (cPUResultsSnapshot != null && this.twoTimeStamps != bl5) {
            n2 = this.selection == null ? 2 : 3;
            boolean bl6 = this.treeTable.isColumnVisible(n2);
            if (this.twoTimeStamps && !bl6) {
                this.treeTable.setColumnVisibility(n2, true);
            } else if (!this.twoTimeStamps && bl6) {
                this.treeTable.setColumnVisibility(n2, false);
            }
        }
    }

    public void resetData() {
        this.setData(null, null, -1, null, false, this.sampled, false);
    }

    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        String string;
        String string2 = string = this.reverse ? EXPORT_REVERSE_CALLS : EXPORT_FORWARD_CALLS;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, string);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, string);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    HideableBarRenderer.BarDiffMode barDiffMode() {
        return HideableBarRenderer.BarDiffMode.MODE_BAR_DIFF;
    }

    private void initUI() {
        int n;
        this.treeTableModel = new CPUTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        int n2 = this.selection == null ? -1 : 0;
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{1 + n2}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return CPUTreeTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                CPUTreeTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                CPUTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                CPUTreeTableView.this.popupHidden();
            }
        };
        this.setToolTips();
        this.treeTable.providePopupMenu(true);
        this.installDefaultAction();
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(1 + n2);
        this.treeTable.setFitWidthColumn(1 + n2);
        this.treeTable.setSortColumn(2 + n2);
        this.treeTable.setDefaultSortOrder(1 + n2, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.treeTable.setColumnVisibility(0, false);
        }
        this.treeTable.setColumnVisibility(4 + n2, false);
        this.renderers = new HideableBarRenderer[3];
        HideableBarRenderer.BarDiffMode barDiffMode = this.barDiffMode();
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer())){

            @Override
            public void setValue(Object object, int n) {
                super.setMaxValue(CPUTreeTableView.this.getMaxValue(n, 0));
                super.setValue(object, n);
            }
        };
        this.renderers[0].setBarDiffMode(barDiffMode);
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer(new McsTimeRenderer())){

            @Override
            public void setValue(Object object, int n) {
                super.setMaxValue(CPUTreeTableView.this.getMaxValue(n, 1));
                super.setValue(object, n);
            }
        };
        this.renderers[1].setBarDiffMode(barDiffMode);
        this.renderers[2] = new HideableBarRenderer(new NumberRenderer()){

            @Override
            public void setValue(Object object, int n) {
                super.setMaxValue(CPUTreeTableView.this.getMaxValue(n, 2));
                super.setValue(object, n);
            }
        };
        this.renderers[2].setBarDiffMode(barDiffMode);
        long l = 123456L;
        this.renderers[0].setMaxValue(l);
        this.renderers[1].setMaxValue(l);
        this.renderers[2].setMaxValue(l);
        if (this.selection != null) {
            this.treeTable.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object object, int n) {
                    TreePath treePath = CPUTreeTableView.this.treeTable.getPathForRow(n);
                    this.visible = CPUTreeTableView.isSelectable((PrestimeCPUCCTNode)treePath.getLastPathComponent());
                    if (this.visible) {
                        super.setValue(object, n);
                    }
                }

                @Override
                public void paint(Graphics graphics) {
                    if (this.visible) {
                        super.paint(graphics);
                    } else {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.treeTable.setTreeCellRenderer(new CPUJavaNameRenderer(this.reverse ? "ProfilerIcons.NodeReverse" : "ProfilerIcons.NodeForward"));
        this.treeTable.setColumnRenderer(2 + n2, this.renderers[0]);
        this.treeTable.setColumnRenderer(3 + n2, this.renderers[1]);
        this.treeTable.setColumnRenderer(4 + n2, this.renderers[2]);
        if (this.selection != null) {
            n = new JLabel((String)this.treeTable.getColumnName((int)0)).getPreferredSize().width;
            this.treeTable.setDefaultColumnWidth(0, n + 15);
        }
        this.treeTable.setDefaultColumnWidth(2 + n2, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(3 + n2, this.renderers[1].getMaxNoBarWidth());
        this.sampled = !this.sampled;
        n = new JLabel((String)this.treeTable.getColumnName((int)(4 + n2))).getPreferredSize().width;
        this.sampled = !this.sampled;
        n = Math.max(n, new JLabel((String)this.treeTable.getColumnName((int)(4 + n2))).getPreferredSize().width);
        this.treeTable.setDefaultColumnWidth(4 + n2, Math.max(this.renderers[2].getNoBarWidth(), n + 15));
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    private void setToolTips() {
        String[] stringArray;
        if (this.selection == null) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray2[2] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[3] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = TOTAL_TIME_COLUMN_TOOLTIP;
            stringArray3[3] = TOTAL_TIME_CPU_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[4] = this.sampled ? HITS_COLUMN_TOOLTIP : INVOCATIONS_COLUMN_TOOLTIP;
        }
        this.treeTable.setColumnToolTips(stringArray);
    }

    @Override
    protected RowFilter getExcludesFilter() {
        if (!this.reverse) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)entry.getIdentifier();
                    return prestimeCPUCCTNode.isThreadNode() || prestimeCPUCCTNode.isSelfTimeNode();
                }
            };
        }
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)entry.getIdentifier();
                CCTNode cCTNode = prestimeCPUCCTNode.getParent();
                if (cCTNode == null) {
                    return true;
                }
                if (prestimeCPUCCTNode.isThreadNode() || prestimeCPUCCTNode.isSelfTimeNode()) {
                    return true;
                }
                if (((PrestimeCPUCCTNode)cCTNode).isThreadNode() || cCTNode.getParent() == null) {
                    return !CPUTreeTableView.this.filterTopMethods;
                }
                return !CPUTreeTableView.this.filterCallerMethods;
            }
        };
    }

    @Override
    protected Component[] getFilterOptions() {
        if (!this.reverse) {
            return super.getFilterOptions();
        }
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(CPUView.FILTER_CALLEES_SCOPE, CPUTreeTableView.this.filterTopMethods){
                    {
                        if (!CPUTreeTableView.this.filterCallerMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CPUTreeTableView.this.filterTopMethods = !CPUTreeTableView.this.filterTopMethods;
                        CPUTreeTableView.this.enableFilter();
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(CPUView.FILTER_CALLERS_SCOPE, CPUTreeTableView.this.filterCallerMethods){
                    {
                        if (!CPUTreeTableView.this.filterTopMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CPUTreeTableView.this.filterCallerMethods = !CPUTreeTableView.this.filterCallerMethods;
                        CPUTreeTableView.this.enableFilter();
                    }
                });
            }
        };
        popupButton.setToolTipText(FILTER_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        if (!this.reverse) {
            return super.getSearchHelper();
        }
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode treeNode) {
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treeNode;
                CCTNode cCTNode = prestimeCPUCCTNode.getParent();
                if (cCTNode == null) {
                    return 100;
                }
                if (prestimeCPUCCTNode.isThreadNode()) {
                    return 100;
                }
                if (prestimeCPUCCTNode.isSelfTimeNode()) {
                    return 101;
                }
                if (((PrestimeCPUCCTNode)cCTNode).isThreadNode() || cCTNode.getParent() == null) {
                    if (CPUTreeTableView.this.searchTopMethods) {
                        return CPUTreeTableView.this.searchCallerMethods ? 10 : 11;
                    }
                    return CPUTreeTableView.this.searchCallerMethods ? 100 : 101;
                }
                return CPUTreeTableView.this.searchCallerMethods ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        if (!this.reverse) {
            return super.getSearchOptions();
        }
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(CPUView.SEARCH_CALLEES_SCOPE, CPUTreeTableView.this.searchTopMethods){
                    {
                        if (!CPUTreeTableView.this.searchCallerMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CPUTreeTableView.this.searchTopMethods = !CPUTreeTableView.this.searchTopMethods;
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(CPUView.SEARCH_CALLERS_SCOPE, CPUTreeTableView.this.searchCallerMethods){
                    {
                        if (!CPUTreeTableView.this.searchTopMethods) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        CPUTreeTableView.this.searchCallerMethods = !CPUTreeTableView.this.searchCallerMethods;
                    }
                });
            }
        };
        popupButton.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    private long getMaxValue(int n, int n2) {
        TreePath treePath = this.treeTable.getPathForRow(n);
        if (treePath == null) {
            return Long.MIN_VALUE;
        }
        if (treePath.getPathCount() < 2) {
            return 1L;
        }
        PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treePath.getPathComponent(1);
        if (n2 == 0) {
            return Math.abs(prestimeCPUCCTNode.getTotalTime0());
        }
        if (n2 == 1) {
            return Math.abs(prestimeCPUCCTNode.getTotalTime1());
        }
        return Math.abs(prestimeCPUCCTNode.getNCalls());
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.treeTable.getValueForRow(n);
        if (prestimeCPUCCTNode == null) {
            return null;
        }
        if (prestimeCPUCCTNode.isThreadNode() || prestimeCPUCCTNode.isFiltered() || prestimeCPUCCTNode.isSelfTimeNode()) {
            return null;
        }
        return this.idMap.get(prestimeCPUCCTNode.getMethodId());
    }

    private static boolean isSelectable(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        if (prestimeCPUCCTNode.isThreadNode() || prestimeCPUCCTNode.isFiltered() || prestimeCPUCCTNode.isSelfTimeNode()) {
            return false;
        }
        return !prestimeCPUCCTNode.getMethodClassNameAndSig()[1].endsWith("[native]");
    }

    private class CPUTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        CPUTreeTableModel(TreeNode treeNode) {
            super(treeNode);
        }

        @Override
        public String getColumnName(int n) {
            if (CPUTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return CPUView.COLUMN_NAME;
            }
            if (n == 2) {
                return CPUView.COLUMN_TOTALTIME;
            }
            if (n == 3) {
                return CPUView.COLUMN_TOTALTIME_CPU;
            }
            if (n == 4) {
                return CPUTreeTableView.this.sampled ? CPUView.COLUMN_HITS : CPUView.COLUMN_INVOCATIONS;
            }
            if (n == 0) {
                return CPUView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (CPUTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return JTree.class;
            }
            if (n == 4) {
                return Integer.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return Long.class;
        }

        @Override
        public int getColumnCount() {
            return CPUTreeTableView.this.selection == null ? 4 : 5;
        }

        @Override
        public Object getValueAt(TreeNode treeNode, int n) {
            PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treeNode;
            if (CPUTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return prestimeCPUCCTNode.getNodeName();
            }
            if (n == 2) {
                return prestimeCPUCCTNode.getTotalTime0();
            }
            if (n == 3) {
                return CPUTreeTableView.this.twoTimeStamps ? prestimeCPUCCTNode.getTotalTime1() : 0L;
            }
            if (n == 4) {
                return prestimeCPUCCTNode.getNCalls();
            }
            if (n == 0) {
                if (CPUTreeTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return CPUTreeTableView.this.selection.contains(CPUTreeTableView.this.idMap.get(prestimeCPUCCTNode.getMethodId()));
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, TreeNode treeNode, int n) {
            if (CPUTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 0) {
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)treeNode;
                int n2 = prestimeCPUCCTNode.getMethodId();
                if (Boolean.TRUE.equals(object)) {
                    CPUTreeTableView.this.selection.add(CPUTreeTableView.this.idMap.get(n2));
                } else {
                    CPUTreeTableView.this.selection.remove(CPUTreeTableView.this.idMap.get(n2));
                }
            }
        }

        @Override
        public boolean isCellEditable(TreeNode treeNode, int n) {
            if (CPUTreeTableView.this.selection == null) {
                ++n;
            }
            if (n != 0) {
                return false;
            }
            return CPUTreeTableView.isSelectable((PrestimeCPUCCTNode)treeNode);
        }
    }
}

