/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class URIResolver {
    protected SVGOMDocument document;
    protected String documentURI;
    protected DocumentLoader documentLoader;

    public URIResolver(SVGDocument sVGDocument, DocumentLoader documentLoader) {
        this.document = (SVGOMDocument)sVGDocument;
        this.documentLoader = documentLoader;
    }

    public Element getElement(String string, Element element) throws MalformedURLException, IOException {
        Node node = this.getNode(string, element);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 9) {
            throw new IllegalArgumentException();
        }
        return (Element)node;
    }

    public Node getNode(String string, Element element) throws MalformedURLException, IOException, SecurityException {
        ParsedURL parsedURL;
        String string2;
        String string3 = this.getRefererBaseURI(element);
        if (string3 == null && string.charAt(0) == '#') {
            return this.getNodeByFragment(string.substring(1), element);
        }
        ParsedURL parsedURL2 = new ParsedURL(string3, string);
        if (this.documentURI == null) {
            this.documentURI = this.document.getURL();
        }
        if ((string2 = parsedURL2.getRef()) != null && this.documentURI != null && (parsedURL = new ParsedURL(this.documentURI)).sameFile(parsedURL2)) {
            return this.document.getElementById(string2);
        }
        parsedURL = null;
        if (this.documentURI != null) {
            parsedURL = new ParsedURL(this.documentURI);
        }
        UserAgent userAgent = this.documentLoader.getUserAgent();
        userAgent.checkLoadExternalResource(parsedURL2, parsedURL);
        String string4 = parsedURL2.toString();
        if (string2 != null) {
            string4 = string4.substring(0, string4.length() - (string2.length() + 1));
        }
        Document document = this.documentLoader.loadDocument(string4);
        if (string2 != null) {
            return document.getElementById(string2);
        }
        return document;
    }

    protected String getRefererBaseURI(Element element) {
        return ((AbstractNode)element).getBaseURI();
    }

    protected Node getNodeByFragment(String string, Element element) {
        return element.getOwnerDocument().getElementById(string);
    }
}

