package Lire::ChartTypes::VBars;

use strict;

use base qw/Lire::ChartType/;

use Locale::TextDomain 'lire';

=pod

=head1 NAME

Lire::ChartTypes::Lines - Wrapper for the Ploticus vbars prefab.

=head1 SYNOPSIS

  my $type = $chart_cfg->get( 'type' )->as_value();
  $type->write_chart( $chart_cfg, $subreport );

=head1 DESCRIPTION

This Lire::ChartType wraps the Ploticus vbars prefab.

=cut

sub name {
    return 'vbars';
}

sub title {
    return 'Vertical Bars Chart';
}

sub description {
    return '<para>' . __( 'Plot one or two variables as bars.' ) . '</para>';
}

sub prefab {
    return '-prefab vbars'
}

sub get_vars {
    my ( $self, $chart_cfg ) = @_;

     my $props = $chart_cfg->get('type')->get_properties();

    my @vars = ( $props->get( 'y' )->as_value() );
    push @vars, $props->get( 'y2' )->as_value()
      if $props->get( 'y2' )->is_valid();

    return \@vars;
}

sub write_parameters {
    my ( $self, $chart_cfg, $fh ) = @_;

    $self->SUPER::write_parameters( $chart_cfg, $fh );

     my $props = $chart_cfg->get('type')->get_properties();
    print $fh <<EOF;
#set stubvert = yes
#set barwidth = 0.05
#set sep = 0.08
#set y = 2
EOF
    print $fh "#set y2 = 3\n"
      if $props->get( 'y2' )->is_valid();
    print $fh "#set vals = yes\n"
      if $props->get( 'numbers' )->as_value();

    return;
}

# keep perl happy
1;

__END__

=pod

=head1 SEE ALSO

 Lire::PluginManager(3pm) Lire::ChartType(3pm), ploticus(1)

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: VBars.pm,v 1.3 2006/07/23 13:16:30 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut

