/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import java.util.Arrays;
import java.util.Comparator;

class TouchState {
    private static Comparator<Point> pointIdComparator = (point, point2) -> point.id - point2.id;
    private Point[] points = new Point[1];
    private int pointCount = 0;
    private int primaryID = -1;
    private MonocleWindow window;

    TouchState() {
    }

    MonocleWindow getWindow(boolean bl, MonocleWindow monocleWindow) {
        if (this.window == null) {
            this.window = monocleWindow;
        }
        if (bl) {
            Point point;
            this.window = monocleWindow;
            if (this.primaryID >= 0 && (point = this.getPointForID(this.primaryID)) != null) {
                this.window = MonocleWindowManager.getInstance().getWindowForLocation(point.x, point.y);
            }
        }
        return this.window;
    }

    Point getPoint(int n) {
        return this.points[n];
    }

    Point getPointForID(int n) {
        for (int i = 0; i < this.pointCount; ++i) {
            if (n != -1 && this.points[i].id != n) continue;
            return this.points[i];
        }
        return null;
    }

    int getPrimaryID() {
        return this.primaryID;
    }

    void assignPrimaryID() {
        if (this.pointCount == 0) {
            this.primaryID = -1;
        } else if (this.primaryID <= 0) {
            this.primaryID = this.points[0].id;
        } else {
            for (int i = 0; i < this.pointCount; ++i) {
                if (this.points[i].id != this.primaryID) continue;
                return;
            }
            this.primaryID = this.points[0].id;
        }
    }

    int getPointCount() {
        return this.pointCount;
    }

    void clear() {
        this.pointCount = 0;
    }

    void clearWindow() {
        this.window = null;
    }

    Point addPoint(Point point) {
        if (this.points.length == this.pointCount) {
            this.points = Arrays.copyOf(this.points, this.points.length * 2);
        }
        if (this.points[this.pointCount] == null) {
            this.points[this.pointCount] = new Point();
        }
        if (point != null) {
            point.copyTo(this.points[this.pointCount]);
        }
        return this.points[this.pointCount++];
    }

    void removePointForID(int n) {
        for (int i = 0; i < this.pointCount; ++i) {
            if (this.points[i].id != n) continue;
            if (i < this.pointCount - 1) {
                System.arraycopy(this.points, i + 1, this.points, i, this.pointCount - i - 1);
                this.points[this.pointCount - 1] = null;
            }
            --this.pointCount;
        }
    }

    void setPoint(int n, Point point) {
        if (n >= this.pointCount) {
            throw new IndexOutOfBoundsException();
        }
        point.copyTo(this.points[n]);
    }

    void copyTo(TouchState touchState) {
        touchState.clear();
        for (int i = 0; i < this.pointCount; ++i) {
            touchState.addPoint(this.points[i]);
        }
        touchState.primaryID = this.primaryID;
        touchState.window = this.window;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TouchState[" + this.pointCount);
        for (int i = 0; i < this.pointCount; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(this.points[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void sortPointsByID() {
        Arrays.sort(this.points, 0, this.pointCount, pointIdComparator);
    }

    boolean equalsSorted(TouchState touchState) {
        if (touchState.pointCount == this.pointCount && touchState.primaryID == this.primaryID && touchState.window == this.window) {
            for (int i = 0; i < this.pointCount; ++i) {
                Point point = touchState.points[i];
                Point point2 = this.points[i];
                if (point.x == point2.x && point.y == point2.y && point.id == point2.id) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean canBeFoldedWith(TouchState touchState, boolean bl) {
        if (touchState.pointCount != this.pointCount) {
            return false;
        }
        if (bl) {
            return true;
        }
        for (int i = 0; i < this.pointCount; ++i) {
            if (touchState.points[i].id == this.points[i].id) continue;
            return false;
        }
        return true;
    }

    static class Point {
        int id;
        int x;
        int y;

        Point() {
        }

        void copyTo(Point point) {
            point.id = this.id;
            point.x = this.x;
            point.y = this.y;
        }

        public String toString() {
            return "TouchState.Point[id=" + this.id + ",x=" + this.x + ",y=" + this.y + "]";
        }
    }
}

