/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.CreateBSSParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.JarSignature;
import com.sun.javafx.tools.packager.MakeAllParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.SignJarParams;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.resource.PackagerResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class PackagerLib {
    public static final String JAVAFX_VERSION = "8.0";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/javafx/tools/packager/Bundle");
    private CreateJarParams createJarParams;
    private CreateBSSParams createBssParams;
    private File bssTmpDir;
    private ClassLoader classLoader;
    private Set<String> alreadyAddedEntries = new HashSet<String>();

    private ClassLoader getClassLoader() throws PackagerException {
        if (this.classLoader == null) {
            try {
                URL[] uRLArray = new URL[]{new URL(this.getJfxrtPath())};
                this.classLoader = URLClassLoader.newInstance(uRLArray);
            }
            catch (MalformedURLException malformedURLException) {
                throw new PackagerException(malformedURLException, "ERR_CantFindRuntime", new String[0]);
            }
        }
        return this.classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File jarFileToUpdate(CreateJarParams createJarParams) {
        if (createJarParams.resources.size() != 1) return null;
        PackagerResource packagerResource = createJarParams.resources.get(0);
        File file2 = packagerResource.getFile();
        if (!file2.isFile()) return null;
        if (!file2.getAbsolutePath().toLowerCase().endsWith(".jar")) {
            return null;
        }
        try (JarFile jarFile = new JarFile(file2);){
            jarFile.getManifest();
            File file = file2;
            return file;
        }
        catch (Exception exception) {
            Log.verbose(exception);
        }
        return null;
    }

    public void packageAsJar(CreateJarParams createJarParams) throws PackagerException {
        Object object;
        Attributes attributes;
        Serializable serializable;
        Object object2;
        if (createJarParams == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        if (createJarParams.outfile == null) {
            throw new IllegalArgumentException("Output file is not specified");
        }
        this.createJarParams = createJarParams;
        Serializable serializable2 = this.jarFileToUpdate(createJarParams);
        Manifest manifest = null;
        if (serializable2 != null) {
            Log.info(MessageFormat.format(bundle.getString("MSG_UpdatingJar"), serializable2.getAbsolutePath()));
            try {
                object2 = new JarFile((File)serializable2);
                serializable = null;
                try {
                    manifest = ((JarFile)object2).getManifest();
                    if (manifest != null) {
                        attributes = manifest.getMainAttributes();
                        if (createJarParams.applicationClass == null) {
                            createJarParams.applicationClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
                        }
                        if (createJarParams.classpath == null) {
                            createJarParams.classpath = attributes.getValue(Attributes.Name.CLASS_PATH);
                        }
                        if (createJarParams.codebase == null) {
                            createJarParams.codebase = attributes.getValue(new Attributes.Name("Codebase"));
                        }
                        if (createJarParams.allPermissions == null && (object = attributes.getValue(new Attributes.Name("Permissions"))) != null) {
                            createJarParams.allPermissions = Boolean.valueOf((String)object);
                        }
                    }
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (serializable != null) {
                            try {
                                ((ZipFile)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            ((ZipFile)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_FileReadFailed", serializable2.getAbsolutePath());
            }
        }
        if (createJarParams.applicationClass == null) {
            throw new IllegalArgumentException("Main application class is not specified");
        }
        object2 = new File(createJarParams.outdir, createJarParams.outfile.endsWith(".jar") ? createJarParams.outfile : createJarParams.outfile + ".jar");
        if (serializable2 != null && ((File)object2).getAbsoluteFile().equals(serializable2.getAbsoluteFile())) {
            try {
                serializable = File.createTempFile("tempcopy", ".jar");
                Files.move(serializable2.toPath(), ((File)serializable).toPath(), StandardCopyOption.REPLACE_EXISTING);
                serializable2 = serializable;
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_FileCopyFailed", serializable2.getAbsolutePath());
            }
        }
        if ((serializable = ((File)object2).getParentFile()) != null) {
            ((File)serializable).mkdirs();
        }
        if (manifest == null) {
            manifest = new Manifest();
        }
        attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        if (createJarParams.manifestAttrs != null) {
            object = createJarParams.manifestAttrs.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                attributes.put(new Attributes.Name((String)entry.getKey()), entry.getValue());
            }
        }
        attributes.put(Attributes.Name.MAIN_CLASS, createJarParams.applicationClass);
        if (createJarParams.classpath != null) {
            object = createJarParams.classpath;
            object = ((String)object).replace(';', ' ').replace(',', ' ');
            attributes.put(Attributes.Name.CLASS_PATH, object);
        }
        if ((object = attributes.getValue("Permissions")) == null) {
            attributes.put(new Attributes.Name("Permissions"), Boolean.TRUE.equals(createJarParams.allPermissions) ? "all-permissions" : "sandbox");
        } else if (createJarParams.allPermissions != null && !Boolean.valueOf((String)object).equals(createJarParams.allPermissions)) {
            throw new PackagerException("ERR_ContradictorySetting", "Permissions");
        }
        object = attributes.getValue("Codebase");
        if (object == null) {
            if (createJarParams.codebase != null) {
                attributes.put(new Attributes.Name("Codebase"), createJarParams.codebase);
            }
        } else if (createJarParams.codebase != null && !((String)object).equals(createJarParams.codebase)) {
            throw new PackagerException("ERR_ContradictorySetting", "Codebase");
        }
        attributes.put(new Attributes.Name("JavaFX-Version"), createJarParams.fxVersion);
        if (createJarParams.preloader != null) {
            attributes.put(new Attributes.Name("JavaFX-Preloader-Class"), createJarParams.preloader);
        }
        if (createJarParams.arguments != null) {
            int n = 1;
            for (String object3 : createJarParams.arguments) {
                attributes.put(new Attributes.Name("JavaFX-Argument-" + n), this.encodeAsBase64(object3.getBytes()));
                ++n;
            }
        }
        if (createJarParams.params != null) {
            int n = 1;
            for (Param param : createJarParams.params) {
                if (param.name == null) continue;
                attributes.put(new Attributes.Name("JavaFX-Parameter-Name-" + n), this.encodeAsBase64(param.name.getBytes()));
                if (param.value != null) {
                    attributes.put(new Attributes.Name("JavaFX-Parameter-Value-" + n), this.encodeAsBase64(param.value.getBytes()));
                }
                ++n;
            }
        }
        if (createJarParams.css2bin) {
            try {
                this.bssTmpDir = File.createTempFile("bssfiles", "");
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_CreatingTempFileFailed", new String[0]);
            }
            this.bssTmpDir.delete();
        }
        if (((File)object2).exists() && !((File)object2).delete()) {
            throw new PackagerException("ERR_CantDeleteFile", createJarParams.outfile);
        }
        try {
            this.jar(manifest, createJarParams.resources, (File)serializable2, new JarOutputStream(new FileOutputStream((File)object2)), Filter.ALL);
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_CreatingJarFailed", createJarParams.outfile);
        }
        PackagerLib.deleteDirectory(this.bssTmpDir);
        this.createJarParams = null;
    }

    public void generateDeploymentPackages(DeployParams deployParams) throws PackagerException {
        if (deployParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        try {
            BundleParams bundleParams = deployParams.getBundleParams();
            if (bundleParams != null) {
                this.generateNativeBundles(deployParams.outdir, bundleParams.getBundleParamsAsMap(), "JNLP", "jnlp");
                this.generateNativeBundles(new File(deployParams.outdir, "bundles"), bundleParams.getBundleParamsAsMap(), deployParams.getBundleType().toString(), deployParams.getTargetFormat());
            }
        }
        catch (PackagerException packagerException) {
            throw packagerException;
        }
        catch (Exception exception) {
            throw new PackagerException(exception, "ERR_DeployFailed", exception.getMessage());
        }
    }

    private void generateNativeBundles(File file, Map<String, ? super Object> map, String string, String string2) throws PackagerException {
        if (map.containsKey("runtime")) {
            RelativeFileSet relativeFileSet = BundleParams.getRuntime(map);
            if (relativeFileSet == null) {
                Log.info(bundle.getString("MSG_NoJREPackaged"));
            } else {
                Log.info(MessageFormat.format(bundle.getString("MSG_UserProvidedJRE"), relativeFileSet.getBaseDirectory().getAbsolutePath()));
                if (Log.isDebug()) {
                    relativeFileSet.dump();
                }
            }
        } else {
            Log.info(bundle.getString("MSG_UseSystemJRE"));
        }
        for (Bundler bundler : Bundlers.createBundlersInstance().getBundlers(string)) {
            if (string2 != null && !string2.equalsIgnoreCase(bundler.getID())) continue;
            HashMap<String, ? super Object> hashMap = new HashMap<String, Object>(map);
            try {
                File file2;
                if (!bundler.validate(hashMap) || (file2 = bundler.execute(hashMap, file)) != null) continue;
                throw new PackagerException("MSG_BundlerFailed", bundler.getID(), bundler.getName());
            }
            catch (UnsupportedPlatformException unsupportedPlatformException) {
                Log.debug(MessageFormat.format(bundle.getString("MSG_BundlerPlatformException"), bundler.getName()));
            }
            catch (ConfigException configException) {
                Log.debug(configException);
                if (configException.getAdvice() != null) {
                    Log.info(MessageFormat.format(bundle.getString("MSG_BundlerConfigException"), bundler.getName(), configException.getMessage(), configException.getAdvice()));
                    continue;
                }
                Log.info(MessageFormat.format(bundle.getString("MSG_BundlerConfigExceptionNoAdvice"), bundler.getName(), configException.getMessage()));
            }
            catch (RuntimeException runtimeException) {
                Log.info(MessageFormat.format(bundle.getString("MSG_BundlerRuntimeException"), bundler.getName(), runtimeException.toString()));
                Log.debug(runtimeException);
            }
        }
    }

    public void generateBSS(CreateBSSParams createBSSParams) throws PackagerException {
        if (createBSSParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.createBssParams = createBSSParams;
        this.createBinaryCss(this.createBssParams.resources, this.createBssParams.outdir);
        this.createBssParams = null;
    }

    public void signJar(SignJarParams signJarParams) throws PackagerException {
        try {
            JarSignature jarSignature = this.retrieveSignature(signJarParams);
            for (PackagerResource packagerResource : signJarParams.resources) {
                this.signFile(packagerResource, jarSignature, signJarParams.outdir, signJarParams.verbose);
            }
        }
        catch (Exception exception) {
            Log.verbose(exception);
            throw new PackagerException("ERR_SignFailed", exception);
        }
    }

    private JarSignature retrieveSignature(SignJarParams signJarParams) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, InvalidKeyException {
        if (signJarParams.keyPass == null) {
            signJarParams.keyPass = signJarParams.storePass;
        }
        if (signJarParams.keyStore == null) {
            throw new IOException("No keystore specified");
        }
        if (signJarParams.storePass == null) {
            throw new IOException("No store password specified");
        }
        if (signJarParams.storeType == null) {
            throw new IOException("No store type is specified");
        }
        KeyStore keyStore = KeyStore.getInstance(signJarParams.storeType);
        keyStore.load(new FileInputStream(signJarParams.keyStore), signJarParams.storePass.toCharArray());
        Certificate[] certificateArray = keyStore.getCertificateChain(signJarParams.alias);
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(signJarParams.alias, signJarParams.keyPass.toCharArray());
        return JarSignature.create(privateKey, x509CertificateArray);
    }

    private void signFile(PackagerResource packagerResource, JarSignature jarSignature, File file, boolean bl) throws NoSuchAlgorithmException, IOException, SignatureException {
        if (packagerResource.getFile().isDirectory()) {
            File[] fileArray = packagerResource.getFile().listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.signFile(new PackagerResource(packagerResource.getBaseDir(), file2), jarSignature, file, bl);
                }
            }
        } else {
            File file3;
            File file4 = packagerResource.getFile();
            File file5 = file4.getParentFile();
            String string = "bsigned_" + file4.getName();
            File file6 = new File(file5, string);
            System.out.println("Signing (BLOB) " + file4.getPath());
            this.signAsBLOB(file4, file6, jarSignature);
            if (file != null) {
                file3 = new File(file, packagerResource.getRelativePath());
            } else {
                file4.delete();
                file3 = file4;
            }
            file3.delete();
            file3.getParentFile().mkdirs();
            file6.renameTo(file3);
            if (bl) {
                System.out.println("Signed as " + file3.getPath());
            }
        }
    }

    private void signAsBLOB(File file, File file2, JarSignature jarSignature) throws IOException, NoSuchAlgorithmException, SignatureException {
        if (jarSignature == null) {
            throw new IllegalStateException("Should retrieve signature first");
        }
        JarSignature.InputStreamSource inputStreamSource = () -> new FileInputStream(file);
        if (!file2.isFile()) {
            file2.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        jarSignature.signJarAsBLOB(inputStreamSource, new ZipOutputStream(fileOutputStream));
    }

    public void makeAll(MakeAllParams makeAllParams) throws PackagerException {
        Object object;
        Object object2;
        String string = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        String string2 = System.getenv("JAVA_HOME");
        if (string2 == null) {
            string2 = System.getProperty("java.home");
        }
        if (string2 == null) {
            throw new PackagerException("ERR_MissingJavaHome");
        }
        File file = new File(new File(string2), "bin/javac" + string);
        String string3 = System.getenv("JAVAFX_HOME");
        if (string3 == null) {
            string3 = System.getProperty("javafx.home");
        }
        if (string3 == null) {
            throw new PackagerException("ERR_MissingJavaFxHome");
        }
        File file2 = new File("dist");
        File file3 = new File("compiled");
        file3.mkdir();
        try {
            int n;
            object2 = File.createTempFile("javac", "sources", new File("."));
            ((File)object2).deleteOnExit();
            object = new FileWriter((File)object2);
            Throwable throwable = null;
            try {
                PackagerLib.scanAndCopy(new PackagerResource(new File("src"), "."), (Writer)object, file3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStreamWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStreamWriter)object).close();
                    }
                }
            }
            object = string3 + "/../rt/lib/ext/jfxrt.jar";
            if (makeAllParams.classpath != null) {
                object = (String)object + File.pathSeparator + makeAllParams.classpath;
            }
            if (makeAllParams.verbose) {
                System.out.println("Executing javac:");
                System.out.printf("%s %s %s %s %s %s%n", file.getAbsolutePath(), "-d", "compiled", "-cp", object, "@" + ((File)object2).getAbsolutePath());
            }
            if ((n = PackagerLib.execute(file.getAbsolutePath(), "-d", "compiled", "-cp", object, "@" + ((File)object2).getAbsolutePath())) != 0) {
                throw new PackagerException("ERR_JavacFailed", Integer.toString(n));
            }
        }
        catch (PackagerException packagerException) {
            throw packagerException;
        }
        catch (Exception exception) {
            throw new PackagerException(exception, "ERR_MakeAllJavacFailed", new String[0]);
        }
        object2 = new CreateJarParams();
        ((CreateJarParams)object2).applicationClass = makeAllParams.appClass;
        ((CreateJarParams)object2).preloader = makeAllParams.preloader;
        ((CreateJarParams)object2).classpath = makeAllParams.classpath;
        ((CreateJarParams)object2).css2bin = false;
        ((CreateJarParams)object2).outdir = file2;
        ((CreateJarParams)object2).outfile = "dist.jar";
        ((CreateJarParams)object2).addResource(file3, ".");
        this.packageAsJar((CreateJarParams)object2);
        object = new DeployParams();
        ((DeployParams)object).applicationClass = makeAllParams.appClass;
        ((DeployParams)object).appName = makeAllParams.appName;
        ((DeployParams)object).description = "Application description";
        ((DeployParams)object).height = makeAllParams.height;
        ((DeployParams)object).width = makeAllParams.width;
        ((DeployParams)object).vendor = "Application vendor";
        ((DeployParams)object).outdir = file2;
        ((DeployParams)object).outfile = "dist";
        ((DeployParams)object).addResource(file2, "dist.jar");
        ((DeployParams)object).setBundleType(Bundler.BundleType.ALL);
        this.generateDeploymentPackages((DeployParams)object);
        PackagerLib.deleteDirectory(file3);
    }

    private static int execute(Object ... objectArray) throws IOException, InterruptedException {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : objectArray) {
            if (object2 instanceof List) {
                arrayList.addAll((List)object2);
                continue;
            }
            if (!(object2 instanceof String)) continue;
            arrayList.add((String)object2);
        }
        Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Thread thread = new Thread(() -> {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            catch (IOException iOException) {
                Log.verbose(iOException);
            }
        });
        thread.setDaemon(true);
        thread.start();
        object2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        thread = new Thread(() -> PackagerLib.lambda$execute$2((BufferedReader)object2));
        thread.setDaemon(true);
        thread.start();
        return process.waitFor();
    }

    private static void scanAndCopy(PackagerResource packagerResource, Writer writer, File file) throws PackagerException {
        if (!packagerResource.getFile().exists()) {
            throw new PackagerException("ERR_MissingDirectory", packagerResource.getFile().getName());
        }
        File[] fileArray = packagerResource.getFile().listFiles();
        if (fileArray == null || fileArray.length == 0) {
            throw new PackagerException("ERR_EmptySourceDirectory", packagerResource.getFile().getName());
        }
        try {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    PackagerLib.scanAndCopy(new PackagerResource(packagerResource.getBaseDir(), file2), writer, file);
                    continue;
                }
                if (file2.getName().endsWith(".java")) {
                    writer.write('\'' + file2.getAbsolutePath().replace('\\', '/') + "'\n");
                    continue;
                }
                PackagerLib.copyFileToOutDir(new FileInputStream(file2), new File(file.getPath() + File.separator + packagerResource.getRelativePath() + File.separator + file2.getName()));
            }
        }
        catch (IOException iOException) {
            throw new PackagerException("ERR_FileCopyFailed", packagerResource.getFile().getName());
        }
    }

    private String encodeAsBase64(byte[] byArray) {
        return Base64.getEncoder().encodeToString(byArray);
    }

    private static void copyFileToOutDir(InputStream inputStream, File file) throws PackagerException {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new PackagerException("ERR_CreatingDirFailed", file2.getPath());
        }
        try (InputStream inputStream2 = inputStream;
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream2.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_FileCopyFailed", file2.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(Manifest manifest, List<PackagerResource> list, File file, JarOutputStream jarOutputStream, Filter filter) throws IOException, PackagerException {
        try {
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/"));
            jarOutputStream.closeEntry();
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(jarOutputStream);
            jarOutputStream.closeEntry();
            this.alreadyAddedEntries.add("META-INF/");
            if (file != null) {
                this.copyFromOtherJar(jarOutputStream, file);
            } else {
                for (PackagerResource packagerResource : list) {
                    this.jar(packagerResource.getFile(), jarOutputStream, filter, packagerResource.getBaseDir().getAbsolutePath().length() + 1);
                }
            }
        }
        finally {
            jarOutputStream.close();
            this.alreadyAddedEntries.clear();
        }
    }

    private void createParentEntries(String string, JarOutputStream jarOutputStream) throws IOException {
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]).append("/");
            if (!this.alreadyAddedEntries.contains(stringBuilder.toString())) {
                jarOutputStream.putNextEntry(new ZipEntry(stringBuilder.toString()));
                jarOutputStream.closeEntry();
            }
            this.alreadyAddedEntries.add(stringBuilder.toString());
        }
    }

    private void copyFromOtherJar(JarOutputStream jarOutputStream, File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if ("META-INF/MANIFEST.MF".equals(jarEntry.getName().toUpperCase()) || "META-INF/".equals(jarEntry.getName().toUpperCase())) continue;
            jarOutputStream.putNextEntry(new JarEntry(jarEntry.getName()));
            byte[] byArray = new byte[65000];
            try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                int n;
                while ((n = inputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n);
                }
            }
            jarOutputStream.closeEntry();
        }
    }

    private void jar(File object, JarOutputStream jarOutputStream, Filter filter, int n) throws IOException, PackagerException {
        if (!((File)object).exists()) {
            throw new FileNotFoundException("Input folder does not exist [" + ((File)object).getAbsolutePath() + "]");
        }
        if (((File)object).isDirectory()) {
            File[] fileArray = ((File)object).listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    this.jar(file, jarOutputStream, filter, n);
                }
            }
        } else if (filter == Filter.ALL || filter == Filter.CLASSES_ONLY && ((File)object).getName().endsWith(".class") || filter == Filter.RESOURCES && this.isResource(((File)object).getAbsolutePath())) {
            Object object2;
            String string = ((File)object).getAbsolutePath();
            if (string.endsWith("META-INF\\MANIFEST.MF") || string.endsWith("META-INF/MANIFEST.MF")) {
                return;
            }
            this.createParentEntries(string.substring(n).replace('\\', '/'), jarOutputStream);
            if (this.createJarParams.css2bin && ((File)object).getName().endsWith(".css")) {
                int n2 = string.lastIndexOf(".") + 1;
                String string2 = string.substring(n, n2).concat("bss");
                object2 = new File(this.bssTmpDir, string2);
                ((File)object2).getParentFile().mkdirs();
                this.createBinaryCss(string, ((File)object2).getAbsolutePath());
                jarOutputStream.putNextEntry(new ZipEntry(string2.replace('\\', '/')));
                object = object2;
            } else {
                jarOutputStream.putNextEntry(new ZipEntry(string.substring(n).replace('\\', '/')));
            }
            byte[] byArray = new byte[65000];
            object2 = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                int n3;
                while ((n3 = ((FileInputStream)object2).read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FileInputStream)object2).close();
                    }
                }
            }
            jarOutputStream.closeEntry();
        }
    }

    private void createBinaryCss(List<PackagerResource> list, File file) throws PackagerException {
        for (PackagerResource packagerResource : list) {
            String string = packagerResource.getRelativePath();
            this.createBinaryCss(packagerResource.getFile(), file, string);
        }
    }

    private void createBinaryCss(File file, File file2, String string) throws PackagerException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    this.createBinaryCss(file3, file2, string + '/' + file3.getName());
                }
            }
        } else if (file.getName().endsWith(".css")) {
            String string2 = file.getAbsolutePath();
            String string3 = new File(file2.getAbsolutePath(), PackagerLib.replaceExtensionByBSS(string)).getAbsolutePath();
            this.createBinaryCss(string2, string3);
        }
    }

    private String getJfxrtPath() throws PackagerException {
        Class<PackagerLib> clazz = PackagerLib.class;
        String string = "PackagerLib.class";
        String string2 = clazz.getResource(string).toString();
        if (!string2.startsWith("jar:file:") || !string2.contains("!")) {
            throw new PackagerException("ERR_CantFindRuntime");
        }
        string2 = string2.substring(0, string2.lastIndexOf("!"));
        int n = Math.max(string2.lastIndexOf("/"), string2.lastIndexOf("\\"));
        return string2.substring(0, n) + "/../rt/lib/ext/jfxrt.jar!/";
    }

    private Class loadClassFromRuntime(String string) throws PackagerException {
        try {
            ClassLoader classLoader = this.getClassLoader();
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PackagerException(classNotFoundException, "ERR_CantFindRuntime", new String[0]);
        }
    }

    private void createBinaryCss(String string, String string2) throws PackagerException {
        Class clazz;
        String string3 = string2 != null ? string2 : PackagerLib.replaceExtensionByBSS(string);
        File file = new File(string3);
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            clazz = Class.forName("com.sun.javafx.css.parser.Css2Bin");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.loadClassFromRuntime("com.sun.javafx.css.parser.Css2Bin");
        }
        try {
            Method method = clazz.getMethod("convertToBinary", String.class, String.class);
            method.invoke(null, string, string3);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            String string4 = throwable != null ? throwable.getMessage() : bundle.getString("ERR_UnknownReason");
            throw new PackagerException(exception, "ERR_BSSConversionFailed", string, string4);
        }
    }

    private static String replaceExtensionByBSS(String string) {
        return string.substring(0, string.lastIndexOf(".") + 1).concat("bss");
    }

    private boolean isResource(String string) {
        if (string.endsWith(".class")) {
            return false;
        }
        if (string.endsWith(".java")) {
            return false;
        }
        if (string.endsWith(".fx")) {
            return false;
        }
        if (string.endsWith(".cvsignore")) {
            return false;
        }
        if (string.endsWith(".hgignore")) {
            return false;
        }
        if (string.endsWith("vssver.scc")) {
            return false;
        }
        if (string.endsWith(".DS_Store")) {
            return false;
        }
        if (string.endsWith("~")) {
            return false;
        }
        if ((string = string.replace('\\', '/')).contains("/CVS/")) {
            return false;
        }
        if (string.contains("/.svn/")) {
            return false;
        }
        if (string.contains("/.hg/")) {
            return false;
        }
        if (string.contains("/.#")) {
            return false;
        }
        if (string.contains("/._")) {
            return false;
        }
        if (string.endsWith("#") && string.contains("/#")) {
            return false;
        }
        if (string.endsWith("%") && string.contains("/%")) {
            return false;
        }
        return !string.endsWith("MANIFEST.MF");
    }

    private static boolean deleteDirectory(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            for (String string : file.list()) {
                PackagerLib.deleteDirectory(new File(file, string));
            }
        }
        return file.delete();
    }

    private static /* synthetic */ void lambda$execute$2(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                System.err.println(string);
            }
        }
        catch (IOException iOException) {
            Log.verbose(iOException);
        }
    }

    private static enum Filter {
        ALL,
        CLASSES_ONLY,
        RESOURCES;

    }
}

