/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;

public class Transform
extends Resource {
    public double[] handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] fArray) {
        this(device, Transform.checkTransform(fArray)[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
    }

    public Transform(Device device, float f, float f2, float f3, float f4, float f5, float f6) {
        super(device);
        this.device.checkCairo();
        this.handle = new double[6];
        if (this.handle == null) {
            SWT.error(2);
        }
        Cairo.cairo_matrix_init(this.handle, f, f2, f3, f4, DPIUtil.autoScaleUp(f5), DPIUtil.autoScaleUp(f6));
        this.init();
    }

    static float[] checkTransform(float[] fArray) {
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        return fArray;
    }

    @Override
    void destroy() {
        this.handle = null;
    }

    public void getElements(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        if (fArray.length < 6) {
            SWT.error(5);
        }
        fArray[0] = (float)this.handle[0];
        fArray[1] = (float)this.handle[1];
        fArray[2] = (float)this.handle[2];
        fArray[3] = (float)this.handle[3];
        fArray[4] = DPIUtil.autoScaleDown((float)this.handle[4]);
        fArray[5] = DPIUtil.autoScaleDown((float)this.handle[5]);
    }

    public void identity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_init(this.handle, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (Cairo.cairo_matrix_invert(this.handle) != 0) {
            SWT.error(10);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float[] fArray = new float[6];
        this.getElements(fArray);
        return fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 0.0f;
    }

    public void multiply(Transform transform) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        Cairo.cairo_matrix_multiply(this.handle, transform.handle, this.handle);
    }

    public void rotate(float f) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_rotate(this.handle, f * (float)Math.PI / 180.0f);
    }

    public void scale(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_scale(this.handle, f, f2);
    }

    public void setElements(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_init(this.handle, f, f2, f3, f4, DPIUtil.autoScaleUp(f5), DPIUtil.autoScaleUp(f6));
    }

    public void shear(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        double[] dArray = new double[]{1.0, f, f2, 1.0, 0.0, 0.0};
        Cairo.cairo_matrix_multiply(this.handle, dArray, this.handle);
    }

    public void transform(float[] fArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (fArray == null) {
            SWT.error(4);
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        int n = fArray.length / 2;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            dArray[0] = DPIUtil.autoScaleUp(fArray[n3]);
            dArray2[0] = DPIUtil.autoScaleUp(fArray[n3 + 1]);
            Cairo.cairo_matrix_transform_point(this.handle, dArray, dArray2);
            fArray[n3] = DPIUtil.autoScaleDown((float)dArray[0]);
            fArray[n3 + 1] = DPIUtil.autoScaleDown((float)dArray2[0]);
            ++n2;
            n3 += 2;
        }
    }

    public void translate(float f, float f2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Cairo.cairo_matrix_translate(this.handle, DPIUtil.autoScaleUp(f), DPIUtil.autoScaleUp(f2));
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] fArray = new float[6];
        this.getElements(fArray);
        return "Transform {" + fArray[0] + "," + fArray[1] + "," + fArray[2] + "," + fArray[3] + "," + fArray[4] + "," + fArray[5] + "}";
    }
}

