/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataElement;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import java.io.IOException;

public class DataToolEntry
implements TeXObject {
    private DataToolSty sty;
    private int column;
    private TeXObject contents;

    public DataToolEntry(DataToolSty dataToolSty, int n) {
        this(dataToolSty, n, new TeXObjectList());
    }

    public DataToolEntry(DataToolSty dataToolSty, int n, TeXObject teXObject) {
        this.sty = dataToolSty;
        this.setColumnIndex(n);
        this.setContents(teXObject);
    }

    @Override
    public Object clone() {
        return new DataToolEntry(this.sty, this.column, (TeXObject)this.contents.clone());
    }

    public int getColumnIndex() {
        return this.column;
    }

    public void setColumnIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid column index " + n);
        }
        this.column = n;
    }

    public TeXObject getContents() {
        return this.contents;
    }

    public void setContents(TeXObject teXObject) {
        if (teXObject instanceof DataElement) {
            this.contents = teXObject;
        } else {
            try {
                DataElement dataElement = this.sty.getElement(teXObject);
                this.contents = dataElement == null ? teXObject : dataElement;
            }
            catch (IOException iOException) {
                this.contents = teXObject;
            }
        }
    }

    public static DataToolEntry toEntry(TeXParser teXParser, TeXObjectList teXObjectList, DataToolSty dataToolSty) throws IOException {
        TeXObjectList teXObjectList2;
        TeXObject teXObject = teXObjectList.peekStack();
        if (teXObject instanceof DataToolEntry) {
            return (DataToolEntry)teXObjectList.popToken();
        }
        if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("db@row@id@w")) {
            return null;
        }
        if (!teXObjectList.popCsMarker(teXParser, "db@col@id@w")) {
            return null;
        }
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        int n = numerical.number(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@col@id@end@");
        teXObjectList.popCsMarker(teXParser, "db@col@elt@w");
        teXObject = teXObjectList.popToCsMarker(teXParser, "db@col@elt@end@", (byte)(TeXObjectList.POP_RETAIN_IGNOREABLES | TeXObjectList.POP_IGNORE_LEADING_SPACE));
        if (dataToolSty.isExpansionOn() && teXObject instanceof Expandable && (teXObjectList2 = teXObjectList == teXParser ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObject = teXObjectList2;
        }
        teXObjectList.popCsMarker(teXParser, "db@col@id@w");
        numerical = teXObjectList.popNumerical(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@col@id@end@");
        int n2 = numerical.number(teXParser);
        if (n != n2) {
            throw new LaTeXSyntaxException(teXParser, "datatool.mismatched", String.format("\\db@col@id@w %d\\db@col@id@end@", n), String.format("\\db@col@id@w %d\\db@col@id@end@", n2));
        }
        try {
            return new DataToolEntry(dataToolSty, n, teXObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LaTeXSyntaxException(illegalArgumentException, teXParser, "latex.package.error", illegalArgumentException.getMessage());
        }
    }

    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(new TeXCsRef("db@col@id@w"));
        teXObjectList.add(new UserNumber(this.column));
        teXObjectList.add(new TeXCsRef("db@col@id@end@"));
        teXObjectList.add(new TeXCsRef("db@col@elt@w"));
        teXObjectList.add((TeXObject)this.contents.clone());
        teXObjectList.add(new TeXCsRef("db@col@elt@end@"));
        teXObjectList.add(new TeXCsRef("db@col@id@w"));
        teXObjectList.add(new UserNumber(this.column));
        teXObjectList.add(new TeXCsRef("db@col@id@end@"));
        return teXObjectList;
    }

    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.expandonce(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.addAll(0, this.expandonce(teXParser, teXObjectList));
    }

    @Override
    public String toString(TeXParser teXParser) {
        try {
            return this.expandonce(teXParser).toString(teXParser);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).string(teXParser);
    }

    @Override
    public String format() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).format();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public boolean isPar() {
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DataToolEntry)) {
            return false;
        }
        DataToolEntry dataToolEntry = (DataToolEntry)object;
        if (dataToolEntry.column != this.column) {
            return false;
        }
        return this.contents.equals(dataToolEntry.contents);
    }

    public String toString() {
        return String.format("%s[column=%d,contents=%s]", this.getClass().getSimpleName(), this.column, this.contents);
    }
}

